<?php require_once('header.php'); ?>

<div id="options">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-6 col-sm-offset-3">
                
                <h1>Flipout Options</h1>

                <p>To begin using Flipout select your range below and select either Outs or Setups.</p>

                <form id="optionsForm" method="GET" action="/play">

                    <input type="hidden" id="action" name="action" value="get-all" />

                    <label>Select your range</label>
                	<div class="row no-gutters">
                		<div class="col-xs-6">
                            <div class="form-group displayer">
                                <label for="minRange">Min</label>
                                <input type="text" id="minRange" name="min" class="text-center form-control" value="" disabled/>
                            </div>
                		</div>
                		<div class="col-xs-6">
                            <div class="form-group displayer">
                                <label for="maxRange">Max</label>
                                <input type="text" id="maxRange" name="max" class="text-center form-control" value="" disabled/>
                            </div>
                		</div>
                	</div>

                	<div class="row">
                		<div class="col-xs-12">
                			<div class="form-group">
                				<div id="rangeSlider"></div>
                			</div>
                		</div>
                	</div>

                    <div class="row">
                    	<div class="col-xs-6 col-sm-12 col-md-4">
                    		<div class="form-group last">
                    			<button type="button" class="btn btn-blue btn-block btn-api" data-action="get-checkouts">Checkouts</button>
                    		</div>
                    	</div>
                    	<div class="col-xs-6 col-sm-12 col-md-4">
                    		<div class="form-group last">
                    			<button type="button" class="btn btn-blue btn-block btn-api" data-action="get-setups">Setups</button>
                    		</div>
                    	</div>
                    </div>

                    <hr />

                    <label>Quickstart</label>
                    <p>These options will load all cards from the selected item.</p>
                    <div class="row">
                    	<div class="col-xs-4">
                    		<div class="form-group">
                    			<button type="button" class="btn btn-orange btn-block btn-api" data-action="get-all-checkouts">Outs</button>
                    		</div>
                    	</div>
                    	<div class="col-xs-4">
                    		<div class="form-group">
                    			<button type="button" class="btn btn-orange btn-block btn-api" data-action="get-all-setups">Setups</button>
                    		</div>
                    	</div>
                        <div class="col-xs-4">
                            <div class="form-group">
                                <button type="button" class="btn btn-orange btn-block btn-api" data-action="get-all">Both</button>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<div id="cardLoaderWrap" class="vblock">
    <div class="vblock-content">
        <p>Loading Cards</p>
        <div class="loading-dots">
            <div class="loading-dots--dot"></div>
            <div class="loading-dots--dot"></div>
            <div class="loading-dots--dot"></div>
        </div>
    </div>
</div>

<div id="deckWrap" class="hidden">
    <div id="deck">
        <div id="activeCard" class="card">
            <div class="number"></div>
            <div class="about">
                <div class="option"></div>
                <div class="details"></div>
                <div class="option2"></div>
                <div class="option3"></div>
            </div>
        </div>
    </div>
    <div id="deckNav">
        <div class="container">
            <div class="row">
                <div class="col-xs-12">
                    <div class="form-group">
                        <button id="showAnswer" class="btn btn-block btn-green">Answer</button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <div class="form-group last">
                        <button id="prevCard" class="btn btn-block btn-orange"><i class="fa fa-chevron-left"></i></button>
                    </div>
                </div>
                <div class="col-xs-6">
                    <div class="form-group last">
                        <button id="nextCard" class="btn btn-block btn-orange"><i class="fa fa-chevron-right"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    jQuery(function($){

        var cardLoader = $('#cardLoaderWrap');
        var cards = null;
        var activeIndex = 0;

        var rangeSlider = document.getElementById('rangeSlider');
        noUiSlider.create(rangeSlider, {
            start: [2,315],
            step: 1,
            connect: true,
            range: {
                'min': 2,
                'max': 315
            },
            format: {
                to: function(value){
                    return Math.round(value);
                },
                from: function(value){
                    return Math.round(value);
                }
            }
        });

        rangeSlider.noUiSlider.on('update', function(values, handle){
            $('#minRange').val(values[0]);
            $('#maxRange').val(values[1]);
        });

        $('.btn-api').on('click', function(){
            cards = null;
            activeIndex = 0;
            var url = '/api/'+$(this).data('action')+'/?min='+$('#minRange').val()+'&max='+$('#maxRange').val();

            cardLoader.toggleClass('opened');
            $.get(url, function(response){
                if(response.success){
                    cards = response.data.cards;
                    console.log(cards);
                    build_card();
                    cardLoader.toggleClass('opened');
                    $('#options, #deckWrap').toggleClass('hidden');
                }else{
                    cardLoader.toggleClass('opened');
                    swal({
                        type: 'error',
                        title: 'Error!',
                        text: response.data.message,
                        allowOutsideClick: false,
                        allowEscapeKey: false
                    });
                }
            }).fail(function(){
                cardLoader.toggleClass('opened');
                swal({
                    type: 'error',
                    title: 'Error!',
                    text: 'There was an error getting your cards. Please try again.',
                    allowOutsideClick: false,
                    allowEscapeKey: false
                });
            });
        });

        $('#restart').on('click', function(){
            cards = null;
            deck.html('');
            $('#options, #deckWrap').toggleClass('hidden');
        });

        $('#showAnswer').on('click', function(){
            $('#activeCard').toggleClass('opened');
        });

        $('#prevCard').on('click', function(){
            if(activeIndex!=0){
                if($('#activeCard').hasClass('opened')){
                    $('#activeCard').removeClass('opened');
                }
                activeIndex--;
                build_card();
            }
        });

        $('#nextCard').on('click', function(){
            if(activeIndex!=cards.length){
                if($('#activeCard').hasClass('opened')){
                    $('#activeCard').removeClass('opened');
                }
                activeIndex++;
                build_card();
            }
        });

        function build_card() {
            var activeCard = $('#activeCard'),
                $out = activeCard.find('.number'),
                $details = activeCard.find('.details'),
                $option = activeCard.find('.option'),
                $option2 = activeCard.find('.option2'),
                $option3 = activeCard.find('.option3');

            $out.html(cards[activeIndex].outnum);
            if(cards[activeIndex].details) { $details.html(cards[activeIndex].details); }else{ $details.html(''); }
            if(cards[activeIndex].option1) { $option.html(cards[activeIndex].option1); }else{ $option.html(''); }
            if(cards[activeIndex].option2) { $option2.html('Option 2: '+cards[activeIndex].option2); }else{ $option2.html(''); }
            if(cards[activeIndex].option3) { $option3.html('Option 3: '+cards[activeIndex].option3); }else{ $option3.html(''); }
        }
    });
</script>

<?php require_once('footer.php'); ?>