var appFilters = angular.module('appFilters', [])

	.filter('nl2br', function($sce){
	    return function(msg,is_xhtml) { 
	        var is_xhtml = is_xhtml || true;
	        var breakTag = (is_xhtml) ? '<br />' : '<br>';
	        var msg = (msg + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'$2');
	        return $sce.trustAsHtml(msg);
	    }
	})

	.filter('routFromId', function($filter,$sessionStorage){
	    return function(rout){
	        var routine = '';
	        angular.forEach($sessionStorage.appRoutines, function(value, key) {
	            if(value.id == rout){
	                routine = value.routineName;
	            }
	        });
	        return routine;
	    }
	})

	.filter('dayFromId', function($filter,$rootScope,$sessionStorage){
	    return function(day){
	        var name = '';
	        angular.forEach($rootScope.daysWeek, function(value, key) {
	            if(key == day){
	                name = value;
	            }
	        });
	        return name;
	    }
	});