<?php
  if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
    die ('Please do not load this page directly. Thanks!');

  if ( post_password_required() ) { ?>
  	<div class="alert alert-info"><?php _e("This post is password protected. Enter the password to view comments.","bonestheme"); ?></div>
  <?php
    return;
  }
?>

<?php 

if ( have_comments() ) : 

	if ( ! empty($comments_by_type['comment']) ) :
	?>

		<h3 id="comments">
			<?php comments_number('<span>' . __("No","bonestheme") . '</span> ' . __("Responses","bonestheme") . '', '<span>' . __("One","bonestheme") . '</span> ' . __("Response","bonestheme") . '', '<span>%</span> ' . __("Responses","bonestheme") );?> <?php _e("to","bonestheme"); ?> &#8220;<?php the_title(); ?>&#8221;</h3>
	
		<ol class="commentlist">
			<?php wp_list_comments('type=comment&callback=bones_comments'); ?>
		</ol>
	
	<?php 
	endif; 

	if ( ! empty($comments_by_type['pings']) ) : 
	?>
		<h3 id="pings">Trackbacks/Pingbacks</h3>
		
		<ol class="pinglist">
			<?php wp_list_comments('type=pings&callback=list_pings'); ?>
		</ol>
	<?php 
	endif; 

	else : // this is displayed if there are no comments so far 

	if ( comments_open() ) : 
    	// If comments are open, but there are no comments.

	else : // comments are closed 
	
		$suppress_comments_message = get_option('suppress_comments_message');
		if (is_page() || is_single() && $suppress_comments_message) :
		
		else : 
		?>
			<p class="alert alert-info"><?php _e("Comments are closed","bonestheme"); ?>.</p>
		<?php 
		endif; 

	endif;

endif; ?>


<?php if ( comments_open() ) : ?>

<section id="respond" class="respond-form">

	<h3 id="comment-form-title"><?php comment_form_title( __("Leave a Reply","bonestheme"), __("Leave a Reply to","bonestheme") . ' %s' ); ?></h3>

	<div id="cancel-comment-reply">
		<p class="small"><?php cancel_comment_reply_link( __("Cancel","bonestheme") ); ?></p>
	</div>

	<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
  	<div class="help">
  		<p><?php _e("You must be","bonestheme"); ?> <a href="<?php echo wp_login_url( get_permalink() ); ?>"><?php _e("logged in","bonestheme"); ?></a> <?php _e("to post a comment","bonestheme"); ?>.</p>
  	</div>
	<?php else : ?>

	<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" class="form-vertical" id="commentform">

	<?php if ( is_user_logged_in() ) : ?>

	<p class="comments-logged-in-as"><?php _e("Logged in as","bonestheme"); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e("Log out of this account","bonestheme"); ?>"><?php _e("Log out","bonestheme"); ?> &raquo;</a></p>

	<?php else : ?>
	
	<ul id="comment-form-elements" class="clearfix">
		<li>
			<div class="input-group">
			  	<span class="input-group-addon blue"><i class="fa fa-user"></i> <?php _e("Name","bonestheme"); ?> <?php if ($req) echo "*"; ?></span>
			  	<input class="form-control" type="text" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" placeholder="<?php _e("Your Name","bonestheme"); ?>" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> />
		  	</div>
		</li>
		<li>
			<div class="input-group">
			  	<span class="input-group-addon blue"><i class="fa fa-envelope"></i> <?php _e("Mail","bonestheme"); ?> <?php if ($req) echo "*"; ?></span>
			  	<input class="form-control" type="email" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" placeholder="<?php _e("Your Email (will not be published)","bonestheme"); ?>" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> />
			  	
		  	</div>
		</li>
		<li>
			<div class="input-group">
			  <span class="input-group-addon blue"><i class="fa fa-globe"></i> <?php _e("Website","bonestheme"); ?></span>
			  <input class="form-control" type="url" name="url" id="url" value="<?php echo esc_attr($comment_author_url); ?>" placeholder="<?php _e("Your Website","bonestheme"); ?>" tabindex="3" />
		  	</div>
		</li>
	</ul>

	<?php endif; ?>
	
	<div class="clearfix">
		<div class="input">
			<textarea class="form-control" rows="4" name="comment" id="comment" placeholder="<?php _e("Your Comment Here…","bonestheme"); ?>" tabindex="4"></textarea>
		</div>
	</div>
	
	<div class="form-actions">
	  <input class="btn btn-blue" name="submit" type="submit" id="submit" tabindex="5" value="<?php _e("Submit Comment","bonestheme"); ?>" />
	  <?php comment_id_fields(); ?>
	</div>
	
	<?php 
		//comment_form();
		do_action('comment_form()', $post->ID); 
	
	?>
	
	</form>
	
	<?php endif; // If registration required and not logged in ?>
</section>

<?php endif; ?>
