<?php
/**
* Default settings and settings array used trough out the plugin
**/
add_action('init', 'aw_bc_setting_values');
function aw_bc_setting_values() {

	// If this is the first time the plugin is activated, add all default values to the WP option
	add_option('aw_bc_title', 'You are using a web browser not supported by this website!');
	add_option('aw_bc_message', 'You are using a web browser that is not supported by this website. This means that some function may not work as supposed which can result in strange behaviors when browsing around. Use or upgrade/install on of the following browsers to take full advantage of this website. - Thank you!');
	add_option('aw_bc_hide', NULL);
	add_option('aw_bc_show', array(
		'ie' 		=> '',
		'ff' 		=> 'http://www.mozilla.com/en-US/firefox/all.html',
		'safari' 	=> '',
		'opera' 	=> '',
		'chrome' 	=> 'https://www.google.com/chrome'
	));
	add_option('aw_bc_check', array(
		'ie' 		=> '8',
		'ff' 		=> '12',
		'safari' 	=> '4',
		'opera' 	=> '10',
		'chrome' 	=> '20'
	));
	add_option('aw_bc_testing', NULL);

	// Run update function, this is where the plugin version number is update
	aw_bc_update();

	// Return the settings in array format
	return array(
		'title' 		=> get_option('aw_bc_title'),
		'msg' 			=> get_option('aw_bc_message'),
		'hide' 			=> get_option('aw_bc_hide'),
		'show_browser' 	=> get_option('aw_bc_show'),
		'check_browser' => get_option('aw_bc_check'),
		'testing'		=> get_option('aw_bc_testing')
	);
}

/**
* Sets plugin version and there update functions will be added when larger updates is made
**/
function aw_bc_update() {

	// If no version number exists, we need to update the settings to v2.0.0 and above
	if (!get_option('aw_bc_version')) {

		// Get old settings array
		$old_settings = get_option('advanced-browser-check');

		if ($old_settings) {
			// Add the old settings to the new once
			update_option('aw_bc_title', $old_settings['title']);
			update_option('aw_bc_message', $old_settings['msg']);
			update_option('aw_bc_show', $old_settings['show_browser']);
			update_option('aw_bc_check', $old_settings['check_browser']);
			update_option('aw_bc_hide', $old_settings['hide']);
		}

		// Delete the old settings array from the DB
		delete_option('advanced-browser-check');

	}

	update_option('aw_bc_version', AW_BC_VERSION);

}

/**
* Default browsers settings. This builds the browser dropdowns on the admin page
**/
function aw_bc_default_browsers() {
	return array(
		'safari'	=> array(0,3,4,5,6,7,8,9,10),
		'opera'		=> array(0,7,8,9,10,11,12,13,14,15,16,17,18,19,20),
		'ff' 		=> array(0,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30),
		'chrome'	=> array(0,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35),
		'ie'		=> array(0,5,6,7,8,9,10,11,12,13,14)
	);
}

/**
* Styles and scripts needed for the plugin to work
**/
function aw_bc_scripts() {
	// Load jQuery
	wp_enqueue_script("jquery");

	if(!(is_mobile() || is_tablet())){
		// jQuery cookie, used to add a cookie so visitors can hide the popup
		wp_enqueue_script("jquery.cookie", plugins_url('/js/jquery.cookie.js', __FILE__));

		// The ajax request so the plugin works with caching plugins
		wp_enqueue_script("aw_bc_script", plugins_url('/js/aw_bc_script.js', __FILE__));
	}
}

function aw_bc_styles() {
	if(!(is_mobile() || is_tablet())){
		// Stylesheet for the popup
		wp_enqueue_style("aw_bc_style", plugins_url('/css/aw_bc_style.css', __FILE__));
	}
}

function aw_bc_wrapper() {
	echo "<div id='browser-check' class='modal fade' data-url='".json_encode(array("abc_url" => plugins_url("aw-browser-check.php",__FILE__)))."'></div>";
}

class aw_bc_output {

	/**
	* Check if we should display the popup
	**/
	function html() {
		$user_browser 	= $this->getBrowser();
		$aw_bc_options 	= aw_bc_setting_values();
		$check_browsers = $aw_bc_options['check_browser'];
		$show_browsers 	= $aw_bc_options['show_browser'];
		$title 			= $aw_bc_options['title'];
		$msg 			= $aw_bc_options['msg'];
		$hide 			= $aw_bc_options['hide'];
		$testing		= $aw_bc_options['testing'];

		foreach($check_browsers as $browser => $version) {
			if($testing == 'yes'){
				$ie6 = ($user_browser['short_name'] == 'ie' && $user_browser['version'] <= '6______________________________') ? 'ie6' : '';
				return $this->build_html($title, $msg, $show_browsers, $hide, $ie6);
			}elseif(
				$user_browser['short_name'] == $browser
				&& $user_browser['version'] <= $version.'______________________________'
				&& $user_browser['platform'] != 'android'
				&& $user_browser['platform'] != 'iOS'
				&& $user_browser['platform'] != 'BB10') 
			{
				$ie6 = ($user_browser['short_name'] == 'ie' && $user_browser['version'] <= '6______________________________') ? 'ie6' : '';
				return $this->build_html($title, $msg, $show_browsers, $hide, $ie6);
			}
		}
	}

	/**
	* Build up the HTML for the popup
	**/
	private function build_html($title = NULL, $msg = NULL, $show_browsers = array(), $hide = NULL, $ie6 = '') {
		$html = '<div class="modal-dialog modal-lg">';
		$html .= '<div class="modal-content">';
		$html .= '<div class="modal-header">';
		if($hide) {
			$html .= '<button type="button" class="close abc-hide" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>';
		}
		$html .= '<h4 class="modal-title" id="myModalLabel">'.$title.'</h4>';
		$html .= '</div>';
		$html .= '<div class="modal-body">';
		$html .= nl2br($msg);
		$html .= '<div class="browsers"><table><tr>';
			foreach($show_browsers as $browser => $link) {
				if($link) {
					$html .= '<td>';
						$html .= '<a href="'. $link .'" class="'. $browser .'" target="_blank">';
							$html .= '<img src="'. plugins_url('/img/'. $browser .'-128x128.png', __FILE__) .'" alt="'. $browser .'" class="img-responsive">';
							$html .= '<span class="label label-custom">'.$this->getBrowserName($browser).'</span>';
						$html .= '</a>';
					$html .= '</td>';
				}
			}
		$html .= '</tr></table></div>';
		$html .= '</div>';

		$html .= '</div>';
		$html .= '</div>';

		return $html;
	}

	/**
	* Return full browser name based on the short name
	**/
	private function getBrowserName($short) {

		switch($short) {

			case 'ff':
				$browser = 'Firefox';
				break;

			case 'chrome':
				$browser = 'Chrome';
				break;

			case 'safari':
				$browser = 'Safari';
				break;

			case 'opera':
				$browser = 'Opera';
				break;

			case 'ie':
				$browser = 'IE';
				break;

			default:
				$browser = '';
				break;

		}

		return $browser;

	}

	/**
	* Get the visitors browser, browser version and platform
	**/
	public function getBrowser() {
		$u_agent 	= $_SERVER['HTTP_USER_AGENT'];
		$bname 		= 'Unknown';
		$platform 	= 'Unknown';
		$version	= 'Unknown';
		$short_name = 'Unknown';
		$ub 		= 'Unknown';

		//First get the platform?
		if (preg_match('/android/i', $u_agent)) {
			$platform = 'android';
		} elseif (preg_match('/iphone/i', $u_agent)) {
			$platform = 'iOS';
		} elseif (preg_match('/ipad/i', $u_agent)) {
			$platform = 'iOS';
		} elseif (preg_match('/linux/i', $u_agent)) {
			$platform = 'linux';
		} elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
			$platform = 'mac';
		} elseif (preg_match('/windows|win32/i', $u_agent)) {
			$platform = 'windows';
		}

		// Next get the name of the useragent yes seperately and for good reason
		if (preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) {
			$bname 		= 'Internet Explorer';
			$short_name = "ie";
			$ub 		= "MSIE";
		} elseif (preg_match('/Firefox/i',$u_agent)) {
			$bname 		= 'Mozilla Firefox';
			$short_name = "ff";
			$ub 		= "Firefox";
		} elseif (preg_match('/Chrome/i',$u_agent)) {
			$bname 		= 'Google Chrome';
			$short_name = "chrome";
			$ub 		= "Chrome";
		} elseif (preg_match('/Safari/i',$u_agent)) {
			$bname 		= 'Apple Safari';
			$short_name = "safari";
			$ub 		= "Safari";
		} elseif (preg_match('/Opera/i',$u_agent)) {
			$bname 		= 'Opera';
			$short_name = "opera";
			$ub 		= "Opera";
		}

		// finally get the correct version number
		$known = array('Version', $ub, 'other');
		$pattern = '#(?<browser>' . join('|', $known) . ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
		if (!preg_match_all($pattern, $u_agent, $matches)) {
			// we have no matching number just continue
		}

		// see how many we have
		$i = count($matches['browser']);
		if ($i != 1) {
			//we will have two since we are not using 'other' argument yet
			//see if version is before or after the name
			if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
				$version= $matches['version'][0];
			} else {
		     	$version= $matches['version'][1];
			}
		} else {
			$version= $matches['version'][0];
		}

		// check if we have a number
		// if ($version==null || $version=="") {$version = "unknown";}

		return array(
			'userAgent' 	=> $u_agent,
			'name'      	=> $bname,
			'short_name'	=> $short_name,
			'version'		=> floor($version),
			'platform'  	=> $platform,
			'pattern'    	=> $pattern
		);
	}

}

$display = new aw_bc_output;

$dis_user_browser 	= $display->getBrowser();
$dis_aw_bc_options 	= aw_bc_setting_values();
$dis_check_browsers = $dis_aw_bc_options['check_browser'];
$dis_testing = $dis_aw_bc_options['testing'];

foreach($dis_check_browsers as $browser => $version) {
	if(
		($dis_user_browser['short_name'] == $browser
		&& $dis_user_browser['version'] <= $version.'______________________________'
		&& $dis_user_browser['platform'] != 'android'
		&& $dis_user_browser['platform'] != 'iOS'
		&& $dis_user_browser['platform'] != 'BB10') || $dis_testing == 'yes')
	{
		if(!(is_mobile() || is_tablet())){
			add_action('wp_enqueue_scripts', 'aw_bc_scripts');
			add_action('wp_enqueue_scripts', 'aw_bc_styles');
			add_action('wp_footer','aw_bc_wrapper');
		}
		
	}
}

?>