<?php

/*
--------------------------------------------------------------
CUSTOM POST TYPES
--------------------------------------------------------------
*/

function create_post_types(){
  // Games
  $game_labels = array(
    'name' => 'Games',
    'singular_name' => _x('Game', 'post type singular name'),
    'add_new' => _x('Add New', 'Game'),
    'add_new_item' => __('Add New Game'),
    'edit_item' => __('Edit Game'),
    'new_item' => __('New Game'),
    'view_item' => __('View Game'),
    'search_items' => __('Search Games'),
    'not_found' =>  __('No Game found'),
    'not_found_in_trash' => __('No Game found in Trash'), 
    'parent_item_colon' => '',
    'menu_name' => _x('Games', 'post type general name')
  );

  $game_args = array(
    'labels' => $game_labels,
    'public' => true,
    'publically_queryable' => true,
    'exclude_from_search' => false,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 27,
    'show_in_nav_menus' => true,
    'query_var' => true,
    'rewrite' => array("slug" => 'game'),
    'capability_type' => 'page',
    'hierarchical' => false,
    'has_archive' => true,
    'supports' => array('title', 'editor', 'thumbnail')
  );

  // Routines
  $routine_labels = array(
    'name' => 'Routines',
    'singular_name' => _x('Routine', 'post type singular name'),
    'add_new' => _x('Add New', 'Routine'),
    'add_new_item' => __('Add New Routine'),
    'edit_item' => __('Edit Routine'),
    'new_item' => __('New Routine'),
    'view_item' => __('View Routine'),
    'search_items' => __('Search Routines'),
    'not_found' =>  __('No Routine found'),
    'not_found_in_trash' => __('No Routine found in Trash'), 
    'parent_item_colon' => '',
    'menu_name' => _x('Routines', 'post type general name')
  );

  $routine_args = array(
    'labels' => $routine_labels,
    'public' => true,
    'publically_queryable' => true,
    'exclude_from_search' => false,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 27,
    'show_in_nav_menus' => true,
    'query_var' => true,
    'rewrite' => array("slug" => 'routine'),
    'capability_type' => 'page',
    'hierarchical' => false,
    'has_archive' => true,
    'supports' => array('title', 'editor', 'thumbnail')
  );

  // Promos
  $promo_labels = array(
    'name' => 'Promos',
    'singular_name' => _x('Promo', 'post type singular name'),
    'add_new' => _x('Add New', 'Promo'),
    'add_new_item' => __('Add New Promo'),
    'edit_item' => __('Edit Promo'),
    'new_item' => __('New Promo'),
    'view_item' => __('View Promo'),
    'search_items' => __('Search Promos'),
    'not_found' =>  __('No Promo found'),
    'not_found_in_trash' => __('No Promos found in Trash'), 
    'parent_item_colon' => '',
    'menu_name' => _x('Promos', 'post type general name')
  );

  $promo_args = array(
    'labels' => $promo_labels,
    'public' => true,
    'publically_queryable' => true,
    'exclude_from_search' => false,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 27,
    'show_in_nav_menus' => true,
    'query_var' => true,
    'rewrite' => array("slug" => 'promo'),
    'capability_type' => 'page',
    'hierarchical' => false,
    'has_archive' => true,
    'supports' => array('title', 'editor', 'thumbnail', 'page-attributes')
  );

  // FAQs
  $faqs_labels = array(
    'name' => 'FAQs',
    'singular_name' => _x('FAQ', 'post type singular name'),
    'add_new' => _x('Add New', 'Item'),
    'add_new_item' => __('Add New Item'),
    'edit_item' => __('Edit Item'),
    'new_item' => __('New Item'),
    'view_item' => __('View Item'),
    'search_items' => __('Search Items'),
    'not_found' =>  __('No Item found'),
    'not_found_in_trash' => __('No Items found in Trash'), 
    'parent_item_colon' => '',
    'menu_name' => _x('FAQs', 'post type general name')
  );

  $faqs_args = array(
    'labels' => $faqs_labels,
    'public' => true,
    'publically_queryable' => true,
    'exclude_from_search' => false,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 27,
    'show_in_nav_menus' => true,
    'query_var' => true,
    'rewrite' => array("slug" => 'faq'),
    'capability_type' => 'page',
    'hierarchical' => false,
    'has_archive' => true,
    'supports' => array('title', 'editor', 'thumbnail','page-attributes')
  );

  // Suppliers
  $sup_labels = array(
    'name' => 'Suppliers',
    'singular_name' => _x('Supplier', 'post type singular name'),
    'add_new' => _x('Add New', 'Supplier'),
    'add_new_item' => __('Add New Supplier'),
    'edit_item' => __('Edit Supplier'),
    'new_item' => __('New Supplier'),
    'view_item' => __('View Supplier'),
    'search_items' => __('Search Suppliers'),
    'not_found' =>  __('No Supplier found'),
    'not_found_in_trash' => __('No Suppliers found in Trash'), 
    'parent_item_colon' => '',
    'menu_name' => _x('Suppliers', 'post type general name')
  );

  $sup_args = array(
    'labels' => $sup_labels,
    'public' => true,
    'publically_queryable' => true,
    'exclude_from_search' => false,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 27,
    'show_in_nav_menus' => true,
    'query_var' => true,
    'rewrite' => array("slug" => 'supplier'),
    'capability_type' => 'page',
    'hierarchical' => false,
    'has_archive' => true,
    'supports' => array('title', 'editor', 'thumbnail', 'page-attributes')
  );

  // Leagues
  $leag_labels = array(
    'name' => 'Leagues',
    'singular_name' => _x('League', 'post type singular name'),
    'add_new' => _x('Add New', 'League'),
    'add_new_item' => __('Add New League'),
    'edit_item' => __('Edit League'),
    'new_item' => __('New League'),
    'view_item' => __('View League'),
    'search_items' => __('Search Leagues'),
    'not_found' =>  __('No League found'),
    'not_found_in_trash' => __('No Leagues found in Trash'), 
    'parent_item_colon' => '',
    'menu_name' => _x('Leagues', 'post type general name')
  );

  $leag_args = array(
    'labels' => $leag_labels,
    'public' => true,
    'publically_queryable' => true,
    'exclude_from_search' => false,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 27,
    'show_in_nav_menus' => true,
    'query_var' => true,
    'rewrite' => array("slug" => 'league'),
    'capability_type' => 'page',
    'hierarchical' => false,
    'has_archive' => true,
    'supports' => array('title', 'editor', 'thumbnail', 'page-attributes')
  );

  // Organizations
  $org_labels = array(
    'name' => 'Organizations',
    'singular_name' => _x('Organization', 'post type singular name'),
    'add_new' => _x('Add New', 'Organization'),
    'add_new_item' => __('Add New Organization'),
    'edit_item' => __('Edit Organization'),
    'new_item' => __('New Organization'),
    'view_item' => __('View Organization'),
    'search_items' => __('Search Organizations'),
    'not_found' =>  __('No Organization found'),
    'not_found_in_trash' => __('No Organizations found in Trash'), 
    'parent_item_colon' => '',
    'menu_name' => _x('Organizations', 'post type general name')
  );

  $org_args = array(
    'labels' => $org_labels,
    'public' => true,
    'publically_queryable' => true,
    'exclude_from_search' => false,
    'show_ui' => true,
    'show_in_menu' => true,
    'menu_position' => 27,
    'show_in_nav_menus' => true,
    'query_var' => true,
    'rewrite' => array("slug" => 'organization'),
    'capability_type' => 'page',
    'hierarchical' => false,
    'has_archive' => true,
    'supports' => array('title', 'editor', 'thumbnail', 'page-attributes')
  );

  //register_post_type('game', $game_args);
  //register_post_type('routine', $routine_args);
  register_post_type('promo', $promo_args);
  register_post_type('faq', $faqs_args);
  register_post_type('supplier', $sup_args);
  register_post_type('league', $leag_args);
  register_post_type('organization', $org_args);
}

function create_taxonomies(){
  // Routine Taxonomy
  $rout_tax_labels = array(
    'name'              => _x( 'Routine Types', 'taxonomy general name' ),
    'singular_name'     => _x( 'Routine Types', 'taxonomy singular name' ),
    'search_items'      => __( 'Search Routine Types' ),
    'all_items'         => __( 'All Routine Types' ),
    'parent_item'       => __( 'Parent Routine Types' ),
    'parent_item_colon' => __( 'Parent Routine Type:' ),
    'edit_item'         => __( 'Edit Routine Type' ),
    'update_item'       => __( 'Update Routine Type' ),
    'add_new_item'      => __( 'Add New Routine Type' ),
    'new_item_name'     => __( 'New Routine Type' ),
    'menu_name'         => __( 'Routine Type' ),
  );

  $rout_tax_args = array(
    'hierarchical'      => true,
    'labels'            => $rout_tax_labels,
    'show_ui'           => true,
    'show_admin_column' => true,
    'query_var'         => true,
    'rewrite'           => array( 'slug' => 'routine-type' ),
  );

  // Page Taxonomy
  $page_labels = array(
    'name'              => _x( 'Page Types', 'taxonomy general name' ),
    'singular_name'     => _x( 'Page Type', 'taxonomy singular name' ),
    'search_items'      => __( 'Search Page Types' ),
    'all_items'         => __( 'All Page Types' ),
    'parent_item'       => __( 'Parent Page Type' ),
    'parent_item_colon' => __( 'Parent Page Type:' ),
    'edit_item'         => __( 'Edit Page Type' ),
    'update_item'       => __( 'Update Page Type' ),
    'add_new_item'      => __( 'Add New Page Type' ),
    'new_item_name'     => __( 'New Page Type Name' ),
    'menu_name'         => __( 'Page Types' ),
  );

  $page_args = array(
    'hierarchical'      => true,
    'labels'            => $page_labels,
    'show_ui'           => true,
    'show_admin_column' => true,
    'query_var'         => true,
    'rewrite'           => array( 'slug' => 'page_types' ),
  );

  register_taxonomy( 'routine-type', array( 'routine' ), $rout_tax_args );
  register_taxonomy( 'page_types', array('page'), $page_args );
}


/*
--------------------------------------------------------------
CUSTOM MENU ICONS
--------------------------------------------------------------
*/
function custom_icons() {
  ?>
    <style type="text/css" media="screen">
        #menu-posts-game .wp-menu-image:before {
          font: 400 20px/1 'FontAwesome' !important;
          content: "\f091" !important;
        }
        #menu-posts-routine .wp-menu-image:before {
          font: 400 20px/1 'FontAwesome' !important;
          content: "\f140" !important;
        }
        #menu-posts-promo .wp-menu-image:before {
          font: 400 20px/1 'FontAwesome' !important;
          content: "\f02c" !important;
        }
        #menu-posts-faq .wp-menu-image:before {
          font: 400 20px/1 'FontAwesome' !important;
          content: "\f059" !important;
        }
        #menu-posts-supplier .wp-menu-image:before {
          font: 400 20px/1 'FontAwesome' !important;
          content: "\f1b2" !important;
        }
        #menu-posts-league .wp-menu-image:before {
          font: 400 20px/1 'FontAwesome' !important;
          content: "\f0ac" !important;
        }
        #menu-posts-organization .wp-menu-image:before {
          font: 400 20px/1 'FontAwesome' !important;
          content: "\f1ad" !important;
        }
        #adminmenu li.wp-menu-separator {
          background: #000;
          border-color: transparent;
          margin:0px 0px 0px;
        }
    </style>
<?php 
}


/*
--------------------------------------------------------------
CUSTOMS
--------------------------------------------------------------
*/
function my_restrict_manage_posts() {
  global $typenow;
  $taxonomy = $typenow;
  if( $typenow == "page" && $typenow != "post" ){
    $filters = array($taxonomy);
    foreach ($filters as $tax_slug) {
      $tax_obj = get_taxonomy('page_types');
      $tax_name = $tax_obj->labels->name;
      $terms = get_terms('page_types');
      echo "<select name='page_types' id='page_types' class='postform'>";
      echo "<option value=''>Show All $tax_name</option>";
      foreach ($terms as $term) { echo '<option value='. $term->slug, $_GET['page_types'] == $term->slug ? ' selected="selected"' : '','>' . $term->name .' (' . $term->count .')</option>'; }
      echo "</select>";
    }
  }
}


/*
--------------------------------------------------------------
MENU SEPARATORS
--------------------------------------------------------------
*/
function add_admin_menu_separator($position) {

  global $menu;
  $index = 0;

  foreach($menu as $offset => $section) {
    if (substr($section[2],0,9)=='separator')
        $index++;
    if ($offset>=$position) {
      $menu[$position] = array('','read',"separator{$index}",'','wp-menu-separator');
      //break;
      }
  }

  ksort( $menu );
}

function admin_menu_separator() {
  add_admin_menu_separator(26);
}


/*
--------------------------------------------------------------
CPT IN MENUS
--------------------------------------------------------------
*/
add_action('admin_head-nav-menus.php', 'wpclean_add_metabox_menu_posttype_archive');
 
function wpclean_add_metabox_menu_posttype_archive() {
    add_meta_box('wpclean-metabox-nav-menu-posttype', 'Custom Post Type Archives', 'wpclean_metabox_menu_posttype_archive', 'nav-menus', 'side', 'default');
}
 
function wpclean_metabox_menu_posttype_archive() {
    $post_types = get_post_types(array('show_in_nav_menus' => true,'has_archive'=> true), 'object');
 
    if ($post_types) :
        $items = array();
        $loop_index = 999999;
 
        foreach ($post_types as $post_type) {
            $item = new stdClass();
            $loop_index++;
 
            $item->object_id = $loop_index;
            $item->db_id = 0;
            $item->object = 'post_type_' . $post_type->query_var;
            $item->menu_item_parent = 0;
            $item->type = 'custom';
            $item->title = $post_type->labels->name;
            $item->url = get_post_type_archive_link($post_type->query_var);
            $item->target = '';
            $item->attr_title = '';
            $item->classes = array();
            $item->xfn = '';
 
            $items[] = $item;
        }
 
        $walker = new Walker_Nav_Menu_Checklist(array());
 
        echo '<div id="posttype-archive" class="posttypediv">';
        echo '<div id="tabs-panel-posttype-archive" class="tabs-panel tabs-panel-active">';
        echo '<ul id="posttype-archive-checklist" class="categorychecklist form-no-clear">';
        echo walk_nav_menu_tree(array_map('wp_setup_nav_menu_item', $items), 0, (object) array('walker' => $walker));
        echo '</ul>';
        echo '</div>';
        echo '</div>';
 
        echo '<p class="button-controls">';
        echo '<span class="add-to-menu">';
        echo '<input type="submit"' . disabled(1, 0) . ' class="button-secondary submit-add-to-menu right" value="' . __('Add to Menu', 'andromedamedia') . '" name="add-posttype-archive-menu-item" id="submit-posttype-archive" />';
        echo '<span class="spinner"></span>';
        echo '</span>';
        echo '</p>';
 
    endif;
}


/*
--------------------------------------------------------------
ACTIONS
--------------------------------------------------------------
*/
add_action( 'admin_head', 'custom_icons' );
add_action('admin_menu','admin_menu_separator');
add_action( 'init', 'create_post_types', 0 );
add_action( 'init', 'create_taxonomies', 0 );
add_action( 'restrict_manage_posts', 'my_restrict_manage_posts' );
?>