<?php

/*
--------------------------------------------------------------
ADMIN APPEARANCE AND CLEAN UP
--------------------------------------------------------------
*/

// Font embeds for editor-style.css
function admin_theme_styles() {
  wp_enqueue_style( 'font-awesome', 'http://netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css', array(), '4.1.0', 'all' );
  wp_enqueue_style( 'google-fonts', get_option('fonts_include'), array(), null, 'all' );
}

// Login Page
function load_alt_admin_styles(){
    wp_enqueue_style( 'login-alt-css', site_url('wp-content/library/css/login-alt.css'), array(), null, 'all' );
}

//Login Logo Link Replace
function wp_custom_login() {
    echo '<script type="text/javascript">window.onload = function(){document.getElementById("login").getElementsByTagName("a")[0].href = "'. site_url() . '";document.getElementById("login").getElementsByTagName("a")[0].title = "Go to site";}</script>';
}

// Add favicon
function pa_admin_area_favicon() {
    $favicon_url = site_url('wp-content/library/icons/favicon.ico');
    echo '<link rel="shortcut icon" href="' . $favicon_url . '" />';
}

// Change Howdy text
function replace_howdy( $wp_admin_bar ) {
 $my_account=$wp_admin_bar->get_node('my-account');
 $newtitle = str_replace( 'Howdy,', 'Hello,', $my_account->title );
 $wp_admin_bar->add_node( array(
 'id' => 'my-account',
 'title' => $newtitle,
 ) );
 }
 add_filter( 'admin_bar_menu', 'replace_howdy',25 );

// Remove Wordpress Links from Admin Bar
function remove_wp_logo( $wp_admin_bar ) {
    $wp_admin_bar->remove_node('wp-logo');
}

// Admin footer modification
function remove_footer_admin () {
  echo '<span id="footer-thankyou">Developed by <a href="http://adamwgd.com" target="_blank">Adam Weston</a></span>';
}

// disable default dashboard widgets
function disable_default_dashboard_widgets() {
    // remove_meta_box('dashboard_right_now', 'dashboard', 'core');    // Right Now Widget
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'core'); // Comments Widget
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'core');  // Incoming Links Widget
    remove_meta_box('dashboard_plugins', 'dashboard', 'core');         // Plugins Widget

    // remove_meta_box('dashboard_quick_press', 'dashboard', 'core');  // Quick Press Widget
    remove_meta_box('dashboard_recent_drafts', 'dashboard', 'core');   // Recent Drafts Widget
    remove_meta_box('dashboard_primary', 'dashboard', 'core');         // 
    remove_meta_box('dashboard_secondary', 'dashboard', 'core');       //
    
    // removing plugin dashboard boxes 
    remove_meta_box('yoast_db_widget', 'dashboard', 'normal');         // Yoast's SEO Plugin Widget
}

/*
--------------------------------------------------------------
ACTIONS
--------------------------------------------------------------
*/
add_editor_style('editor-style.css');
add_action('admin_enqueue_scripts', 'admin_theme_styles');
add_action('admin_enqueue_scripts', 'load_alt_admin_styles');
add_action('admin_head', 'pa_admin_area_favicon');
add_action('admin_bar_menu', 'remove_wp_logo', 999 );
add_action('admin_menu', 'disable_default_dashboard_widgets');

add_action('login_enqueue_scripts', 'load_alt_admin_styles');
add_action('login_head', 'wp_custom_login');
add_action('login_head', 'pa_admin_area_favicon');

/*
--------------------------------------------------------------
FILTERS
--------------------------------------------------------------
*/
add_filter('admin_footer_text', 'remove_footer_admin');

?>