<?php
require_once(dirname(__FILE__).'/utilities/Mobile_Detect.php');
$device = new Mobile_Detect;
/*
--------------------------------------------------------------
PAGE VARIABLES
--------------------------------------------------------------
*/
if(isset($_GET['con'])){
    $con = $_GET['con'];
}else{
    $con = '';
}

$data = array(
    'loginLink' => 'https://www.yaveo.com/en/login',
    'pageName' => 'AcqMovies_En',
    'masthead' => array(
        'image' => 'img/masthead-movies.jpg',
        'mobileImage' => 'img/masthead-mobile-movies.jpg',
        'headline' => 'Your favorite movies in Spanish live here',
        'secondary' => 'Action, comedy, horror, classics and more! Plus novelas, live soccer, and TV series for only $7.99 a month.',
        'cta' => 'First Week Free!'
    ),
    'module1' => array(
        'image' => 'img/content-wall.jpg',
        'headline' => 'Larger than life entertainment for the whole family to enjoy.',
        'copy' => 'With Yaveo, you will have access to some of the best European soccer leagues LIVE from beIN SPORTS En Español and thousands of hours of current and classic ON DEMAND programming from Latin America, Spain and the U.S. Only $7.99 a month. All you need is the internet. You can cancel anytime. On Yaveo, ¡vive lo tuyo!',
        'cta' => 'Sign Up Now!'
    ),
    'module2' => array(
        'image' => 'img/mediaModule_MOVIES_500x300.jpg',
        'headline' => 'Do you live for a good movie in Spanish? Enjoy them on Yaveo.',
        'copy' => 'On Yaveo, enjoy your favorite movies from Latin America, Spain, and the U.S. anywhere you go.',
        'cta' => ''
    ),
    'module3' => array(
        'image' => 'img/devices-horizontal-en.png',
        'mobileImage' => 'img/devices-stacked.png',
        'headline' => 'Don’t miss a moment of your favorites—take them with you!',
        'copy' => 'You can enjoy Yaveo wherever and whenever, using a computer, tablet, smartphone, or Xbox 360<sup>&reg;</sup> or Roku<sup>&reg;</sup>. All you have to do is connect to the Internet. With Yaveo, you’ll never miss what you love to watch most.',
        'cta' => ''
    ),
    'module4' => array(
        'image' => 'img/free_week.jpg',
        'headline' => 'Only $7.99 a month. Your first week is on us!',
        'copy' => 'The first week is free and Yaveo is only $7.99 a month after that. Cancel anytime. Enjoy the best Spanish-language entertainment your way!',
        'cta' => 'Get First Week Free!'
    ),
    'disclaimer' => '*Only two programs may be streamed at the same time. Live channels included for a limited time with the Yaveo $7.99 service. See the <a href="https://www.yaveo.com/offerdetails/index_en.html" target="_blank">offer details</a> for more information. Offer ends 11/30/15. Service only available in the United States (excluding Puerto Rico and US Territories). All functions and programming subject to change at any time.',
    'artFooter' => '&copy;2015 Sony Pictures. All Rights Reserved. Rudo y Cursi, Broken Embraces, Nine Queens, Bad Education, and all related titles, logos and characters are trademarks of Sony Pictures. &copy;2015 Lions Gate Entertainment Inc. All Rights Reserved. Amor Dolor y Viceversa, Canela, Hecho en México and all related titles, logos and characters are trademarks of Lions Gate Entertainment Inc.'
);

// DATA
switch($con) {
    case 'sports':
        $data['pageName'] = 'AcqSports_En';
        $data['masthead']['image'] = 'img/masthead-sports.jpg';
        $data['masthead']['mobileImage'] = 'img/masthead-mobile-sports.jpg';
        $data['masthead']['headline'] = 'Your idols live here';
        $data['masthead']['secondary'] = 'La Liga, Serie A, Ligue 1 and, of course, movies, novelas, TV series and much more for only $7.99 a month.';
        $data['module2']['image'] = 'img/mediaModule_SPORTS_500x300.jpg';
        $data['module2']['headline'] = 'LIVE Soccer, baseball, boxing and other sports are at your fingertips with Yaveo.';
        $data['module2']['copy'] = 'On Yaveo, enjoy your favorite sports at home or anywhere you go.';
        $data['artFooter'] = '&copy;2015 beIN SPORTS. All Rights Reserved.';
        break;
    case 'novelas':
        $data['pageName'] = 'AcqNovelas_En';
        $data['masthead']['image'] = 'img/masthead-novelas.jpg';
        $data['masthead']['mobileImage'] = 'img/masthead-mobile-novelas.jpg';
        $data['masthead']['headline'] = 'Classic and contemporary novelas live here';
        $data['masthead']['secondary'] = 'A wide variety of novelas for every taste, and of course movies, live soccer, TV series and much more for only $7.99 a month.';
        $data['module2']['image'] = 'img/mediaModule_NOVELAS_500x300.jpg';
        $data['module2']['headline'] = 'If you like classic and contemporary novelas, enjoy them on Yaveo.';
        $data['module2']['copy'] = 'No matter where you are, with Yaveo you can experience all the emotions that come from novelas, no matter where you go.';
        $data['artFooter'] = '&copy;2015 Univision Communications Inc. All Rights Reserved. Mi Corazon Es Tuyo, La Sombra del Pasado, Maria Mercedes, La Usurpadora, Yo No Creo en Hombres, Marimar and all related titles, logos and characters are trademarks of Univision Communciations Inc. &copy;2015 Cisneros. All Rights Reserved. Eva Luna and all related titles, logos and characters are trademarks of Cisneros.';
        break;
    case 'kids':
        $data['pageName'] = 'AcqKids_En';
        $data['masthead']['image'] = 'img/masthead-kids.jpg';
        $data['masthead']['mobileImage'] = 'img/masthead-mobile-kids.jpg';
        $data['masthead']['headline'] = 'Adventures, fun and more live here';
        $data['masthead']['secondary'] = 'Discover kids shows for all ages, plus novelas, movies, TV shows and much more for only $7.99 a month.';
        $data['module2']['image'] = 'img/mediaModule_KIDS_500x300.jpg';
        $data['module2']['headline'] = 'If you live for kids programming, enjoy it on Yaveo.';
        $data['module2']['copy'] = 'On Yaveo the little ones can also enjoy their favorite programming.';
        $data['artFooter'] = '&copy;2015 Viacom International Inc. All Rights Reserved. Nickelodeon, Dora The Explorer, iCarly and all related titles, logos and characters are trademarks of Viacom International Inc. &copy;2015 FlixLatino. All Rights Reserved. Bali and all related titles, logos and characters are trademarks of FlixLatino. &copy;2015 Smilehood. All Rights Reserved. Plim Plim and all related titles, logos and characters are trademarks of Smilehood. &copy;2015 Univision Communications Inc. All Rights Reserved. El Chavo and all related titles, logos and characters are trademarks of Univision Communciations Inc. &copy;2015 Imira Entertainment S.L. All Rights Reserved. Lola & Virginia and all related titles, logos and characters are trademarks of Imira Entertainment S.L. &copy;2015 Lions Gate Entertainment Inc. All Rights Reserved. La Leyenda de la Llorona and all related titles, logos and characters are trademarks of Lions Gate Entertainment Inc.';
        break;
}

?>

<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Yaveo</title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- STYLESHEETS -->
        <link href="css/normalize.css" rel='stylesheet'>
        <link href="css/grid.css" rel='stylesheet'>
        <link href="css/main.css" rel='stylesheet'>
        <link href="fonts/yaveo/yaveofont.css" rel='stylesheet'>
        <link href="fonts/fontawesome/font-awesome.css" rel='stylesheet'>

        <script type="text/javascript" src="js/Ooyala_Omniture.js"></script>

        <script type="text/javascript">

            function resetEvars() {
                s.pageName = '';
                s.server = '';
                s.pageType = '';
                s.events = '';
                s.eVar17 = '';
                s.eVar8 = '';
                s.prop9 = '';
                s.eVar18 = '';
                s.eVar4 = '';
                s.eVar1 = '';
                s.prop1 = '';
                s.eVar2 = '';
                s.prop5 = s.eVar5 = '';
                s.eVar10 = '';
                s.eVar14 = '';
            }

            var s = Reporting.getReportingObject('dtvdirectvhottprod'); // 'dtvdtvdirectvhottest' for testing, 'dtvdirectvhottprod' for production
            s.channel = 'https:www.yaveo.com'; // https:www.yaveo.com for production
            resetEvars();

            var pageName = <?php echo "'".$data['pageName']."'"; ?>; //replace with the page names listed below
            s.pageName = pageName;
            s.server = '';
            s.pageType = '';
            s.events = 'event1,event2';
            var accountNumber = ''; //Sessions.getCookie('userid');
            if (typeof accountNumber !== 'undefined') s.eVar17 = accountNumber;
            s.eVar1 = ''; //<subscriber_type> Subscriber/Non Subscribe //on page load
            s.prop1 = navigator.userAgent; //<device_type>
            s.prop9 = (typeof propNine !== 'undefined') ? propNine : '';
            s.eVar2 = ''; //package of the user //on page load
            //s.prop2='' //not known
            s.eVar3 = ''; //<search_term_typed> //on search
            s.prop3 = ''; //# of results from search //on search
            s.eVar4 = ''; //Piped origin of playback //on video playback
            s.prop4 = ''; //view type
            s.prop5 = s.eVar5 = 'en_EN'; //language of the page en_EN for english and es_ES 
            s.eVar7 = ''; //genre if applicable on page with genre info //on page load
            //s.prop7 //# of Videos in Watchlist //on page load of watchlist
            //s.eVar8 //<movie_title | Showname_Seasonid_Episodeid> //on video playback
            //s.prop8 //promocodes // on signup completion or new subscribtion
            //s.eVar9 //Name of social sharing network //on sharing video
            s.eVar10 = navigator.userAgent; //<device_type> //on page load
            //s.eVar12 //<connection_type> //not sure for web //on page load
            //s.eVar13 //<programmer_name>(if applicable) Only when user selects a network. Capital letter Network Name
            //on page load
            s.eVar14 = ''; //<subscription_type> // on signup completion
            //s.eVar15 //Number of videos in watchlist page //on page load
            //s.eVar16 //<promo_codes> // on signup completion
            var s_code = s.t();
            if (s_code) console.log(s_code);
            console.log(pageName);

        </script>

    </head>
    <body class="<?php echo $pageName; ?>">
        <!--[if lt IE 7]>
            <p class="browsehappy">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
        <![endif]-->

        <!-- SITE CONTENT -->
        <div class="container">

            <div class="wrap">
                
                <div id="header">
                    <div class="row">
                        <div class="col-xs-6 col-sm-7">
                            <div class="logo-box">
                                <img src="img/yaveo-logo.png" class="img-responsive"/>
                            </div>
                        </div>
                        <div class="col-xs-6 col-sm-5">
                            <div id="logBox">
                                <a href="<?php echo $data['loginLink']; ?>" class="btn btn-blue btn-short">Log In</a>
                            </div>
                            <div id="langBox">
                                <div class="langswitch">
                                    <input type="checkbox" name="langswitch" class="langswitch-checkbox" id="langswitch">
                                    <label class="langswitch-label" for="langswitch">
                                        <span class="langswitch-inner"></span>
                                        <span class="langswitch-switch"></span>
                                    </label>
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>

                <div id="banner">
                    
                    <div id="bannerImageBox">
                        <?php 
                            if($device->isMobile() && !$device->isTablet()){
                                $mastheadImage = $data['masthead']['mobileImage'];
                            }else{
                                $mastheadImage = $data['masthead']['image'];
                            }
                        ?>
                        <img id="bannerImage" src="<?php echo $mastheadImage; ?>" class="img-responsive" alt=""/>
                    </div>

                    <div class="cta">
                        <div class="headline main text"><?php echo $data['masthead']['headline']; ?></div>
                        <div class="row">
                            <div class="col-xs-12 col-md-7">
                                <div class="headline secondary text"><?php echo $data['masthead']['secondary']; ?></div>
                            </div>
                            <div class="col-xs-12 col-md-5">
                                <div class="button">
                                    <a href="https://www.yaveo.com/en/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['masthead']['cta']; ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content">

                    <div id="mod1" class="module">
                        <div class="row">
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <img src="<?php echo $data['module1']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-7 col-md-7">
                                <h2><?php echo $data['module1']['headline']; ?></h2>
                                <p><?php echo $data['module1']['copy']; ?></p>
                                <?php if($data['module1']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/en/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module1']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <div id="mod2" class="module">
                        <div class="row">
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <img src="<?php echo $data['module2']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-7 col-md-7">
                                <h2><?php echo $data['module2']['headline']; ?></h2>
                                <p><?php echo $data['module2']['copy']; ?></p>
                                <?php if($data['module2']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/en/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module2']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <div id="mod3" class="module">
                        <div class="row">
                            <div class="col-xs-12 hidden-sm hidden-md hidden-lg hidden-xl">
                                <img src="<?php echo $data['module3']['mobileImage']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <h2><?php echo $data['module3']['headline']; ?></h2>
                                <p><?php echo $data['module3']['copy']; ?></p>
                                <?php if($data['module3']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/en/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module3']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                            <div class="hidden-xs col-sm-7 col-md-7">
                                <img src="<?php echo $data['module3']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                        </div>
                    </div>

                    <div id="mod4" class="module">
                        <div class="row">
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <img src="<?php echo $data['module4']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-7 col-md-7">
                                <h2><?php echo $data['module4']['headline']; ?></h2>
                                <p><?php echo $data['module4']['copy']; ?></p>
                                <?php if($data['module4']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/en/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module4']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                </div>

                <div id="footer" class="textcenter">
                    <a href="#" class="back-to-top"><i class="fa fa-chevron-up fa-2x"></i></a>
                    <div class="disclaimer">
                        <?php echo $data['disclaimer'].' '.$data['artFooter']; ?>
                    </div>
                    <ul class="list-inline">
                        <li class="blue-text">&copy;2015 DIRECTV DIGITAL LLC </li>
                        <li><a href="https://www.yaveo.com/en/pp">Privacy Policy</a></li>
                        <li><a href="https://www.yaveo.com/en/tou">Terms of Use</a></li>
                        <li><a href="https://help.yaveo.com">Help</a></li>
                        <li><a href="https://www.yaveo.com/wheretowatch/en.html">Where to Watch</a></li>
                    </ul>
                    
                </div>

            </div>
            
        </div>

        <!-- Google Tag Manager -->
        <noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-5J7G8D" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start': new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0], j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src='//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f); m})(window,document,'script','dataLayer','GTM-5J7G8D');</script>
        <!-- End Google Tag Manager -->


        <!-- JAVASCRIPT GOES HERE -->
        <script src="js/jquery.min.js"></script>
        <script src="js/jquery-ui.min.js"></script>
        <script src="js/modernizr.js"></script>
        <script src="js/main.js"></script>
    </body>
</html>