<?php get_header(); ?>
			
			<div class="row-fluid">
				<div class="span12">
					<div class="page-header"><h1 class="single-title" itemprop="headline"><?php the_title(); ?></h1></div>
				</div>
			</div>

			<div id="content" class="clearfix row-fluid">
			
				<div id="main" class="span8 clearfix" role="main">

					<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
					
					<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?> role="article" itemscope itemtype="http://schema.org/BlogPosting">
						
						<header>
							
							
							
							<!--<p class="meta"><?php _e("Posted", "bonestheme"); ?> <time datetime="<?php echo the_time('Y-m-j'); ?>" pubdate><?php the_date(); ?></time> <?php _e("by", "bonestheme"); ?> <?php the_author_posts_link(); ?> <span class="amp">&</span> <?php _e("filed under", "bonestheme"); ?> <?php the_category(', '); ?>.</p>-->
						
						</header> <!-- end article header -->
					
						<section class="post_content clearfix" itemprop="articleBody">
							
							<?php the_content(); ?>
							
							
					
						</section> <!-- end article section -->
						
						<footer>
			
							<?php the_tags('<p class="tags"><span class="tags-title">' . __("Tags","bonestheme") . ':</span> ', ' ', '</p>'); ?>
							
							<?php 
							// only show edit button if user has permission to edit posts
							if( $user_level > 0 ) { 
							?>
							<a href="<?php echo get_edit_post_link(); ?>" class="btn btn-success edit-post"><i class="icon-pencil icon-white"></i> <?php _e("Edit post","bonestheme"); ?></a>
							<?php } ?>
							
						</footer> <!-- end article footer -->
					
					</article> <!-- end article -->
					
					
					
					<?php endwhile; ?>			
					
					<?php else : ?>
					
					<article id="post-not-found">
					    <header>
					    	<h1><?php _e("Not Found", "bonestheme"); ?></h1>
					    </header>
					    <section class="post_content">
					    	<p><?php _e("Sorry, but the requested resource was not found on this site.", "bonestheme"); ?></p>
					    </section>
					    <footer>
					    </footer>
					</article>
					
					<?php endif; ?>
			
				</div> <!-- end #main -->
    
				<div id="sidebar1" class="fluid-sidebar sidebar span4" role="complementary">
					<div class="widget">
						<h3 class="widgettitle">About this Work</h3>
						<div class="padder">
						<?php
							$client = get_post_meta($post->ID, "wpcf-client",true);
							$tytan = get_post_meta($post->ID, "wpcf-tytan",true);
							$creative = get_post_meta($post->ID, "wpcf-creative-director",true);
							$designer = get_post_meta($post->ID, "wpcf-designer",true);
							$developer = get_post_meta($post->ID, "wpcf-developer",true);
							$addinfo = get_post_meta($post->ID, "wpcf-additional-info",true);
							$activelink = get_post_meta($post->ID, "wpcf-active-web-link",true);
						
							if($client!=""){
								echo '<div class="addinfo"><strong>Client: </strong>'.$client;
								if($tytan == "1"){
									echo ' / <a href="http://tytancreates.com" target="_blank">Tytan</a>';
								}
								echo '</div>';
							}

							if($creative!=""){
								echo '<div class="addinfo"><strong>Creative Director: </strong>'.$creative.'</div>';
							}

							if($designer!=""){
								echo '<div class="addinfo"><strong>Designer: </strong>'.$designer.'</div>';
							}

							if($developer!=""){
								echo '<div class="addinfo"><strong>Developer: </strong>'.$developer.'</div>';
							}

							if($addinfo!=""){
								echo '<div class="addinfo"><strong>More: </strong><br />'.$addinfo.'</div>';
							}

							if($activelink!=""){
								echo '<a href="'.$activelink.'" target="_blank" class="btn btn-form btn-block">Launch Site</a>';
							}
						?>
						</div>
					</div>
					
					<?php if ( is_active_sidebar( 'sidebar1' ) ) : ?>

						<?php dynamic_sidebar( 'sidebar1' ); ?>

					<?php else : ?>

						<!-- This content shows up if there are no widgets defined in the backend. -->
						
						<div class="alert alert-message">
						
							<p><?php _e("Please activate some Widgets","bonestheme"); ?>.</p>
						
						</div>

					<?php endif; ?>
				</div>
    
			</div> <!-- end #content -->

<?php get_footer(); ?>