<?php
/*
Template Name: Work Page
*/
?>

<?php get_header(); ?>
			
			<div class="row-fluid">
				<div class="span12">
					<div class="page-header"><h1 class="single-title" itemprop="headline"><?php the_title(); ?></h1></div>
				</div>
			</div>

			<div id="content" class="clearfix row-fluid">
			
				<div id="main" class="span12 clearfix" role="main">

					<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
					
					<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?> role="article">
						
						<header>
							
							
						
						</header> <!-- end article header -->
					
						<section class="post_content">
							<div class="row-fluid">
									<ul class="thumbnails span12">
									  <?php
									  $query = new WP_Query( array( 'post_type' => 'works', 'orderby'=>'menu_order', 'order'=>'ASC', 'posts_per_page'=> '-1' ) );
							          
									  $c = 0;
									  $n = 3;
									  echo '<div class="row-fluid">';
							          while ( $query->have_posts() ) : $query->the_post();
							            
							            ?>
							            	

													  <li class="span3">
													    <div class="thumbnail">
													    	<a href="<?php the_permalink(); ?>" data-toggle="tooltip" title="<?php the_title(); ?>" class="work_thumb"/>
													    		<?php the_post_thumbnail( 'work-thumb' ); ?>
													    	</a>
							                				
													    </div>
													  </li>

													  
													
							           <?php  
							           if($c % $n == 0 && $c !=0){
							           		echo '</div><div class="row-fluid">';
							           }
							           $c++;
							           if($c > 3){
							           	$c=0;
							           }
							          endwhile;

							          // Reset Post Data
							          wp_reset_postdata(); ?>
							        </ul>
							</div>
						</section> <!-- end article section -->
						
						<footer>
			
							<p class="clearfix"><?php the_tags('<span class="tags">' . __("Tags","bonestheme") . ': ', ', ', '</span>'); ?></p>
							
						</footer> <!-- end article footer -->
					
					</article> <!-- end article -->
					
					<?php comments_template(); ?>
					
					<?php endwhile; ?>	
					
					<?php else : ?>
					
					<article id="post-not-found">
					    <header>
					    	<h1><?php _e("Not Found", "bonestheme"); ?></h1>
					    </header>
					    <section class="post_content">
					    	<p><?php _e("Sorry, but the requested resource was not found on this site.", "bonestheme"); ?></p>
					    </section>
					    <footer>
					    </footer>
					</article>
					
					<?php endif; ?>
			
				</div> <!-- end #main -->
    
			</div> <!-- end #content -->

<?php get_footer(); ?>