/* --------------------------------------------- */
/* Author: http://codecanyon.net/user/CodingJack */
/* --------------------------------------------- */

/* 
	--------------------------------------
	IMPORTANT! This is jQuick, NOT jQuery!
	--------------------------------------
	
	jQuick is similar to jQuery however.
	You can learn about the differences here:
	http://www.codingjack.com/playground/jquick/
	
*/

;(function($) {
	
	'use strict';
	var touched, transform, globalBanners = [], ie8 = jQuick.ie8;
	
	$.fn('cjZoomShowcase', function() {
		
		return this.each(init);
		
	});
	
	function init() {
		
		var $this = $(this), gFont = $this.attr('data-googlefont');
		
		if(gFont) {
			
			var style = $('#' + $this.attr('id') + '_css'),
			styles = '#' + $this.attr('id') + ' {font-family: "' + gFont.split('::')[0].split('+').join(' ') + '"}';
			
			if(style.length) {
				
				style.innerCSS(style.innerCSS() + '\n' + styles);
				
			}
			else {
			
				$('<style type="text/css" />').innerCSS(styles).appendTo($('head'));
				
			}
			
			WebFont.load({google: {families: [gFont]}, active: function() {

				new ZoomShowcase($this);
				
			}});
			
		}
		else {
		
			new ZoomShowcase($this);
			
		}
		
	}
	
	function ZoomShowcase($this) {
		
		var imgWidth = this.imgWidth = parseInt($this.attr('data-imagewidth'), 10),
		mobileCaptions = $this.attr('data-mobilecaptions') === 'yes',
		list = $this.children('div'),
		leg = this.leg = list.length,
		items = [], 
		captions,
		wrap,
		cLeg, 
		itm,
		arr,
		ar, 
		i,
		j;
		
		if(leg < 4) {
			
			alert('ZoomShowcase requires at least 4 items to work');	
			return;
			
		}
		
		for(i = 0; i < leg; i++) {
			
			wrap = $('<div />').addClass('cj-zoom-caption');
			itm = items[i] = list.eq(i);
			
			captions = itm.find('span');
			ar = captions.toArray();
			cLeg = ar.length;
			arr = [];
			
			for(j = 0; j < cLeg; j++) {
			
				arr[j] = captionData(ar[j], imgWidth, wrap, j);
				
			}
			
			wrap.appendTo(itm);
			itm.data('image', itm.children('img'));
			if(cLeg) itm.data('captions', arr);
			
		}
		
		var totalWidth = this.totalWidth = parseInt($this.attr('data-bannerwidth'), 10),
		imgHeight = this.imgHeight = parseInt($this.attr('data-imageheight'), 10),
		bWidth = totalWidth + (parseInt(itm.css('border-left-width'), 10) << 1),
		halfHeight = this.halfHeight = (imgHeight * 0.5) | 0,
		halfWidth = this.halfWidth = (totalWidth * 0.5) | 0,
		quarters = parseFloat($this.attr('data-backzoom')),
		
		quarterH = this.quarterH = (imgHeight * quarters) | 0,
		quarterW = this.quarterW = (imgWidth * quarters) | 0,
		halves = parseFloat($this.attr('data-sidezoom')),
		halfH = this.halfH = (imgHeight * halves) | 0,
		halfW = this.halfW = (imgWidth * halves) | 0;

		$this.width(bWidth).height(imgHeight).data({
			
			banner: this,
			oWidth: bWidth,
			oHeight: imgHeight
			
		});
		
		this.items = items;
		this.banner = $this;
		this.easing = $this.attr('data-easing');
		
		this.sideOpacity = parseFloat($this.attr('data-sideopacity'));	
		this.randomize = $this.attr('data-randomizeitems') === 'yes';
		this.speed = parseInt($this.attr('data-animationspeed'), 10);
		this.delay = parseInt($this.attr('data-autoplaydelay'), 10);
		this.auto = $this.attr('data-autoplay') === 'yes';
		
		this.isOn = 0;
		this.toRight = 1;
		this.toCenter = 0;
		this.iLeg = this.toLeft = leg - 1;
			
		this.rightX = totalWidth - halfW;
		this.backX = halfWidth - ((quarterW * 0.5) | 0);
		this.centerX = halfWidth - ((imgWidth * 0.5) | 0);
					
		this.sideY = halfHeight - ((halfH * 0.5) | 0);
		this.backY = halfHeight - ((quarterH * 0.5) | 0);
		
		if($this.attr('data-responsive') === 'yes' && transform) {
			
			globalBanners[globalBanners.length] = [this, $this.parent(), items, mobileCaptions, halfHeight, imgHeight];
			
			resize();
			$(window).on('resize.cj', resize);
			
		}
		
		this.init();
		
	}
	
	ZoomShowcase.prototype = {
			
		init: function() {
				
			var $this = this.banner, items = this.items, leg = this.leg, list = [];
			
			if(this.randomize) {
				
				var shuf = [], placer, i;
				for(i = 0; i < leg; i++) shuf[i] = items[i];
								
				while(shuf.length > 0) { 
								
					placer = (Math.random() * shuf.length) | 0;
					
					list[list.length] = shuf[placer];
					shuf.splice(placer, 1);
								
				}
				
				for(i = 0; i < leg; i++) $this.append(list[i]);
				items = this.items = list;
				
			}
			
			var itm,
			data = {},
			itmCss = {},
			imgCss = {},
			halfH = this.halfH, 
			halfW = this.halfW, 
			sideY = this.sideY,
			backX = this.backX,
			backY = this.backY,
			quarterW = this.quarterW,
			quarterH = this.quarterH,
			imgWidth = this.imgWidth, 
			imgHeight = this.imgHeight,
			sideOpacity = this.sideOpacity,
			image,
			span;
			
			while(leg--) {
				
				span = data.cover = $('<span />').addClass('cj-zoom-showcase-cover');
				itm = items[leg].append(span);
				itmCss.visibility = 'visible';
				
				switch(leg) {
							
					case 0: 
						
						itmCss.top = 0;
						itmCss.zIndex = 3;
						itmCss.left = this.centerX;
						itmCss.width = imgWidth;
						itmCss.height = imgHeight;
							
						span.css('opacity', 0);
						imgCss.width = imgWidth;
						imgCss.height = imgHeight;
								
					break;
							
					case 1:
						
						itmCss.zIndex = 1;
						itmCss.top = sideY;
						itmCss.left = this.rightX;
						itmCss.width = halfW;
						itmCss.height = halfH;
						
						imgCss.width = halfW;
						imgCss.height = halfH;
						span.css('opacity', sideOpacity);
						
						itm.css('cursor', 'pointer').on('mouseover.cj', over).on('mouseout.cj', out);
							
					break;
							
					case this.iLeg:
						
						itmCss.left = 0;
						itmCss.zIndex = 2;
						itmCss.top = sideY;
						itmCss.width = halfW;
						itmCss.height = halfH;
							
						imgCss.width = halfW;
						imgCss.height = halfH;
						span.css('opacity', sideOpacity);
						
						itm.css('cursor', 'pointer').on('mouseover.cj', over).on('mouseout.cj', out);
							
					break;
							
					default:
						
						itmCss.zIndex = 0;
						itmCss.top = backY;
						itmCss.left = backX;
						itmCss.width = quarterW;
						itmCss.height = quarterH;
						itmCss.visibility = 'hidden';
						
						span.css('opacity', 0);
						imgCss.width = quarterW;
						imgCss.height = quarterH;
								
				}
				
				image = itm.children('img');
				image.css(imgCss);
				
				data.banner = this;
				data.image = image;
				
				itm.css(itmCss).data(data);
				
			}
			
			if(this.auto) $this.on('mouseenter.cj', enterMouse).on('mouseleave.cj', exitMouse);
			this.addEvents(true);
			
		},
		
		timeout: function() {
			
			if(this.isOver) return;
			var $this = this;
			
			this.timer = setTimeout(function() {
			
				$this.clickRight();
				
			}, this.delay);
			
		},
				
		clickLeft: function(event) {
			
			var $this = event ? this.data('banner') : this;
			
			clearTimeout($this.timer);
			$this.isRunning = true;
			
			var isOn = $this.isOn, iLeg = $this.iLeg,
			toRight = $this.toRight = isOn, items = $this.items,
			toBack = $this.toBack = (isOn < iLeg) ? isOn + 1 : 0,
			toCenter = $this.toCenter = (isOn > 0) ? isOn - 1 : iLeg,
			toLeft = $this.toLeft = (toCenter > 0) ? toCenter - 1 : iLeg;
					
			items[toCenter].off('click.cj', $this.clickLeft);
			items[toBack].off('click.cj', $this.clickRight);
					
			items[toLeft].css('z-index', 1);
			items[toRight].css('z-index', 2);
					
			$this.animate();
					
		},
				
		clickRight: function(event) {
			
			var $this = event ? this.data('banner') : this;
			
			clearTimeout($this.timer);
			$this.isRunning = true;
			
			var isOn = $this.isOn, iLeg = $this.iLeg,
			items = $this.items, toLeft = $this.toLeft = isOn,
			toBack = $this.toBack = (isOn > 0) ? isOn - 1 : iLeg,
			toCenter = $this.toCenter = (isOn < iLeg) ? isOn + 1 : 0,
			toRight = $this.toRight = (toCenter < iLeg) ? toCenter + 1 : 0;
					
			items[toCenter].off('click.cj', $this.clickLeft);
			items[toBack].off('click.cj', $this.clickRight);
			
			items[toLeft].css('z-index', 2);
			items[toRight].css('z-index', 1);
					
			$this.animate();
					
		},
		
		animate: function() {
			
			clearTimeout(this.timer);
			
			var settings = {duration: this.speed, ease: this.easing},
			style = {cursor: 'pointer', visibility: 'visible'},
			css = {zIndex: 0, cursor: 'auto'},
			sideOpacity = this.sideOpacity,
			imgHeight = this.imgHeight,
			imgWidth = this.imgWidth,
			quarterW = this.quarterW,
			quarterH = this.quarterH,
			toCenter = this.toCenter,
			toRight = this.toRight,
			toLeft = this.toLeft,
			toBack = this.toBack,
			sideY = this.sideY,
			halfW = this.halfW,
			halfH = this.halfH,
			items = this.items,
			
			backs = items[toBack],
			lefts = items[toLeft],
			right = items[toRight],
			center = items[toCenter],
			leftData = lefts.data(),
			rightData = right.data(),
			centerData = center.data(),
			cover = backs.data('cover');
			
			this.isOn = toCenter;
			if(touched) this.banner.removeSwipe();
			
			lefts.off('.cj');
			right.off('.cj');
			backs.off('.cj').css(css);
			
			css.zIndex = 3;
			center.off('.cj').css(css);
			
			lefts.css(style).on('mouseover.cj', over).on('mouseout.cj', out);
			right.css(style).on('mouseover.cj', over).on('mouseout.cj', out);
			
			cover.stop();
			cover.css('opacity', sideOpacity);
			
			if(this.captions) {
				
				var captions = this.captions, i = captions.length;
				
				if(!ie8) {
				
					while(i--) captions[i].fadeOut();
					
				}
				else {
				
					while(i--) captions[i].hide();
					
				}
				
				delete this.captions;
				
			}
			
			backs.animate({left: this.backX, top: this.backY, width: quarterW, height: quarterH}, settings);		
			backs.data('image').animate({width: quarterW, height: quarterH}, settings);
					
			lefts.animate({left: 0, top: sideY, width: halfW, height: halfH}, settings);
			leftData.image.animate({width: halfW, height: halfH}, settings);
			leftData.cover.animate({opacity: sideOpacity}, settings);
			
			right.animate({left: this.rightX, top: sideY, width: halfW, height: halfH}, settings);
			rightData.image.animate({width: halfW, height: halfH}, settings);
			rightData.cover.animate({opacity: sideOpacity}, settings);
			
			centerData.image.animate({width: imgWidth, height: imgHeight, opacity: 1}, settings);
			centerData.cover.animate({opacity: 0}, settings);
			
			settings.onComplete = this.addEvents;
			center.animate({left: this.centerX, top: 0, width: imgWidth, height: imgHeight}, settings);
					
		},
				
		addEvents: function(banner) {
			
			var $this = banner ? this : $(this).data('banner'), items = $this.items,
			center = items[$this.toCenter], linked = center.attr('data-link'),
			captions = center.data('captions');
			
			if(touched) $this.banner.swipe(catchSwipe);
			if(linked) center.on('click.cj', gotoURL).css('cursor', 'pointer');
			
			items[$this.toLeft].on('click.cj', $this.clickLeft);
			items[$this.toRight].on('click.cj', $this.clickRight);
			
			$this.isRunning = false;
			
			if(captions) {
			
				$this.captionOn = 0;
				$this.captions = captions;
				$this.captionTotal = captions.length;
				
				runCaption($this, true);
				
			}
			else if($this.auto) {
			
				$this.timeout();
				
			}
					
		}
		
	};
	
	function captionData($this, width, wrap, i) {
		
		var span = $('<span />').addClass('cj-zoom-caption-wrap'),
		alignLeft = $this.attr('data-align') === 'yes',
		posX = parseInt($this.attr('data-x'), 10),
		posY = parseInt($this.attr('data-y'), 10), 
		bgColor = $this.attr('data-bgcolor'),
		color = $this.attr('data-textcolor'),
		tHeight = $this.outerHeight(),
		tWidth = $this.outerWidth();
		
		if(!alignLeft) span.addClass('cj-zoom-caption-scale');
		
		span.css({
			
			left: alignLeft ? posX : width - tWidth - posX, 
			overflow: 'hidden',
			height: tHeight,
			top: posY,
			width: 0
			
		}).data({
			
			top: posY,
			width: tWidth, 
			caption: $this,
			height: tHeight, 
			alignLeft: alignLeft,
			rTop: ((tHeight + 10) * i) + 20
			
		}).append($this).appendTo(wrap);
		
		if($this.attr('data-link')) $this.addClass('cj-zoom-caption-link').on('click.cj', gotoURL);
		if(bgColor) span.css('background-color', bgColor);
		if(color) span.css('color', color);
		
		return span;
		
	}
	
	function runCaption($this, delay) {
		
		if($this.isRunning) return;
		
		var obj = {duration: $this.speed - 125, ease: $this.easing},
		style = {display: 'inline-block', opacity: 1},
		
		index = $this.captionOn,
		caption = $this.captions[index], 
		data = caption.data(),
		width = data.width;
		
		if(delay) obj.delay = 250;
		$this.captionOn++;
		
		if(data.alignLeft) {
			
			if(index < $this.captionTotal - 1) {
				
				obj.onComplete = runCaption;
				obj.onCompleteParams = $this;
				
			}
			else if($this.auto) {
			
				$this.timeout();
				
			}
			
			style.width = 0;
			caption.css(style);
			
			caption.animate({width: width}, obj);
			
		}
		else {
			
			obj.onUpdate = updateClip;
			
			style.width = width;
			style.clip = 'rect(0px, ' + width + 'px , ' + data.height + 'px, ' + width + 'px)';
			
			caption.data('params', [$this, caption]).css(style).tick(obj);
			
		}
		
	}
	
	function updateClip(tick) {
		
		var params = $(this).data('params'),
		banner = params[0],
		caption = params[1],
		data = caption.data(),
		width = data.width;
		
		caption.domElement().style.clip = 'rect(0px, ' + width + 'px, ' + data.height + 'px, ' + (width * (1 - tick)) + 'px)';
		
		if(tick === 1) {
			
			if(banner.captionOn < banner.captionTotal) {
			
				runCaption(banner);
				
			}
			else if(banner.auto) {
			
				banner.timeout();
				
			}
			
		}
		
	}
	
	function catchSwipe(direction) {
		
		this.data('banner')[direction === 'right' ? 'clickRight' : 'clickLeft']();
		
	}
	
	function over() {
		
		this.data('cover').animate({opacity: 0});
				
	}
	
	function out() {
		
		var data = this.data();
		
		data.cover.animate({opacity: data.banner.sideOpacity});
				
	}
	
	function gotoURL() {
		
		if(this.attr('data-target') === 'no') {
			
			window.location = this.attr('data-link');
			
		}
		else {
			
			window.open(this.attr('data-link'));
			
		}
			
	}
	
	function enterMouse() {
		
		var $this = this.data('banner');
		$this.isOver = true;
		
		clearTimeout($this.timer);
		
	}
	
	function exitMouse() {
		
		var $this = this.data('banner');
		$this.isOver = false;
		
		if(!$this.isRunning) $this.timeout();
		
	}
	
	function resize() {
		
		var i = globalBanners.length,
		caption,
		scaled,
		$this,
		data,
		plus,
		tops,
		par,
		cap,
		ar,
		sc,
		hh,
		h,
		j,
		k;
		
		while(i--) {
		
			data = globalBanners[i];
			$this = data[0];
			par = data[1];
			ar = data[2];
			sc = data[3];
			hh = data[4];
			h = data[5];
			
			scaled = Math.min(par.width() / $this.totalWidth, 1).toFixed(2);
			plus = scaled < 1 ? (1 - parseFloat(scaled)) + 1 : 1;
			j = ar ? ar.length : 0;
			
			if(scaled < 0.5) {
			
				if(scaled > 0.25) {
				
					plus += 0.5;
					
				}
				else {
				
					plus += 0.75;
					
				}
				
			}
			
			while(j--) {
				
				caption = ar[j].data("captions");
				if(!caption) continue;
				k = caption.length;
				
				while(k--) {
					
					cap = caption[k];
					
					if(sc) {
						
						if(scaled < 1) {
						
							tops = cap.data('rTop') * plus;
							
						}
						else {
						
							tops = cap.data('top');
							
						}
						
						cap.css('top', tops).domElement().style[transform] = 'scale(' + plus + ', ' + plus + ')';
						
					}
					else {
						
						if(scaled < 1) {
						
							cap.addClass('cj-zoom-hide-caption');
							
						}
						else {
						
							cap.removeClass('cj-zoom-hide-caption');
							
						}
						
					}
					
				}
				
			}
			
			$this = $this.banner;
			data = $this.data();
			$this.width(data.oWidth * scaled).height(data.oHeight * scaled).domElement().style[transform] = 'scale(' + scaled + ', ' + scaled + ')';
			
		}
		
	}
	
	
	$(document).ready(function() {
		
		touched = $.touchEnabled;
		transform = $.transforms();
		
		var zs = $('.cj-zoom-showcase');
		if(zs.length) zs.cjZoomShowcase();
		
	});
	
	
})(jQuick);









