/* --------------------------------------------- */
/* Author: http://codecanyon.net/user/CodingJack */
/* --------------------------------------------- */

/* JSHINT */
/* global zoomshowcase_defaults, ajaxurl, zoomshowcase_data, wp, tb_show, tb_remove, escape, unescape */

;(function($) {
	
	var defaults = zoomshowcase_defaults,
	deleteMessage = defaults.remove,
	slideText = defaults.slide,
	settingsTitle,
	transitioning,
	confirmTimer,
	imgContainer,
	contentTitle,
	confirmation,
	currentItem, 
	globalIndex,
	captionHtml,
	toSend = {},
	itemHolder,
	clipboard,
	slideHtml,
	preloader,
	menuItems,
	generator, 
	clipText,
	writeObj,
	settings,
	onDelete,
	content,
	holder, 
	parent,
	legacy,
	naming,
	input,
	saver,
	multi,
	adder,
	menu,
	isOn,
	func,
	
	button = '<span class="zoomshowcase-menu-item"' + 
				
				' data-easing="' + defaults.easing + '"' + 
				' data-autoplay="' + defaults.autoplay + '"' + 
				' data-sidezoom="' + defaults.sidezoom + '"' + 
				' data-backzoom="' + defaults.backzoom + '"' + 
				' data-customcss="' + defaults.customcss + '"' + 
				' data-randomize="' + defaults.randomize + '"' + 
				' data-googlefont="' + defaults.googlefont + '"' + 
				' data-responsive="' + defaults.responsive + '"' + 
				' data-imagewidth="' + defaults.imagewidth + '"' + 
				' data-imageheight="' + defaults.imageheight + '"' + 
				' data-bannerwidth="' + defaults.bannerwidth + '"' + 
				' data-sideopacity="' + defaults.sideopacity + '"' + 
				' data-autoplaydelay="' + defaults.autoplaydelay + '"' + 
				' data-mobilecaptions="' + defaults.mobilecaptions + '"' + 
				' data-animationspeed="' + defaults.animationspeed + '">' + 
                        
				'<span class="zoomshowcase-button"></span>' + 
				'<span class="zoomshowcase-remove"><span class="icon-remove"></span></span>' + 
				
			'</span>';
	
	$(document).ready(function() {
		
		holder = $(".zoomshowcase-holder");
		preloader = $(".zoomshowcase-waiting");
		settings = $(".zoomshowcase-settings");
		itemHolder = $(".zoomshowcase-item-holder");
		settingsTitle = settings.find(".zoomshowcase-title");
		
		clipboard = $(".zoomshowcase-clip");
		content = $(".zoomshowcase-content");
		contentTitle = content.find(".zoomshowcase-title");
		saver = $(".zoomshowcase-save").on("click.cj", saveBanner);
		clipText = $(".zoomshowcase-clip-text").on("focusin.cj", onFocus);
		generator = $(".zoomshowcase-generate").on("click.cj", generateShortcode);
		confirmation = $(".zoomshowcase-confirmation").hide().css("visibility", "visible");
		
		settings.find("input[name=zoomshowcase_name]").on("keyup.cj", updateName).on("change.cj", updateName);
		settings = settings.find("input, select, textarea");
		menuItems = [];
		isOn = 0;
		
		menu = $(".zoomshowcase-menu");
		menu.find(".zoomshowcase-menu-item").each(addInstance);
		menu.find(".zoomshowcase-create-item").on("click.cj", newInstance);
		
		var caption = $(".zoomshowcase-caption-skeleton");
		captionHtml = caption.html();
		caption.remove();
		
		var slide = $(".zoomshowcase-item-skeleton");
		slideHtml = slide.html();
		slide.remove();
		
		$(".zoomshowcase-success").hide().css("visibility", "visible");
		$("#zoomshowcase-submit").on("submit.cj", preventDefault);
		$(".zoomshowcase-input-small").on("keyup.cj", checkKey);
		$(".zoomshowcase-clipboard").on("click.cj", copyClip);
		
		adder = $(".zoomshowcase-addslide").on("click.cj", newSlide);
		legacy = window.hasOwnProperty("send_to_editor");
		parent = $(".zoomshowcase-button-holder");
		
		if(menuItems.length) {
			
			transitioning = true;
			preloader.show();
			
			currentItem = menuItems[0].addClass("zoomshowcase-active");
			addContent(currentItem);
		
		}
		
		$(window).on('beforeunload', confirmExit);
		
    });
	
	function confirmExit() {
		
		return '';
		
	}
	
	function saveBanner(event, custom, $this) {
		
		if(transitioning || saver.attr("disabled")) return;
		
		transitioning = true;
		preloader.show();
		writeContent();
		
		writeObj = {type: "add", slides: currentItem.data("content")};
		settings.each(writeSettings, ["cj"]);
		
		if($this) currentItem = $this;
		toSend["zs_" + currentItem.data("index")] = writeObj;
		
		$.post(ajaxurl, {
			
			action: "zoomshowcase",
			zoomshowcase_nonce: zoomshowcase_data.zoomshowcase_nonce,
			params: JSON.stringify(toSend)
			
		}, custom || saved);
		
	}
	
	function saved() {
		
		hidePreloader();
		clearTimeout(confirmTimer);
		
		confirmation.css({
			
			width: saver.outerWidth(),
			left: adder.outerWidth() + 9
			
		}).stop(true, true).fadeIn(300, fadeConfirmation);
		
	}
	
	function hidePreloader() {
	
		preloader.hide();
		transitioning = false;
		
	}
	
	function fadeConfirmation() {
	
		confirmTimer = setTimeout(fadeOutConfirm, 1500);
		
	}
	
	function fadeOutConfirm() {
	
		confirmation.fadeOut(300);
			
	}
	
	function addInstance(i) {
		
		var $this = $(this).data("index", i);
		
		menuItems[i] = $this.data({
			
			button: $this.children(".zoomshowcase-button"),
			closer: $this.children(".zoomshowcase-remove").on("click.cj", removeInstance)
			
		});
		
		if(i !== 0) {
			
			$this.on("click.cj", toggleContent);
			
		}
		else {
		
			$this.addClass("zoomshowcase-active");
			
		}
		
	}
	
	function removeInstance(event) {
	
		event.stopPropagation();
		if(transitioning) return;
	
		if(!window.confirm(deleteMessage)) return;
		
		transitioning = true;
		preloader.show();
		
		var $this = $(this).parent(),
		obj = {},
		data;
		
		globalIndex = $this.data("index");
		
		obj["zs_" + globalIndex] = {type: "remove", name: $this.attr("data-name")};
		menuItems.splice(globalIndex, 1);
		
		data = {
			
			action: "zoomshowcase",
			zoomshowcase_nonce: zoomshowcase_data.zoomshowcase_nonce,
			params: JSON.stringify(obj)
			
		};
		
		clean($this);
		$this.remove();
		updateIndexes();
		
		$.post(ajaxurl, data, dataRemoved);
		
	}
	
	function updateIndexes() {
	
		var i = menuItems.length;
		
		while(i--) menuItems[i].data("index", i);
		
	}
	
	function dataRemoved() {
	
		hidePreloader();
		
		if(globalIndex === isOn) {
			
			onDelete = true;
			transitionOut();
			
		}
		
	}
	
	function newInstance() {
		
		if(transitioning) return;
		
		preloader.show();
		transitionOut(holderFaded);
		
	}
	
	function transitionOut(callback) {
		
		transitioning = true;
		holder.stop(true, true).fadeOut(300, callback || transitionDone);
		
	}
	
	function holderFaded() {
		
		clipboard.removeClass("zoomshowcase-show-clip");
		
		if(currentItem && !saver.attr("disabled")) {
			
			transitioning = false;
			saveBanner(false, readyToShow);
			
		}
		else {
			
			readyToShow();
			
		}
		
	}
	
	function readyToShow() {
	
		if(currentItem) {
			
			settings.each(writeSettings);
			writeContent();
			
		}
		
		var leg = menuItems.length, legs = leg + 1;
		naming = "ZoomShowcase " + legs;
		$(".zoomshowcase-menu-item").each(testName, [legs]);
		
		if(leg > 1) {
		
			currentItem = menuItems[leg - 1].clone().off(".cj");
			
		}
		else {
		
			currentItem = $(button);
			
		}
		
		menuItems[leg] = currentItem.attr("data-name", naming).addClass("zoomshowcase-active").appendTo(parent);
		
		currentItem.data({
			
			index: leg,
			button: currentItem.children(".zoomshowcase-button").text(naming),
			closer: currentItem.children(".zoomshowcase-remove").off(".cj").on("click.cj", removeInstance)
			
		});
		
		getSettings(leg);
		
		$.post(ajaxurl, {
			
			action: "zoomshowcase",
			zoomshowcase_nonce: zoomshowcase_data.zoomshowcase_nonce,
			params: JSON.stringify(toSend)
			
		}, toggleContent);
		
	}
	
	function testName(leg) {
		
		if($(this).attr("data-name") === naming) {
			
			naming = "ZoomShowcase " + (100 + leg);
			
		}
		
	}
	
	function getSettings(leg) {
		
		writeObj = {type: "add"};
		
		$.each(currentItem[0].attributes, getAttribute);
		
		toSend["zs_" + leg] = writeObj;
		
	}
	
	function writeSettings(i) {
		
		var $this = $(this), name = $this.attr("name").split("_")[1], val;
		
		if($this.is("input")) {
			
			if($this.attr("type") === "text") {
				
				val = $this.val();
				
			}
			else if($this.attr("value") === "yes") {
				
				if($this.attr("checked")) {
					
					val = "yes";
					
				}
				else {
				
					return;
					
				}
				
			}
			else if($this.attr("value") === "no") {
				
				if($this.attr("checked")) {
					
					val = "no";
					
				}
				else {
				
					return;
					
				}
				
			}
			
		}
		else if($this.is("textarea")) {
			
			val = $this.val();
			val = val ? escape(val) : "";
			
		}
		else {
		
			val = $this.children().filter(":selected").val();
			
		}
		
		if(!isNaN(i)) {
			
			currentItem.attr("data-" + name, val);
			
		}
		else {
			
			writeObj[name] = val;
			
		}
		
	}
	
	function writeContent() {
		
		var items = itemHolder.children(), 
		leg = items.length, 
		slides = [],
		captions,
		slogans,
		$this, 
		len,
		obj,
		i,
		j;
		
		for(i = 0; i < leg; i++) {
		
			$this = $(items[i]);
			slogans = $this.find(".zoomshowcase-caption-holder").children();
			len = slogans.length;
			obj = {};
			
			if(len) {
				
				captions = [];
			
				for(j = 0; j < len; j++) {
					
					writeObj = {};
					$(slogans[j]).find("input").each(writeSettings, ["cj"]);
					captions[j] = writeObj;
					
				}
				
				obj.captions = captions;
				
			}
			
			obj.image = $this.find("input[name=zoomshowcase_image]").val();
			obj.hyperlink = $this.find("input[name=zoomshowcase_hyperlink]").val();
			obj.target = $this.find("input[name=zoomshowcase_target]:checked").val();
			
			slides[i] = obj;
			
		}
		
		currentItem.data("content", slides);
		
	}
	
	function getAttribute(i, attr) {
		
		var name = attr.name;
		
		writeObj[name.split("data-")[1]] = attr.value;
		
	}
	
	function toggleContent(event) {
		
		if(event) {
			
			if(transitioning) return;
			if(currentItem) {
			
				settings.each(writeSettings);
				
				if(!saver.attr("disabled")) {
					
					saveBanner(false, toToggle, $(this));
					return;
				
				}
				else {
				
					writeContent();
					
				}
				
			}
			
			currentItem = $(this);
			
		}
		
		toToggle();
		
	}
	
	function toToggle() {
	
		isOn = currentItem.data("index");
		currentItem.off(".cj").addClass("zoomshowcase-active");
		
		updateMenu();
		transitionOut();
		
	}
	
	function updateMenu() {
	
		var i = menuItems.length;
		
		while(i--) {
			
			if(i !== isOn) menuItems[i].removeClass("zoomshowcase-active").off(".cj").on("click.cj", toggleContent);
			
		}
		
	}
	
	function transitionDone() {
		
		toggleSave(0);
		clipboard.removeClass("zoomshowcase-show-clip");
		
		if(!onDelete) {
			
			addContent();
			
		}
		else {
		
			transitioning = false;
			onDelete = false;
			
		}
		
	}
	
	function addContent() {
		
		clean(itemHolder);
		itemHolder.empty().hide();
		
		updateName(false, currentItem.attr("data-name"));
		settings.each(readSettings);
		
		var slides = currentItem.data("content");
		
		if(slides) {
			
			contentReady("regular", slides);
			
		}
		else {
			
			$.post(ajaxurl, {
				
				name: currentItem.attr("data-name"),
				action: "zoomshowcase",
				zoomshowcase_nonce: zoomshowcase_data.zoomshowcase_nonce
				
			}, contentReady);	
			
		}
		
	}
	
	function contentReady(data, slides) {
		
		if(data !== "regular") {
			
			slides = $.parseJSON(data);
			
			if(slides && slides.slides) {
			
				readContent(slides.slides);
				itemHolder.show();
				
			}
			
		}
		else if(slides.length) {
			
			readContent(slides);
			itemHolder.show();
			
		}
		
		hidePreloader();
		holder.stop(true, true).fadeIn(300);
		onDelete = transitioning = false;
		
	}
	
	function clean(obj) {
                        
		var itm;
		
		while(obj.children().length) {
				
			itm = obj.children(":eq(0)").stop(true).off(".cj").removeData().detach();
			clean(itm);
				
		}
			
	}
	
	function updateName(event, st) {
	
		var value = event ? $(this).val() : st;
		
		currentItem.data("button").text(value);
		contentTitle.text(value);
		settingsTitle.text(value);
		
	}
	
	function readSettings(slogan) {
		
		var $this = $(this),
		type = $this.attr("type");
		
		if(type === "submit") return;
		
		var name = $this.attr("name").split("zoomshowcase_")[1],
		value = !isNaN(slogan) ? currentItem.attr("data-" + name) : slogan[name];
		
		if($this.is("input")) {
			
			if(type === "text") {
				
				$this.val(value);
				
			}
			else if(value === "yes") {
				
				if($this.attr("value") === "yes") $this.attr("checked", "checked");
				
			}
			else if($this.attr("value") === "no") {
				
				$this.attr("checked", "checked");
				
			}
			
		}
		else if($this.is("textarea")) {
			
			$this.val(unescape(value));
			
		}
		else {
			
			var option = $this.children(), i = option.length;
			
			while(i--) {
			
				if($(option[i]).attr("value") === value) {
				
					$this[0].selectedIndex = i;
					break;
					
				}
				
			}
			
		}
		
	}
	
	function readContent(slides) {
		
		var leg = slides.length, slide, $this, caption, captions, slogan, holder, len, i, j, img, par, val, multi;
		
		for(i = 0; i < leg; i++) {
			
			$this = $("<div />").addClass("zoomshowcase-item").html(slideHtml).appendTo(itemHolder);
			
			slide = slides[i];
			$this.find("input").each(readSettings, [slide]);
			
			img = $this.find("input[name=zoomshowcase_image]");
			val = img.val();
			
			if(val) {
			
				par = img.parent();
				img = par.children(".zoomshowcase-image-holder").empty().hide();
				multi = par.children(".zoomshowcase-multimedia").addClass("zoomshowcase-loading");
				
				loadMedia(val, img, multi);
				
			}
			
			addEvents($this);
			captions = slide.captions;
			
			if(captions) {
				
				len = captions.length;
				holder = $this.find(".zoomshowcase-caption-holder").show();
				
				for(j = 0; j < len; j++) {
					
					slogan = captions[j];
					caption = $("<div />").addClass("zoomshowcase-item").html(captionHtml).appendTo(holder);
					
					caption.find("input, select").each(readSettings, [slogan]);
					addCaptionEvents(caption, holder);
					
				}
				
			}
			
		}
		
	}
	
	function newSlide() {
		
		if(transitioning) return;
		
		addEvents($("<div />").addClass("zoomshowcase-item").html(slideHtml).appendTo(itemHolder.show()));
		
	}
	
	function removeItem() {
		
		if(window.confirm(deleteMessage)) {
			
			var $this = $(this), 
			itm = $this.closest(".zoomshowcase-item"),
			parent = itm.parent();
			
			clean(itm);
			itm.remove();
			itemHolder.children(".zoomshowcase-item").each(checkTitles);
			if(!parent.children().length) parent.hide();
			
		}
		
	}
	
	function checkTitles(i) {
		
		$(this).find(".zoomshowcase-text").text(slideText + " - " + (i + 1));
		
	}
	
	function addEvents(itm) {
		
		var dataHolder = itm.children(".zoomshowcase-data-holder"),
		items = itemHolder.children(),
		leg = items.length;
		
		itm.data("holder", dataHolder).find(".zoomshowcase-toggle").data("child", dataHolder).off(".cj").on("click.cj", toggleItem);
		itm.find("input[name=zoomshowcase_image]").off(".cj").on("focusin.cj", inFocus).on("focusout.cj", outFocus);
		itm.find(".zoomshowcase-text").text(slideText + " - " + leg);
		
		itm.find(".zoomshowcase-addcaption").off(".cj").on("click.cj", addCaption);
		itm.find(".zoomshowcase-remover").off(".cj").on("click.cj", removeItem);
		itm.find(".zoomshowcase-addmedia").off(".cj").on("click.cj", openModal);
		
		itemHolder.sortable();
		if(leg) items.each(cycleCaptions);
		
		toggleSave(leg);
		
	}
	
	function toggleSave(leg) {
	
		if(leg) { 

			saver.attr("disabled", false);
			generator.attr("disabled", false);
			
		}
		else {
			
			saver.attr("disabled", true);
			generator.attr("disabled", true);
			
		}
		
	}
	
	function cycleCaptions() {
		
		var captionHolder = $(this).find(".zoomshowcase-caption-holder");
		captionHolder.children().each(addCaptionEvents, [false, captionHolder]);
		
	}
	
	function addCaption() {
		
		if(transitioning) return;
		
		var captionHolder = $(this).parent().next(".zoomshowcase-caption-holder").show();
		addCaptionEvents($("<div />").addClass("zoomshowcase-item").html(captionHtml).appendTo(captionHolder), captionHolder);
		
	}
	
	function addCaptionEvents(cap, captionHolder) {
		
		var caption = cap || $(this),
		cText = caption.find("input[name=zoomshowcase_caption]"),
		captionText = cText.val();
		
		caption.find(".zoomshowcase-toggle").data("child", caption.children(".zoomshowcase-data-holder")).off(".cj").on("click.cj", toggleItem);
		caption.find(".zoomshowcase-remover").off(".cj").on("click.cj", removeItem);
		caption.find(".zoomshowcase-colorpicker").each(addColors);
		caption.find(".zoomshowcase-input-small").each(addKey);
		
		if(!captionText) captionText = "Caption - " + captionHolder.children().length;
		
		cText.data(
			
			"caption", caption.find(".zoomshowcase-text").text(captionText)
			
		).off(".cj").on("keyup.cj", updateCaption).val(captionText);
		
		captionHolder.sortable();
		
	}
	
	function addKey() {
	
		var $this = $(this);
		
		if(!$this.hasClass("cj-color-wheel")) $this.off(".cj").on("keyup.cj", checkKey);
		
	}
	
	function updateCaption() {
	
		var $this = $(this);
		
		$this.data("caption").text($this.val());
		
	}
	
	function addColors(i) {

		var $this = $(this), 
		color = $this.prev("input").data("child", $this).off(".cj").on("focusin.cj", toggleItem).on("focusout.cj", toggleItem),
		val = color.val();
		
		if(!val) val = i === 0 ? "#000000" : "#FFFFFF";
		
		$this.farbtastic(color);
		$.farbtastic($this).setColor(val);
		color.val(val);
		
	}
	
	function toggleItem() {

		var $this = $(this), data = $this.data();

		if(!data.active) {
		
			data.child.stop(true, true).fadeIn(300);
			$this.data("active", true);
			
		}
		else {
		
			data.child.stop(true, true).fadeOut(300);
			$this.data("active", false);
			
		}
		
	}
	
	function checkKey() {

		this.value = this.value.replace(/[^0-9\.|#|-]/g, "");

	}
	
	function inFocus() {

		var $this = $(this), value = $this.val();
		
		if(!value) return;
		
		$this.data("orig", value);

	}	

	function outFocus() {

		var $this = $(this), value = $this.val(), par;
		if(value === $this.data("orig")) return;
		
		par = $this.parent();
		imgContainer = par.children(".zoomshowcase-image-holder");
		
		multi = par.children(".zoomshowcase-multimedia");
		input = par.children("input");
		
		loadMedia(value);

	}
	
	function openModal() {
		
		if(!legacy) {
			
			func = wp.media.editor.send.attachment;
			wp.media.editor.send.attachment = updateMedia;
			
		}
		else {
		
			func = window.send_to_editor;
			window.send_to_editor = updateMedia;
			
		}
		
		var $this = $(this), 
		par = $this.parent().parent();
		
		imgContainer = par.children(".zoomshowcase-image-holder");
		multi = par.children(".zoomshowcase-multimedia");
		input = par.children("input");
		
		if(!legacy) {
			
			wp.media.editor.open($this);	
			$(".media-menu").children(":eq(1)").hide();
		
		}
		else {
			
			tb_show("", "media-upload.php?type=image&amp;TB_iframe=true");
			
		}
		
	}
	
	function updateMedia(html, attachment) {

		var url;
		
		if(!legacy) {
		
			url = attachment.url;
			wp.media.editor.send.attachment = func;
			
		}
		else {
			
			url = $(html);
			url = url.attr("src") || url.attr("href");
			
			tb_remove();
			window.send_to_editor = func;
			
		}
		
		input.val(url);
		loadMedia(url);

	}
	
	function loadMedia(url, img, mult) {
		
		if(!getType(url)) return;
		
		var el = $("<img />").one("load.cj", mediaLoaded).one("error.cj", mediaError);
		
		if(!img) {
		
			imgContainer.empty().hide();
			multi.addClass("zoomshowcase-loading");
			el.appendTo(imgContainer);
			
		}
		else {
		
			el.data("multi", mult).appendTo(img);
			
		}
		
		el.attr("src", url);

	}
	
	function getType(url) {

		var spliced = url.split(".");
		if(!spliced.length) return null;

		spliced = spliced[spliced.length - 1];
		return spliced === "jpg" || spliced === "png" || spliced === "gif" || null;

	}
	
	function mediaLoaded() {
		
		var $this = $(this).unbind("error.cj"),
		mult = $this.data("multi");
		
		if(!mult) {
			
			multi.removeClass("zoomshowcase-loading");
			imgContainer.css("display", "inline-block");
			
		}
		else {
		
			mult.removeClass("zoomshowcase-loading");
			$this.removeData("multi").parent().css("display", "inline-block");
			
		}

		var w = this.width || $this.width(),
		h = this.height || $this.height(),
		perc = h > 75 ? 75 / h : 1;

		if(w * perc > 274) perc = 274 / w;
		$this.attr({width: w * perc, height: h * perc}).on("click.cj", openModal);
		
		imgContainer = multi = input = null;

	}
	
	function mediaError() {
		
		multi.removeClass("zoomshowcase-loading");
		$(this).unbind("load.cj");
		
		imgContainer = multi = input = null;

	}
	
	function preventDefault(event) {
		
		event.preventDefault();
		
	}
	
	function generateShortcode() {
		
		if(!transitioning) saveBanner(false, hidePreloader);
		
		clipboard.addClass("zoomshowcase-show-clip");
		clipText.val(
		
			'[zoomshowcase name="' + currentItem.attr("data-name") + '" /]'
		
		);
		
	}
	
	function copyClip() {
	
		window.prompt("Copy to clipboard: Ctrl+C", clipText.val());
		
	}
	
	function onFocus(event) {
		
		event.preventDefault();
		
		var $this = this;
		setTimeout(function() {$this.select();}, 100);
		
	}
	
	
})(jQuery);

// called from Flash, copy to clipboard swf
function cjClipboard(set) {
	
	if(!set) {
	
		jQuery(".zoomshowcase-success").stop(true, true).fadeIn(300, function() {
			
			var $this = jQuery(this), timer;
			clearTimeout($this.data("timer"));
			
			timer = setTimeout(function() {$this.fadeOut(300);}, 1500);
			$this.data("timer", timer);
			
		});
		
		return jQuery(".zoomshowcase-clip-text").val();
		
	}
	else {
	
		jQuery(document).ready(function() {
			
			jQuery(".zoomshowcase-board").css("z-index", 999);
			
		});
		
	}
	
}







