<?php

	function zoomshowcase_admin() {
		
		global $zoomshowcase_options;
		
		ob_start(); ?>

		<div class="wrap zoomshowcase-wrap">
			
			<h1 class="zoomshowcase-header">
			
				ZoomShowcase Banner Rotator - by <a href="http://codecanyon.net/user/CodingJack" target="_blank">CodingJack</a>
            	<img class="zoomshowcase-waiting" src="<?php echo admin_url("/images/wpspin_light.gif"); ?>" />
                
            </h1>

			<div class="zoomshowcase-menu">
				
				<div> 

					<input type="submit" class="button-primary zoomshowcase-create-item" value="<?php _e("Create New ZoomShowcase", "zoomshowcase_domain"); ?>" />

				</div>

				<div class="zoomshowcase-button-holder">

				<?php
					
					$showcases = $zoomshowcase_options["shortcodes"];
					
					foreach($showcases as $showcase) {
						
						$name = $showcase["name"];
						
						?>
 
                        <span class="zoomshowcase-menu-item" 
                        
                            data-name="<?php echo $name ?>" 
                            data-easing="<?php echo $showcase["easing"]; ?>" 
                            data-sidezoom="<?php echo $showcase["sidezoom"]; ?>" 
                            data-backzoom="<?php echo $showcase["backzoom"]; ?>" 
                            data-autoplay="<?php echo $showcase["autoplay"]; ?>" 
                            data-customcss="<?php echo $showcase["customcss"]; ?>" 
                            data-randomize="<?php echo $showcase["randomize"]; ?>"   
                            data-responsive="<?php echo $showcase["responsive"] ?>" 
                            data-googlefont="<?php echo $showcase["googlefont"]; ?>"  
                            data-imagewidth="<?php echo $showcase["imagewidth"]; ?>" 
                            data-imageheight="<?php echo $showcase["imageheight"]; ?>" 
                            data-bannerwidth="<?php echo $showcase["bannerwidth"]; ?>" 
                            data-sideopacity="<?php echo $showcase["sideopacity"]; ?>" 
                            data-autoplaydelay="<?php echo $showcase["autoplaydelay"]; ?>" 
                            data-mobilecaptions="<?php echo $showcase["mobilecaptions"]; ?>" 
                            data-animationspeed="<?php echo $showcase["animationspeed"]; ?>"> 
                            
                            <span class="zoomshowcase-button"><?php echo $name; ?></span>
                            <span class="zoomshowcase-remove"></span>
                            
                        </span>
						
						<?php

					}

				?>

				</div>

			</div>

            <div class="zoomshowcase-holder">
            
                <div class="zoomshowcase-panel zoomshowcase-settings">
                    
                    <h2>SETTINGS - <span class="zoomshowcase-title"></span></h2><hr />
                        
                    <div class="zoomshowcase-div">
                        <?php _e("Name ID", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Create a name for this banner instance", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input name="zoomshowcase_name" type="text" />
                    </div>
    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Autoplay", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Choose to auto-rotate the items", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <span class="zoomshowcase-radio-box">
                            <input name="zoomshowcase_autoplay" type="radio" value="yes" /> <?php _e("yes", "zoomshowcase_domain"); ?>
                            <input name="zoomshowcase_autoplay" type="radio" value="no"  checked="checked" /> <?php _e("no", "zoomshowcase_domain"); ?>
                        </span>
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Autoplay Delay", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("The autoplay delay in milliseconds (1000 = 1 second)", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_autoplaydelay" type="text" />
                    </div>
                    
                    <hr />
    
                    <div class="zoomshowcase-div">
                        <?php _e("Make Banner Responsive", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("If chosen, the banner will scale to the width of the parent container", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <span class="zoomshowcase-radio-box">
                            <input name="zoomshowcase_responsive" type="radio" value="yes" /> <?php _e("yes", "zoomshowcase_domain"); ?>
                            <input name="zoomshowcase_responsive" type="radio" value="no" checked="checked" /> <?php _e("no", "zoomshowcase_domain"); ?>
                        </span>
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Show Text when Responsive", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("If your captions are long, select 'no' to auto-hide them on mobile", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <span class="zoomshowcase-radio-box">
                            <input name="zoomshowcase_mobilecaptions" type="radio" value="yes" checked="checked" /> <?php _e("yes", "zoomshowcase_domain"); ?>
                            <input name="zoomshowcase_mobilecaptions" type="radio" value="no" /> <?php _e("no", "zoomshowcase_domain"); ?>
                        </span>
                    </div>
                    
                    <hr />
    
                    <div class="zoomshowcase-div">
                        <?php _e("Randomize Slides", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Choose to randomize the slide order every time the page loads", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <span class="zoomshowcase-radio-box">
                            <input name="zoomshowcase_randomize" type="radio" value="yes" /> <?php _e("yes", "zoomshowcase_domain"); ?>
                            <input name="zoomshowcase_randomize" type="radio" value="no"  checked="checked" /> <?php _e("no", "zoomshowcase_domain"); ?>
                        </span>
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Banner Width", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Enter the normal width of the banner", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_bannerwidth" type="text" />
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Image Width", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Enter the width of your images", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_imagewidth" type="text" />
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Image Height", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Enter the height of your images", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_imageheight" type="text" />
                    </div>
    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Side Zoom Percentage", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Enter percentage that the side slides should scale to, 0-1", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_sidezoom" type="text" />
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Side Slide Opacity", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("The transparency level of the side slides, 0-1", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_sideopacity" value="0.5" type="text" />
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Back Zoom Percentage", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("Enter percentage that the back slide should scale to, 0-1", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_backzoom" type="text" />
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Transition Easing", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("The easing function to use for each animation", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <select name="zoomshowcase_easing">
                            <option value="Quint.easeOut" selected>Quint.easeOut</option>
                            <option value="Quart.easeOut">Quart.easeOut</option>
                            <option value="Quad.easeOut">Quad.easeOut</option>
                            <option value="Cubic.easeOut">Cubic.easeOut</option>
                            <option value="Circ.easeOut">Circ.easeOut</option>
                            <option value="Sine.easeOut">Sine.easeOut</option>
                            <option value="Expo.easeOut">Expo.easeOut</option>
                        </select>
                    </div>
    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                        <?php _e("Transition Duration", "zoomshowcase_domain"); ?> 
                        <span data-title="<?php _e("The animation duration in milliseconds (1000 = 1 second)", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input class="zoomshowcase-input-small" name="zoomshowcase_animationspeed" type="text" />
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                    	Google Font Name
                        <span data-title="<?php _e("See help docs for naming protocol.  Leave empty for no Google Font", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <input name="zoomshowcase_googlefont" value="Yanone+Kaffeesatz" type="text" />
                    </div>
                    
                    <hr />
                    
                    <div class="zoomshowcase-div">
                    	Custom CSS
                        <span data-title="<?php _e("Add custom CSS to override default styles", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                        <textarea name="zoomshowcase_customcss"></textarea>
                    </div>
        
                </div>
                
                <div class="zoomshowcase-panel zoomshowcase-content">
                    
                    <h2>CONTENT - <span class="zoomshowcase-title"></span></h2>
                    
                    <hr />
                    
                    <div class="submit-zoomshowcase">
                    	
                        <form autocomplete="off" id="zoomshowcase-submit">
                        	<input type="submit" class="button-primary zoomshowcase-addslide" value="<?php _e("Add Slide", "zoomshowcase_domain"); ?>" />
                        	<input type="submit" class="button-primary zoomshowcase-save" disabled value="<?php _e("Save Changes", "zoomshowcase_domain"); ?>" />
                            <span class="zoomshowcase-confirmation"><?php _e("banner saved", "zoomshowcase_domain"); ?></span>
                        	<input type="submit" class="button-primary zoomshowcase-generate" disabled value="<?php _e("Generate Shortcode", "zoomshowcase_domain"); ?>" />
                     	</form>

                        <div class="zoomshowcase-clip"><span class="zoomshowcase-success"><?php _e("copied", "zoomshowcase_domain"); ?></span>
                        	
                            <input type="text" class="zoomshowcase-clip-text" />
                            
                            <span class="zoomshowcase-board">
                                <object type="application/x-shockwave-flash" width="125" height="24" data="<?php echo plugins_url("wp-zoomshowcase/clipboard/clipboard.swf"); ?>" id="zoomshowcase-clipboard-swf">
                                    <param name="movie" value="<?php echo plugins_url("wp-zoomshowcase/clipboard/clipboard.swf"); ?>" />
                                    <param name="allowScriptAccess" value="always" />
                                    <param name="wmode" value="transparent">
                                </object>
                            </span>
                            <input type="submit" class="button-primary zoomshowcase-clipboard" value="<?php _e("Copy to Clipboard", "zoomshowcase_domain"); ?>" />
                        
                        </div>
                        
                    </div>
                    
                    <div class="zoomshowcase-item-holder"></div>
                    
                    <div class="zoomshowcase-item-skeleton">
                            
                        <span class="zoomshowcase-text-holder">
                        
                        	<span class="zoomshowcase-text"></span>
                            <span class="zoomshowcase-remover"></span>
                            <span class="zoomshowcase-toggle"></span>
                        
                        </span>
                              
                        <div class="zoomshowcase-data-holder">
                            
                            <div class="zoomshowcase-data">
                            
                                <div class="zoomshowcase-div"><span class="zoomshowcase-multimedia"><?php _e("Slide Image", "zoomshowcase_domain"); ?> 
                                	<img class="zoomshowcase-addmedia" src="<?php echo home_url("wp-admin/images/media-button.png"); ?>" />
                                    <span class="zoomshowcase-question" data-title="<?php _e("The image to be used for the slide", "zoomshowcase_domain"); ?>">?</span></span>
                                    <br /><input name="zoomshowcase_image" type="text" value="" />
                                    <span class="zoomshowcase-media zoomshowcase-image-holder"></span>
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Slide Hyperlink", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("Enter a url if you wish to hyperlink the slide, otherwise leave blank", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <input name="zoomshowcase_hyperlink" type="text" value="" />
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Open Link in New Window", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("no", "zoomshowcase_domain"); ?> = '_parent', <?php _e("yes", "zoomshowcase_domain"); ?> = '_blank'" class="zoomshowcase-question"></span><br />
                                    <span class="zoomshowcase-radio-box">
                                    	<form autocomplete="off">
                                            <input name="zoomshowcase_target" type="radio" value="yes" /> <?php _e("yes", "zoomshowcase_domain"); ?>
                                            <input name="zoomshowcase_target" type="radio" value="no" checked /> <?php _e("no", "zoomshowcase_domain"); ?>
                                        </form>
                                    </span>
                                </div>
                                
                                <hr />
                                
                                <div class="submit-zoomshowcase submit-zoomshowcase-caption">
                                	<input type="submit" class="button-primary zoomshowcase-addcaption" value="<?php _e("Add Text caption", "zoomshowcase_domain"); ?>" />
                                </div>
                                
                                <div class="zoomshowcase-caption-holder"></div>
                                
                            </div>
                        
                        </div>
                        
                    </div>
                    
                    <div class="zoomshowcase-caption-skeleton">
                                                            
                        <span class="zoomshowcase-text-holder">
                        
                        	<span class="zoomshowcase-text"></span>
                            <span class="zoomshowcase-remover"></span>
                            <span class="zoomshowcase-toggle"></span>
                        
                        </span>
                        
                        <div class="zoomshowcase-data-holder">
                            
                            <div class="zoomshowcase-data">
                            
                                <div class="zoomshowcase-div">
                                    <?php _e("Caption Text", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("The text to be displayed", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <input name="zoomshowcase_caption" type="text" value="" />
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Alignment", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("Show caption on the left or right side of the slide", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <div class="zoomshowcase-radio-box">
                                    	<form autocomplete="off">
                                            <input name="zoomshowcase_align" type="radio" value="yes" checked="checked" /> <?php _e("left", "zoomshowcase_domain"); ?>
                                            <input name="zoomshowcase_align" type="radio" value="no" /> <?php _e("right", "zoomshowcase_domain"); ?>
                                        </form>
                                    </div>
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Position X", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("The caption's x position in pixels", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <input class="zoomshowcase-input-small" name="zoomshowcase_posx" type="text" value="20" />
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Position Y", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("The caption's y position in pixels", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <input class="zoomshowcase-input-small" name="zoomshowcase_posy" type="text" value="20" />
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Text Color", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("The caption's text color in hex format", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <input class="zoomshowcase-input-small cj-color-wheel" name="zoomshowcase_textcolor" type="text" value="" />
                                    <span class="zoomshowcase-colorpicker"></span>
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Background Color", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("The caption's background color in hex format", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <input class="zoomshowcase-input-small cj-color-wheel" name="zoomshowcase_bgcolor" type="text" value="" />
                                    <span class="zoomshowcase-colorpicker"></span>
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Caption Hyperlink", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("Enter a url if you wish to hyperlink the slide, otherwise leave blank", "zoomshowcase_domain"); ?>" class="zoomshowcase-question"></span><br />
                                    <input name="zoomshowcase_captionhyperlink" type="text" value="" />
                                </div>
                                
                                <hr />
                                
                                <div class="zoomshowcase-div">
                                    <?php _e("Open Link in New Window", "zoomshowcase_domain"); ?> 
                                    <span data-title="<?php _e("no", "zoomshowcase_domain"); ?> = '_parent', <?php _e("yes", "zoomshowcase_domain"); ?> = '_blank'" class="zoomshowcase-question"></span><br />
                                    <div class="zoomshowcase-radio-box">
                                    	<form autocomplete="off">
                                            <input name="zoomshowcase_captiontarget" type="radio" value="yes" /> <?php _e("yes", "zoomshowcase_domain"); ?>
                                            <input name="zoomshowcase_captiontarget" type="radio" value="no" checked="checked" /> <?php _e("no", "zoomshowcase_domain"); ?>
                                        </form>
                                    </div>
                                </div>
                                
                            </div>
                            
                        </div>
                        
                    </div>
                    
                </div>
                
            </div>
            
        </div>
        
		<?php echo ob_get_clean();

	}
	
	function zoomshowcase_ajax() {
		
		if(!isset($_POST["zoomshowcase_nonce"]) || !wp_verify_nonce($_POST["zoomshowcase_nonce"], "zoomshowcase-nonce")) {
			
			die("Data Failed to Save");
			
		}
		
		global $zoomshowcase_options;
		$shortcodes = $zoomshowcase_options["shortcodes"];
		
		if(isset($_POST["params"])) {
			
			$dataSet = json_decode(stripslashes($_POST["params"]), true);
		
			foreach($dataSet as $itm) {
				
				if($itm["type"] == "add") {
				
					$shortcodes[$itm["name"]] = $itm;
					
				}
				else {
					
					unset($shortcodes[$itm["name"]]);
					
				}	
				
			}
			
		}
		else {
			
			if(isset($_POST["name"])) {
				
				$name = $_POST["name"];
				
				if(array_key_exists($name, $shortcodes)) {
				
					echo json_encode($shortcodes[$name]);
					
				}
				
			}
			
			die();
			
		}
		
		$zoomshowcase_options["shortcodes"] = $shortcodes;
		update_option("zoomshowcase_options", $zoomshowcase_options);
		
		die();
			
	}
	
	function zoomshowcase_add_admin() {
		
		global $zoomshowcase_admin_options;
		
		$zoomshowcase_admin_options = add_plugins_page("zoomshowcase", "Zoom Showcase", "manage_options", "zoomshowcase_admin", "zoomshowcase_admin"); 

	}
	
	function zoomshowcase_admin_scripts($admin) {
		
		global $zoomshowcase_options;
		global $zoomshowcase_admin_options;
		
		if($admin != $zoomshowcase_admin_options) return;
		
		wp_enqueue_script("jquery");
		
		if(function_exists("wp_enqueue_media")) {
		
			wp_enqueue_media();
			
		}
		else {
				
			wp_enqueue_style("thickbox");
			wp_enqueue_script("thickbox");

		}
		
		wp_enqueue_style("farbtastic");
    	wp_enqueue_script("farbtastic");
		
		wp_enqueue_script("jquery-ui-core");
		wp_enqueue_script("jquery-ui-sortable");
		
		wp_enqueue_style("zoomshowcase_css", plugins_url("wp-zoomshowcase/css/wp-zoomshowcase.css"));  
		wp_enqueue_script("zoomshowcase_script", plugins_url("wp-zoomshowcase/js/wp-zoomshowcase.js"));
		
		wp_localize_script("zoomshowcase_script", "zoomshowcase_defaults", $zoomshowcase_options["defaults"]);
		wp_localize_script("zoomshowcase_script", "zoomshowcase_data", array("zoomshowcase_nonce" => wp_create_nonce("zoomshowcase-nonce")));
		
	}
	
	add_action("admin_enqueue_scripts", "zoomshowcase_admin_scripts");	
	add_action("admin_menu", "zoomshowcase_add_admin");
	add_action("wp_ajax_zoomshowcase", "zoomshowcase_ajax");


?>