var week;

$("#weekselect").live('pageinit',function(){
	$('#week-select').change(function(){
		week = $(this).val();
        $('#gameselect').show();
        return false;
	});
});

$( '#playerstats' ).live( 'pageshow',function(event){
	var chart301; // global
	var chartCRK;
	var chart601
	(function(){ // Import GET Vars
	   document.$_GET = [];
	   var urlHalves = String(document.location).split('?');
	   if(urlHalves[1]){
	      var urlVars = urlHalves[1].split('&');
	      for(var i=0; i<=(urlVars.length); i++){
	         if(urlVars[i]){
	            var urlVarPair = urlVars[i].split('=');
	            document.$_GET[urlVarPair[0]] = urlVarPair[1];
	         }
	      }
	   }
	})();
	/**
	 * Request data from the server, add it to the graph and set a timeout to request again
	 */
	function requestData301() {
	    $.ajax({
	    	type: "POST",
	        url: 'processes/getthree01.php',
	        data: { player_id: document.$_GET['id'], game_type: "301" },
	        success: function(point) {
	            var series = chart301.series[0],
	                shift = series.data.length > 20; // shift if the series is longer than 20

	            // add the point
	            for(i=0;i<parseInt(point[0][0]);i++){
	            	chart301.series[0].addPoint({x: parseFloat(point[i][1]), y: parseFloat(point[i][2]), din: point[i][3], dout: point[i][4], pda: point[i][5], win: point[i][6], tons: point[i][7]}, true, shift);
	            }
	        },
	        cache: false
	    });
	}

	function requestDataCRK() {
	    $.ajax({
	    	type: "POST",
	        url: 'processes/getcricket.php',
	        data: { player_id: document.$_GET['id'], game_type: "Cricket" },
	        success: function(point) {
	            var series = chartCRK.series[0],
	                shift = series.data.length > 20; // shift if the series is longer than 20

	            // add the point
	            for(i=0;i<parseInt(point[0][0]);i++){
	            	chartCRK.series[0].addPoint({x: parseFloat(point[i][1]), y: parseFloat(point[i][2]), mpd: point[i][3], tons: point[i][4], win: point[i][5]}, true, shift);
	            }
	        },
	        cache: false
	    });
	}

	function requestData601() {
	    $.ajax({
	    	type: "POST",
	        url: 'processes/getsix01.php',
	        data: { player_id: document.$_GET['id'], game_type: "601" },
	        success: function(point) {
	            var series = chart601.series[0],
	                shift = series.data.length > 20; // shift if the series is longer than 20

	            // add the point
	            for(i=0;i<parseInt(point[0][0]);i++){

	            	chart601.series[0].addPoint({x: parseFloat(point[i][1]),y: parseInt(point[i][2]), din: point[i][3], dout: point[i][4], pda: point[i][5], win: point[i][6], tons: point[i][7]}, true, shift);
	            }
	        },
	        cache: false
	    });
	}

	chart301 = new Highcharts.Chart({
         chart: {
            renderTo: 'chartdiv301',
            type: 'line',
            events: {
            	load: requestData301
            }
        },
        title: {
            text: '301'
        },
        legend: {
        	enabled: false
        },
        xAxis: {
        	style: {
        		color: '#000',
        	},
        	title: {
        		text: 'Weeks'
        	},
        	tickInterval: 1
        },
        yAxis: {
        	style: {
        		color: '#000',
        	},
            title: {
                text: 'Averages'
            }
        },
        tooltip: {
            formatter: function() {
                return '<b>Week'+this.x+'</b><br/>'+
                    '3DA: '+ this.y +'<br/>PDA: '+this.point.pda+'<br/>DI: '+this.point.din+'<br/>DO: '+this.point.dout+'<br/>W/L: '+this.point.win+'<br/>Tons: '+this.point.tons;
            }
        },
        series: [{
        	name: '3 Dart Avg',
            data: []
        }],
        credits: {
        	enabled:false
        }
      });

	chartCRK = new Highcharts.Chart({
         chart: {
            renderTo: 'chartdivCRK',
            type: 'line',
            events: {
            	load: requestDataCRK
            }
        },
        title: {
            text: 'Cricket'
        },
        legend: {
        	enabled: false
        },
        xAxis: {
        	style: {
        		color: '#000',
        	},
        	title: {
        		text: 'Weeks'
        	},
        	tickInterval: 1
        },
        yAxis: {
        	style: {
        		color: '#000',
        	},
            title: {
                text: 'Averages'
            }
        },
        tooltip: {
            formatter: function() {
                return '<b>Week'+this.x+'</b><br/>'+
                    'MPT: '+ this.y +'<br/>MPD: '+this.point.mpd+'<br/>Tons: '+this.point.tons+'<br />W/L: '+this.point.win;
            }
        },
        series: [{
        	name: 'Averages',
            data: []
        }],
        credits: {
        	enabled:false
        }
      });

	chart601 = new Highcharts.Chart({
         chart: {
            renderTo: 'chartdiv601',
            type: 'line',
            events: {
            	load: requestData601
            }
        },
        title: {
            text: '601'
        },
        legend: {
        	enabled: false
        },
        xAxis: {
        	style: {
        		color: '#000',
        	},
        	title: {
        		text: 'Weeks'
        	},
        	tickInterval: 1
        },
        yAxis: {
        	style: {
        		color: '#000',
        	},
            title: {
                text: 'Averages'
            }
        },
        tooltip: {
            formatter: function() {
                return '<b>Week'+this.x+'</b><br/>'+
                    '3DA: '+ this.y +'<br/>PDA: '+this.point.pda+'<br/>DI: '+this.point.din+'<br/>DO: '+this.point.dout+'<br/>W/L: '+this.point.win+'<br/>Tons: '+this.point.tons;
            }
        },
        series: [{
        	name: '3 Dart Avg',
            data: []
        }],
        credits: {
        	enabled:false
        }
      });
});


$( '#three01' ).live( 'pageinit',function(event){
	var totalscore = 0;
	var dartsused = 0;
	var tons = 0;
	var scoreleft = 301;

	$('#diplusone').click(function(){
		var di = parseInt($('#doublein').val()) + 1;
		$('#doublein').val(di);
		$('#doubleintext').html(di);
	});

	$('#diminusone').click(function(){
		var di = parseInt($('#doublein').val()) - 1;
		$('#doublein').val(di);
		$('#doubleintext').html(di);
	});

	$('#doplusone').click(function(){
		var dout = parseInt($('#doubleout').val()) + 1;
		$('#doubleout').val(dout);
		$('#doubleouttext').html(dout);
	});

	$('#dominusone').click(function(){
		var dout = parseInt($('#doubleout').val()) - 1;
		$('#doubleout').val(dout);
		$('#doubleouttext').html(dout);
	});

	$('#tonsplusone').click(function(){
		var tons = parseInt($('#tons').val()) + 1;
		$('#tons').val(tons);
	});

	$('#tonsminusone').click(function(){
		var tons = parseInt($('#tons').val()) - 1;
		$('#tons').val(tons);
	});

	$('#addscore').click(function(){
		
		var scores = $('#shotstext').html();
		var score = parseInt($('#shots').val());
		scoreleft = scoreleft - score;

		if(score == 180){
			tons = tons + 2;
		}else if(score > 99){
			tons = tons + 1;
		}
		
		var scorearray = new Array();
		
		scorearray.push(scorearray);

		totalscore += score;

		if(scores == ""){
			scores+=score;
		}else{
			scores+=", "+score;
		}

		$('#shotstext').html(scores);
		$('#shots').val("");

		dartsused = dartsused+3;

		var ppd = Math.round((totalscore / dartsused)*100)/100;
		var ppt = Math.round((ppd*3)*100)/100;

		$('#ppd').val(ppd);
		$('#ppt').val(ppt);
		$('#tons').val(tons);
		$('#ppdtext').html(ppd);
		$('#ppttext').html(ppt);
		$('#tonstext').html(tons);
		$('#scoreleft').html(scoreleft);
	});
});

$( '#cricket' ).live( 'pageinit',function(event){
	var onedartsthrown = 0;
	var oneshottotal = 0;
	var curtons = 0;
	var twodartsthrown = 0;
	var twoshottotal = 0;
	var curtonstwo = 0;

	$('#plus-tonone').click(function(){
		curtons = parseInt($('#tons-one').html());
		var tottons = curtons + 1;
		$('#tons-one').html(tottons);
		$('#one-tons').val(tottons);
	});

	$('#minus-tonone').click(function(){
		curtons = parseInt($('#tons-one').html());
		var tottons = curtons - 1;
		$('#tons-one').html(tottons);
		$('#one-tons').val(tottons);
	});

	$('#plus-nineone').click(function(){
		curtons = parseInt($('#tons-one').html());
		var tottons = curtons + 2;
		$('#tons-one').html(tottons);
		$('#one-tons').val(tottons);
	});

	$('#minus-nineone').click(function(){
		curtons = parseInt($('#tons-one').html());
		var tottons = curtons - 2;
		$('#tons-one').html(tottons);
		$('#one-tons').val(tottons);
	});

	$('#playeronesubmitshot').click(function(){
		var oneshotone = parseInt($('input:radio[name=shotone-one]:checked').val());
		var oneshottwo = parseInt($('input:radio[name=shottwo-one]:checked').val());
		var oneshotthree = parseInt($('input:radio[name=shotthree-one]:checked').val());

		oneshottotal = oneshottotal + (oneshotone + oneshottwo + oneshotthree);

		onedartsthrown = onedartsthrown + 3;

		var mpd = Math.round((oneshottotal/onedartsthrown)*100)/100;
		var mpt = Math.round((mpd*3)*100)/100;

		$('#mpd-one').html(mpd);
		$('#mpt-one').html(mpt);
		$('#one-mpd').val(mpd);
		$('#one-mpt').val(mpt);

		$('.cricketscores .ui-radio-on').addClass("ui-radio-off").removeClass("ui-btn-active").removeClass("ui-radio-on");
	});

	$('#plus-tontwo').click(function(){
		curtonstwo = parseInt($('#tons-two').html());
		var tottons = curtonstwo + 1;
		$('#tons-two').html(tottons);
		$('#two-tons').val(tottons);
	});

	$('#minus-tontwo').click(function(){
		curtonstwo = parseInt($('#tons-two').html());
		var tottons = curtonstwo - 1;
		$('#tons-two').html(tottons);
		$('#two-tons').val(tottons);
	});

	$('#plus-ninetwo').click(function(){
		curtonstwo = parseInt($('#tons-two').html());
		var tottons = curtonstwo + 2;
		$('#tons-two').html(tottons);
		$('#two-tons').val(tottons);
	});

	$('#minus-ninetwo').click(function(){
		curtonstwo = parseInt($('#tons-two').html());
		var tottons = curtonstwo - 2;
		$('#tons-two').html(tottons);
		$('#two-tons').val(tottons);
	});

	$('#playertwosubmitshot').click(function(){
		var twoshotone = parseInt($('input:radio[name=shotone-two]:checked').val());
		var twoshottwo = parseInt($('input:radio[name=shottwo-two]:checked').val());
		var twoshotthree = parseInt($('input:radio[name=shotthree-two]:checked').val());

		twoshottotal = twoshottotal + (twoshotone + twoshottwo + twoshotthree);

		twodartsthrown = twodartsthrown + 3;

		var twompd = Math.round((twoshottotal/twodartsthrown)*100)/100;
		var twompt = Math.round((twompd*3)*100)/100;

		$('#mpd-two').html(twompd);
		$('#mpt-two').html(twompt);
		$('#two-mpd').val(twompd);
		$('#two-mpt').val(twompt);

		$('.cricketscores .ui-radio-on').addClass("ui-radio-off").removeClass("ui-btn-active").removeClass("ui-radio-on");
	});
});

$( '#six01' ).live( 'pageinit',function(event){
	var p1totalscore = 0;
	var p1dartsused = 0;
	var p1tons = 0;

	var p2totalscore = 0;
	var p2dartsused = 0;
	var p2tons = 0;

	var p3totalscore = 0;
	var p3dartsused = 0;
	var p3tons = 0;

	//PLAYER ONE

	$('#p1diplusone').click(function(){
		var di = parseInt($('#p1doublein').val()) + 1;
		$('#p1doublein').val(di);
		$('#p1doubleintext').html(di);
	});

	$('#p1diminusone').click(function(){
		var di = parseInt($('#p1doublein').val()) - 1;
		$('#p1doublein').val(di);
		$('#p1doubleintext').html(di);
	});

	$('#p1doplusone').click(function(){
		var dout = parseInt($('#p1doubleout').val()) + 1;
		$('#p1doubleout').val(dout);
		$('#p1doubleouttext').html(dout);
	});

	$('#p1dominusone').click(function(){
		var dout = parseInt($('#p1doubleout').val()) - 1;
		$('#p1doubleout').val(dout);
		$('#p1doubleouttext').html(dout);
	});

	$('#p1tonsplusone').click(function(){
		var tons = parseInt($('#p1tons').val()) + 1;
		$('#p1tons').val(tons);
	});

	$('#p1tonsminusone').click(function(){
		var tons = parseInt($('#p1tons').val()) - 1;
		$('#p1tons').val(tons);
	});

	$('#p1addscore').click(function(){
		
		var p1scores = $('#p1shotstext').html();
		var p1score = parseInt($('#p1shots').val());

		if(p1score == 180){
			p1tons = p1tons + 2;
		}else if(p1score > 99){
			p1tons = p1tons + 1;
		}
		
		var p1scorearray = new Array();
		
		p1scorearray.push(p1scorearray);

		p1totalscore += p1score;

		if(p1scores == ""){
			p1scores+=p1score;
		}else{
			p1scores+=", "+p1score;
		}

		$('#p1shotstext').html(p1scores);
		$('#p1shots').val("");

		p1dartsused = p1dartsused+3;

		var p1ppd = Math.round((p1totalscore / p1dartsused)*100)/100;
		var p1ppt = Math.round((p1ppd*3)*100)/100;

		$('#p1ppd').val(p1ppd);
		$('#p1ppt').val(p1ppt);
		$('#p1tons').val(p1tons);
		$('#p1ppdtext').html(p1ppd);
		$('#p1ppttext').html(p1ppt);
		$('#p1tonstext').html(p1tons);
	});

	//PLAYER TWO
	$('#p2diplusone').click(function(){
		var di = parseInt($('#p2doublein').val()) + 1;
		$('#p2doublein').val(di);
		$('#p2doubleintext').html(di);
	});

	$('#p2diminusone').click(function(){
		var di = parseInt($('#p2doublein').val()) - 1;
		$('#p2doublein').val(di);
		$('#p2doubleintext').html(di);
	});

	$('#p2doplusone').click(function(){
		var dout = parseInt($('#p2doubleout').val()) + 1;
		$('#p2doubleout').val(dout);
		$('#p2doubleouttext').html(dout);
	});

	$('#p2dominusone').click(function(){
		var dout = parseInt($('#p2doubleout').val()) - 1;
		$('#p2doubleout').val(dout);
		$('#p2doubleouttext').html(dout);
	});

	$('#p2tonsplusone').click(function(){
		var tons = parseInt($('#p2tons').val()) + 1;
		$('#p2tons').val(tons);
	});

	$('#p2tonsminusone').click(function(){
		var tons = parseInt($('#p2tons').val()) - 1;
		$('#p2tons').val(tons);
	});

	$('#p2addscore').click(function(){
		
		var p2scores = $('#p2shotstext').html();
		var p2score = parseInt($('#p2shots').val());

		if(p2score == 180){
			p2tons = p2tons + 2;
		}else if(p2score > 99){
			p2tons = p2tons + 1;
		}
		
		var p2scorearray = new Array();
		
		p2scorearray.push(p2scorearray);

		p2totalscore += p2score;

		if(p2scores == ""){
			p2scores+=p2score;
		}else{
			p2scores+=", "+p2score;
		}

		$('#p2shotstext').html(p2scores);
		$('#p2shots').val("");

		p2dartsused = p2dartsused+3;

		var p2ppd = Math.round((p2totalscore / p2dartsused)*100)/100;
		var p2ppt = Math.round((p2ppd*3)*100)/100;

		$('#p2ppd').val(p2ppd);
		$('#p2ppt').val(p2ppt);
		$('#p2tons').val(p2tons);
		$('#p2ppdtext').html(p2ppd);
		$('#p2ppttext').html(p2ppt);
		$('#p2tonstext').html(p2tons);
	});

	//PLAYER THREE
	$('#p3diplusone').click(function(){
		var di = parseInt($('#p3doublein').val()) + 1;
		$('#p3doublein').val(di);
		$('#p3doubleintext').html(di);
	});

	$('#p3diminusone').click(function(){
		var di = parseInt($('#p3doublein').val()) - 1;
		$('#p3doublein').val(di);
		$('#p3doubleintext').html(di);
	});

	$('#p3doplusone').click(function(){
		var dout = parseInt($('#p3doubleout').val()) + 1;
		$('#p3doubleout').val(dout);
		$('#p3doubleouttext').html(dout);
	});

	$('#p3dominusone').click(function(){
		var dout = parseInt($('#p3doubleout').val()) - 1;
		$('#p3doubleout').val(dout);
		$('#p3doubleouttext').html(dout);
	});

	$('#p3tonsplusone').click(function(){
		var tons = parseInt($('#p3tons').val()) + 1;
		$('#p3tons').val(tons);
	});

	$('#p3tonsminusone').click(function(){
		var tons = parseInt($('#p3tons').val()) - 1;
		$('#p3tons').val(tons);
	});

	$('#p3addscore').click(function(){
		
		var p3scores = $('#p3shotstext').html();
		var p3score = parseInt($('#p3shots').val());

		if(p3score == 180){
			p3tons = p3tons + 2;
		}else if(p3score > 99){
			p3tons = p3tons + 1;
		}
		
		var p3scorearray = new Array();
		
		p3scorearray.push(p3scorearray);

		p3totalscore += p3score;

		if(p3scores == ""){
			p3scores+=p3score;
		}else{
			p3scores+=", "+p3score;
		}

		$('#p3shotstext').html(p3scores);
		$('#p3shots').val("");

		p3dartsused = p3dartsused+3;

		var p3ppd = Math.round((p3totalscore / p3dartsused)*100)/100;
		var p3ppt = Math.round((p3ppd*3)*100)/100;

		$('#p3ppd').val(p3ppd);
		$('#p3ppt').val(p3ppt);
		$('#p3tons').val(p3tons);
		$('#p3ppdtext').html(p3ppd);
		$('#p3ppttext').html(p3ppt);
		$('#p3tonstext').html(p3tons);
	});
});