<?php
/*
--------------------------------------------------------------
API CLASS
--------------------------------------------------------------
*/
	
	if(!class_exists('api')){
		class api {

			public function get_checkouts($lang) {
				include('checkouts-'.$lang.'.php');
				$min = (is_numeric($_GET['min'])) ? $_GET['min'] : null;
				$max = (is_numeric($_GET['max'])) ? $_GET['max'] : null;
				if($min && $max){
					$cards = array();
					if($checkouts){
						foreach($checkouts as $checkout){
							if((int)$checkout['outnum'] >= $min && (int)$checkout['outnum'] <= $max){
								$checkout['option1'] = rtrim($checkout['a1'].'<i class="fa fa-chevron-right"></i>'.$checkout['a2'].'<i class="fa fa-chevron-right"></i>'.$checkout['a3'],'<i class="fa fa-chevron-right"></i>');
								if($checkout['b1']!=''){
									$checkout['option2'] = rtrim($checkout['b1'].', '.$checkout['b2'].', '.$checkout['b3'],', ');
								}
								if($checkout['c1']!=''){
									$checkout['option3'] = rtrim($checkout['c1'].', '.$checkout['c2'].', '.$checkout['c3'],', ');
								}
								array_push($cards,$checkout);
							}
						}
						shuffle($cards);
						if(!empty($cards)){
							send_json_success(array('cards'=>$cards));
						}
						send_json_error(array('message'=>'No cards found.'));
					}
					send_json_error(array('message'=>'Error getting checkouts.'));
				}
				send_json_error(array('message'=>'No min and/or max set and must be numeric.'));
			}

			public function get_all_checkouts($lang) {
				include('checkouts-'.$lang.'.php');
				if($checkouts){
					$cards = array();
					foreach($checkouts as $checkout){
						$checkout['option1'] = rtrim($checkout['a1'].', '.$checkout['a2'].', '.$checkout['a3'],', ');
						if($checkout['b1']!=''){
							$checkout['option2'] = rtrim($checkout['b1'].', '.$checkout['b2'].', '.$checkout['b3'],', ');
						}
						if($checkout['c1']!=''){
							$checkout['option3'] = rtrim($checkout['c1'].', '.$checkout['c2'].', '.$checkout['c3'],', ');
						}
						array_push($cards,$checkout);
					}
					shuffle($cards);
					send_json_success(array('cards'=>$cards));
				}
				send_json_error(array('message'=>'Error getting checkouts.'));
			}

			public function get_setups($lang) {
				include('setups-'.$lang.'.php');
				$min = (is_numeric($_GET['min'])) ? $_GET['min'] : null;
				$max = (is_numeric($_GET['max'])) ? $_GET['max'] : null;
				if($min && $max){
					$cards = array();
					if($setups){
						foreach($setups as $setup){
							if((int)$setup['outnum'] >= $min && (int)$setup['outnum'] <= $max){
								array_push($cards,$setup);
							}
						}
						shuffle($cards);
						if(!empty($cards)){
							send_json_success(array('cards'=>$cards));
						}
						send_json_error(array('message'=>'No cards found.'));
					}
					send_json_error(array('message'=>'Error getting setups.'));
				}
				send_json_error(array('message'=>'No min and/or max set and must be numeric.'));
			}

			public function get_all_setups($lang) {
				include('setups-'.$lang.'.php');
				if($setups){
					$cards = array();
					foreach($setups as $setup){
						array_push($cards,$setup);
					}
					shuffle($cards);
					send_json_success(array('cards'=>$cards));
				}
				send_json_error(array('message'=>'Error getting checkouts.'));
			}

			public function get_all($lang) {
				include('setups-'.$lang.'.php');
				include('checkouts-'.$lang.'.php');
				if($setups){
					$cards = array();
					foreach($setups as $setup){
						$setup['type'] = 'setup';
						array_push($cards,$setup);
					}
					foreach($checkouts as $checkout){
						$checkout['option1'] = rtrim($checkout['a1'].', '.$checkout['a2'].', '.$checkout['a3'],', ');
						if($checkout['b1']!=''){
							$checkout['option2'] = rtrim($checkout['b1'].', '.$checkout['b2'].', '.$checkout['b3'],', ');
						}
						if($checkout['c1']!=''){
							$checkout['option3'] = rtrim($checkout['c1'].', '.$checkout['c2'].', '.$checkout['c3'],', ');
						}
						$checkout['type'] = 'out';
						array_push($cards,$checkout);
					}
					shuffle($cards);
					send_json_success(array('cards'=>$cards));
				}
				send_json_error(array('message'=>'Error getting checkouts and/or setups.'));
			}
		}

		global $api;
		$api = new api();
	}

/*
--------------------------------------------------------------
API
--------------------------------------------------------------
*/
	
if($_GET['action']){
	
	$lang = (isset($_GET['lang'])) ? $_GET['lang'] : 'en';

	switch($_GET['action']) {
		case 'get-checkouts':
			$api->get_checkouts($lang);
			break;
		case 'get-all-checkouts':
			$api->get_all_checkouts($lang);
			break;
		case 'get-setups':
			$api->get_setups($lang);
			break;
		case 'get-all-setups':
			$api->get_all_setups($lang);
			break;
		case 'get-all':
			$api->get_all($lang);
			break;
		default:
			send_json_error(array('message'=>'Action not found.'));
			break;
	}
}else{
	send_json_error(array('message'=>'Bad Request.'));
}

/*
--------------------------------------------------------------
FUNCTIONS
--------------------------------------------------------------
*/
	function send_json($response, $status_code=null) {
	    @header('Content-Type: application/json; charset=utf8');
	    if(null !== $status_code) {
	        status_header($status_code);
	    }
	    echo json_encode($response);
	    die;
	}

	function send_json_success($data=null, $status_code=null) {
	    $response = array('success' => true);
	 
	    if(isset($data))
	        $response['data'] = $data;
	 
	    send_json($response, $status_code);
	}

	function send_json_error($data=null, $status_code=null) {
	    $response = array('success' => false);
	 
	    if(isset($data)) {
	        $response['data'] = $data;
	    }
	 
	    send_json($response, $status_code);
	}
?>