var dartology = angular.module('dartology', [
    'ui.router',
    'ui.bootstrap',
    'ngStorage',
    'appServices',
    'appDirectives',
    'appFilters',
    'angular.vertilize',
    'ngTouch',
    'oitozero.ngSweetAlert',
    'ngMessages'
])

.config(function($stateProvider,$urlRouterProvider,$locationProvider){

    //$locationProvider.html5Mode(true);

	$stateProvider
        .state('initial', {
            templateUrl: 'initial.html',
            controller: function($state,$sessionStorage){
                if(angular.isUndefined($sessionStorage.appUser)){
                    $state.go('login');
                }else{
                    $state.go('app');
                }
            }
        })
        .state('login', {
            templateUrl: 'login.html',
            controller: function($rootScope,$scope,$state,$sessionStorage,fbServices,dataServices,SweetAlert){
                $scope.logging = false;
                $scope.manlogging = false;
                $scope.manual = [{'email':'','pass':''}];
                $scope.login = function(logtype){
                    switch(logtype){
                        case 'manual':
                            SweetAlert.swal({
                                title: "Email Address",
                                text: "What is your email address?",
                                type: "input",
                                showCancelButton: true,
                                closeOnConfirm: false,
                                confirmButtonColor: "#007337",
                                confirmButtonText: "Next",
                                closeOnConfirm: false },
                                function(inputValue){
                                    if(inputValue===false) return false;
                                    if(inputValue===""){
                                        SweetAlert.showInputError("Your email address is required for this!");
                                        return false;
                                    }
                                    $scope.manual.email = inputValue;
                                    SweetAlert.swal({
                                        title: "Password",
                                        text: "And, now your password?",
                                        type: "input",
                                        inputType: "password",
                                        showCancelButton: true,
                                        closeOnConfirm: false,
                                        confirmButtonText: "Log In",
                                        confirmButtonColor: "#007337",
                                        closeOnConfirm: false,
                                        showLoaderOnConfirm: true },
                                        function(inputValue){
                                            if(inputValue===false) return false;
                                            if(inputValue===""){
                                                SweetAlert.showInputError("This is required too!");
                                                return false;
                                            }
                                            $scope.manual.pass = inputValue;
                                            $scope.manlogging = true;
                                            dataServices.getUserDataManual($scope.manual.email,$scope.manual.pass).then(function(userData){
                                                $scope.manlogging = false;
                                                if(userData.status=='success'){
                                                    $sessionStorage.appUser = userData.data;
                                                    SweetAlert.close();
                                                    $state.go('app');
                                                }else if(userData.status=='error'){
                                                    SweetAlert.showInputError("Password is wrong for "+$scope.manual.email+'. Please try again.');
                                                }else{
                                                    console.log(userData);
                                                }
                                            });
                                        }
                                    );
                                }
                            );
                            break;
                        case 'fb':
                            if(!$rootScope.fbLogged){
                                fbServices.fbLogin().then(function(updateResponse){
                                    if(updateResponse.status=='success'){
                                        $scope.logging = true;
                                        dataServices.getUserData(updateResponse.data.id).then(function(userData){
                                            if(userData.status=='success'){
                                                $scope.logging = false;
                                                $sessionStorage.appUser = userData.data;
                                                $state.go('app');
                                            }else if(userData.status=='error'){
                                                console.log(userData.message);
                                                console.log(userData.data);
                                            }else{
                                                console.log(userData);
                                            }
                                        });
                                    }else if(updateResponse.status=='error'){
                                        console.log(updateResponse.message);
                                        console.log(updateResponse.data);
                                    }else{
                                        console.log(updateResponse);
                                    }
                                });
                            }else{
                                $scope.logging = true;
                                dataServices.getUserData($rootScope.fbUser.id).then(function(userData){
                                    if(userData.status=='success'){
                                        $scope.logging = false;
                                        $sessionStorage.appUser = userData.data;
                                        $state.go('app');
                                    }else if(userData.status=='error'){
                                        console.log(userData.message);
                                        console.log(userData.data);
                                    }else{
                                        console.log(userData);
                                    }
                                });
                            }  
                            break;
                    }
                                  
                }
            }
        })
        .state('logout', {
            templateUrl: 'logout.html',
            controller: function($rootScope,$scope,$state,$sessionStorage){
                delete $sessionStorage.appUser;
                delete $sessionStorage.appToday;
                $state.go('login');
            }
        })
        .state('app', {
            templateUrl: 'app.html',
            controller: function($state){
                $state.go('app.home');
            }
        })
        .state('app.home', {
            templateUrl: 'home.html',
            controller: function($rootScope,$scope,$sessionStorage,appRoutines,appCategories,appToday){
                if(angular.isUndefined($sessionStorage.appCategories)){
                    $scope.appCategories = $sessionStorage.appCategories = appCategories.data.categories;
                }else{
                    $scope.appCategories = $sessionStorage.appCategories;
                }

                if(angular.isUndefined($sessionStorage.appRoutines)){
                    $scope.appRoutines = $sessionStorage.appRoutines = appRoutines.data.routines;
                }else{
                    $scope.appRoutines = $sessionStorage.appRoutines;
                }

                if(angular.isUndefined($sessionStorage.appToday)){
                    $scope.appToday = $sessionStorage.appToday = appToday.data.routines;
                }else{
                    $scope.appToday = $sessionStorage.appToday;
                }
            },
            resolve: {
                appRoutines: function($http,$sessionStorage){
                    if(angular.isUndefined($sessionStorage.appRoutines)){
                        return $http({
                            method: 'GET',
                            url: '/services/data/get-routines.php'
                        });
                    }
                },
                appCategories: function($http,$sessionStorage){
                    if(angular.isUndefined($sessionStorage.appCategories)){
                        return $http({
                            method: 'GET',
                            url: '/services/data/get-categories.php'
                        });
                    }
                },
                appToday: function($rootScope,$http,$sessionStorage){
                    if(angular.isUndefined($sessionStorage.appToday)){
                        return $http({
                            method: 'GET',
                            url: '/services/data/get-todays-routines.php?list='+$sessionStorage.appUser.settings.routSchedule[$rootScope.dayIndex]
                        });
                    }
                }
            }
        })
        .state('app.settings', {
            templateUrl: 'settings.html',
            controller: function($rootScope,$scope,$sessionStorage){
                $scope.personalForm = {};
                $scope.addRoutScheduleForm = {};
                $scope.deleteStatsForm = {};
                $scope.displayName = $sessionStorage.appUser.displayName;
                $scope.emailAddress = $sessionStorage.appUser.emailAddress;
                $scope.appRoutines = $sessionStorage.appRoutines;
                $scope.routSchedule = $sessionStorage.appUser.settings.routSchedule;
            }
        })
        .state('app.stats', {
            templateUrl: 'stats.html',
            controller: function($rootScope,$scope){

            }
        })
        .state('app.today', {
            templateUrl: 'today.html',
            controller: function($rootScope,$scope,$sessionStorage,$stateParams,SweetAlert,dataServices){

                $scope.getNextRout = function(number) {
                    for(var i = 0; i < $sessionStorage.appToday.length; i++) {
                        if($sessionStorage.appToday[i].id === number.toString()) {
                            i++;
                            if(i >= $sessionStorage.appToday.length)
                                i--;
                            return $sessionStorage.appToday[i].id;
                        }
                    }
                }

                $scope.getPrevRout = function(number) {
                    for(var i = 0; i < $sessionStorage.appToday.length; i++) {
                        if($sessionStorage.appToday[i].id === number.toString()) {
                            i--;
                            if(i < 0){
                                i = 0;
                            }
                            return $sessionStorage.appToday[i].id;
                        }
                    }
                }

                $scope.saving = false;
                $scope.countRoutines = $sessionStorage.appToday.length;
                $scope.appRoutines = $sessionStorage.appRoutines;
                $scope.maxRout = $scope.countRoutines.length-1;
                if($stateParams.routineId===false){
                    $scope.activeRout = $sessionStorage.appToday[0].id-1;
                    $scope.routId = $sessionStorage.appToday[0].id
                }else{
                    $scope.activeRout = $stateParams.routineId-1;
                    $scope.routId = $stateParams.routineId;
                }

                $scope.nextRout = $scope.getNextRout($scope.routId);
                $scope.prevRout = $scope.getPrevRout($scope.routId);
                
                $scope.formData = {};

                $scope.processRout = function(rid){
                    $scope.saving = true;
                    if(!angular.isUndefined($scope.formData.negative) && $scope.formData.negative){
                        $scope.adjustedScore = '-'+$scope.formData.routScore;
                    }else{
                        $scope.adjustedScore = $scope.formData.routScore;
                    }

                    for(var i = 0; i < $sessionStorage.appToday.length; i++) {
                        if($sessionStorage.appToday[i].id === rid.toString()) {
                            $sessionStorage.appToday[i].score = $scope.adjustedScore;
                        }
                    }

                    dataServices.saveRoutine(rid,$scope.adjustedScore,$sessionStorage.appUser.id).then(function(saveResponse){
                        if(saveResponse.status=='success'){
                            SweetAlert.swal({
                               title: "Congratulations!",
                               text: "Routine successfully saved.",
                               confirmButtonColor: "#007337",
                               confirmButtonText: "YAY, ME",
                               closeOnConfirm: true
                           });
                        }else if(saveResponse.status=='error'){
                            SweetAlert.swal({
                               title: "Sorry!",
                               text: "There was an error trying to save your routine. Please try again.",
                               confirmButtonColor: "#007337",
                               confirmButtonText: "OK",
                               closeOnConfirm: true
                           });
                        }else{
                            console.log(saveResponse);
                        }
                        $scope.saving = false;
                        $scope.formData = {};
                    });
                }
            },
            params: { 
                routineId: false
            }
        })
        .state('app.leaders', {
            templateUrl: 'leaders.html',
            controller: function($rootScope,$scope,$sessionStorage){
                
            }
        })
        .state('app.routine', {
            templateUrl: 'routine.html',
            controller: function($rootScope,$scope,$state,$sessionStorage,$stateParams,SweetAlert,dataServices){
                $scope.routines = $sessionStorage.appRoutines;
                $scope.rid = $stateParams.routineId.toString();
                $scope.saving = false;
                $scope.formData = {};

                $scope.processRout = function(rid){
                    $scope.saving = true;
                    if(!angular.isUndefined($scope.formData.negative) && $scope.formData.negative){
                        $scope.adjustedScore = '-'+$scope.formData.routScore;
                    }else{
                        $scope.adjustedScore = $scope.formData.routScore;
                    }

                    for(var i = 0; i < $sessionStorage.appToday.length; i++) {
                        if($sessionStorage.appToday[i].id === rid.toString()) {
                            $sessionStorage.appToday[i].score = $scope.adjustedScore;
                        }
                    }

                    dataServices.saveRoutine(rid,$scope.adjustedScore,$sessionStorage.appUser.id).then(function(saveResponse){
                        if(saveResponse.status=='success'){
                            SweetAlert.swal({
                               title: "Congratulations!",
                               text: "Routine successfully saved.",
                               confirmButtonColor: "#007337",
                               confirmButtonText: "YAY, ME",
                               closeOnConfirm: true },
                            function(){ 
                               $state.go('app.home');
                            });
                        }else if(saveResponse.status=='error'){
                            SweetAlert.swal({
                               title: "Sorry!",
                               text: "There was an error trying to save your routine. Please try again.",
                               confirmButtonColor: "#007337",
                               confirmButtonText: "OK",
                               closeOnConfirm: true
                           });
                        }else{
                            console.log(saveResponse);
                        }
                        $scope.saving = false;
                        $scope.formData = {};
                    });
                }
            },
            params: { 
                routineId: false
            }
        })

	$urlRouterProvider.otherwise(function($injector) {
        var $state = $injector.get('$state');
        $state.go('initial');
    });
})

.run(function($rootScope,$sessionStorage,$window,fbServices){

    //$sessionStorage.fbUser = {};
    var dayIndex = new Date();
    $rootScope.dayIndex = dayIndex.getDay();
    $rootScope.fbLogged = false;
    $rootScope.appLogged = false;
    $rootScope.daysWeek = {'0':'Sunday','1':'Monday','2':'Tuesday','3':'Wednesday','4':'Thursday','5':'Friday','6':'Saturday'};

    $window.fbAsyncInit = function() {
        FB.init({ 
          appId: '793840317383072', 
          channelUrl: '//connect.facebook.net/en_US/sdk.js', 
          status: true, 
          cookie: true, 
          xfbml: true 
        });

        fbServices.watchLoginChange();
    };

    (function(d){
        var js, 
        id = 'facebook-jssdk', 
        ref = d.getElementsByTagName('script')[0];
        if (d.getElementById(id)) {
            return;
        }
        js = d.createElement('script'); 
        js.id = id; 
        js.async = true;
        js.src = "//connect.facebook.net/en_US/all.js";
        ref.parentNode.insertBefore(js, ref);
    }(document));
})

.controller('headerCtrl', function($rootScope,$scope,$state,$sessionStorage){
    if(!angular.isUndefined($sessionStorage.appUser)){
        $rootScope.appLogged = true;
        $rootScope.appUser = $sessionStorage.appUser;
    }
});