var appDirectives = angular.module('appDirectives', [])

    .directive('myRepeatDirective', function() {
      return function(scope, element, attrs) {
        if (scope.$first){
          angular.element(element).addClass('active');
        }
      };
    })

    .directive('dartoSlider', function($timeout){
        return function(scope, element, attrs){

            $('.main').on('click','button', function(){
                var submenu = this.attributes['data-sub-menu'].value;
                $('.sub .sub-list').removeClass('active');
                $('.sub .sub-list').eq(submenu).addClass('active');
                element.addClass('active-sub');
                element.css({height:$('.sub .sub-list').eq(submenu).height()+'px'});
            });

            $('.sub').on('click','.back', function(){
                element.removeClass('active-sub');
                $timeout(function(){
                    element.css({height:'auto'});
                },600);
                
            });
        }
    })

    .directive('showDuringResolve', function($rootScope) {

        return {
            link: function(scope, element) {

                element.addClass('ng-hide');

                var unregister = $rootScope.$on('$stateChangeStart', function() {
                    element.removeClass('ng-hide');
                });

                scope.$on('$destroy', unregister);
            }
        };
    })

    .directive('resolveLoader', function($rootScope, $timeout) {

        return {
            restrict: 'E',
            replace: true,
            template: '<div id="loaderOverlay" class="ng-hide block-centered"><div class="centered"><div class="loader-inner line-scale"><div></div><div></div><div></div><div></div><div></div></div><div>Loading</div></div></div>',
            link: function(scope, element) {

                $rootScope.$on('$stateChangeStart', function(event) {
                    element.removeClass('ng-hide');
                });

                $rootScope.$on('$stateChangeSuccess', function() {
                    element.addClass('ng-hide');
                });
            }
        };
    })

    .directive('numbersOnly', function(){
        return {
            require: 'ngModel',
            link: function(scope, element, attrs, modelCtrl){
                modelCtrl.$parsers.push(function(inputValue){
                    if(angular.isUndefined(inputValue)) return '';
                    var transformedInput = inputValue.replace(/[^0-9]/g,'');
                    if(transformedInput != inputValue){
                        modelCtrl.$setViewValue(transformedInput);
                        modelCtrl.$render();
                    }
                    return transformedInput;
                });
            }
        };
    })

    .directive('lettersOnly', function(){
        return {
            require: 'ngModel',
            link: function(scope, element, attrs, modelCtrl){
                modelCtrl.$parsers.push(function(inputValue){
                    if(angular.isUndefined(inputValue)) return '';
                    var transformedInput = inputValue.replace(/[^A-Za-z]/g,'');
                    if(transformedInput != inputValue){
                        modelCtrl.$setViewValue(transformedInput);
                        modelCtrl.$render();
                    }
                    return transformedInput;
                });
            }
        };
    })

    .directive('maxScore', function(){
        return {
            require: 'ngModel',
            link: function(scope, element, attrs, modelCtrl){
                modelCtrl.$parsers.push(function(inputValue){
                    if(angular.isUndefined(inputValue)) return '';
                    if(angular.isUndefined(attrs.limit)) return inputValue;
                    if(attrs.limit==0) return inputValue;
                    modelCtrl.$setViewValue(inputValue);
                    modelCtrl.$render();

                    function validator(inputValue){
                        if(parseInt(inputValue) > parseInt(attrs.limit)){
                            modelCtrl.$setValidity('score-limit', false);
                        }else{
                            modelCtrl.$setValidity('score-limit', true);
                        }
                        return inputValue;
                    }
                    
                    modelCtrl.$parsers.push(validator);

                    return inputValue;
                });
            }
        }
    });