<?php get_header(); ?>

<div id="content">
	
	<div class="container">

		<div class="row">

			<div id="main" class="col-sm-8" role="main">

				<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				
				<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?> role="article" itemscope itemtype="http://schema.org/BlogPosting">
					
					<header>
					
						<?php the_post_thumbnail( 'featured' ); ?>
						
						<div class="page-header">
							<h1 class="single-title" itemprop="headline"><?php the_title(); ?></h1>
						</div>

						<? if(!(in_category('games') || in_category('practice'))){ ?>
							<p class="meta"><?php _e("Posted", "bonestheme"); ?> <time datetime="<?php echo the_time('Y-m-j'); ?>" pubdate><?php the_date(); ?></time> <?php _e("by", "bonestheme"); ?> <?php the_author_posts_link(); ?> <span class="amp">&</span> <?php _e("filed under", "bonestheme"); ?> <?php the_category(', '); ?>.</p>
						<?php } ?>
					
					</header>
				
					<section class="post_content clearfix" itemprop="articleBody">
						<?php the_content(); ?>
						
						<?php wp_link_pages(); ?>
				
					</section>
					
					<footer>
		
						<?php the_tags('<p class="tags"><span class="tags-title">' . __("Tags","bonestheme") . ':</span> ', ' ', '</p>'); ?>
						
						<?php if( $user_level > 0 ) { ?>
							<a href="<?php echo get_edit_post_link(); ?>" class="btn btn-green btn-xs edit-post"><i class="fa fa-pencil"></i> <?php _e("Edit post","bonestheme"); ?></a>
						<?php } ?>
						
					</footer>
				
				</article>
				
				<?php comments_template('',true); ?>
				
				<?php endwhile; ?>			
				
				<?php else : ?>
				
				<article id="post-not-found">
				    <header>
				    	<h1><?php _e("Not Found", "bonestheme"); ?></h1>
				    </header>
				    <section class="post_content">
				    	<p><?php _e("Sorry, but the requested resource was not found on this site.", "bonestheme"); ?></p>
				    </section>
				    <footer>
				    </footer>
				</article>
				
				<?php endif; ?>
		
			</div>
    
			<?php if(!is_mobile()){ ?>
			<div class="col-sm-4 hidden-xs sidebar">
				<?php get_search_form(true); ?>
				<?php dynamic_sidebar('main_sidebar'); ?>
			</div>
			<?php } ?>

		</div>

	</div>

</div>		

<?php get_footer(); ?>