var doc = document.documentElement;
doc.setAttribute('data-useragent', navigator.userAgent);

$(window).resize(function(){
     responsive_resize();
     equalheight('.row.panels .panel');
});

$(window).load(function() {
  	equalheight('.row.panels .panel');
});

$(function() {

	responsive_resize();

	FastClick.attach(document.body);

	// modify tag cloud links to match up with twitter bootstrap
	$("#tag-cloud a").each(function() {
	    addTwitterBSClass(this);
	    return true;
	});
	
	$("p.tags a").each(function() {
		addTwitterBSClass(this);
		return true;
	});
	
	$("ol.commentlist a.comment-reply-link").each(function() {
		$(this).addClass('btn btn-green btn-xs');
		return true;
	});

	$("ol.commentlist a.comment-edit-link").each(function(){
		$(this).addClass('btn btn-blue btn-xs').prepend('<i class="fa fa-pencil"></i> ');
		return true;
	});
	
	$('#cancel-comment-reply-link').each(function() {
		$(this).addClass('btn btn-red btn-xs');
		return true;
	});
	
	
	// Input placeholder text fix for IE
	$('[placeholder]').focus(function() {
	  var input = $(this);
	  if (input.val() == input.attr('placeholder')) {
		input.val('');
		input.removeClass('placeholder');
	  }
	}).blur(function() {
	  var input = $(this);
	  if (input.val() == '' || input.val() == input.attr('placeholder')) {
		input.addClass('placeholder');
		input.val(input.attr('placeholder'));
	  }
	}).blur();
	
	// Prevent submission of empty form
	$('[placeholder]').parents('form').submit(function() {
	  $(this).find('[placeholder]').each(function() {
		var input = $(this);
		if (input.val() == input.attr('placeholder')) {
		  input.val('');
		}
	  })
	});
	
	$('#s').focus(function(){
		if( $(window).width() < 940 ){
			$(this).animate({ width: '200px' });
		}
	});
	
	$('#s').blur(function(){
		if( $(window).width() < 940 ){
			$(this).animate({ width: '100px' });
		}
	});
			
	$('.alert-message').alert();
	
	$('.dropdown-toggle').dropdown();
 
});


/*
--------------------------------------------------------------
FUNCTIONS
--------------------------------------------------------------
*/
function addTwitterBSClass(thisObj) {
  var title = $(thisObj).attr('title');
  if (title) {
    var titles = title.split(' ');
    if (titles[0]) {
      var num = parseInt(titles[0]);
      if (num > 0)
      	$(thisObj).addClass('label');
      if (num == 2)
        $(thisObj).addClass('label label-info');
      if (num > 2 && num < 4)
        $(thisObj).addClass('label label-success');
      if (num >= 5 && num < 10)
        $(thisObj).addClass('label label-warning');
      if (num >=10)
        $(thisObj).addClass('label label-important');
    }
  }
  else
  	$(thisObj).addClass('label');
  return true;
}

equalheight = function(container){
	var currentTallest = 0,
     	currentRowStart = 0,
     	rowDivs = new Array(),
     	$el,
     	topPosition = 0;

 	$(container).each(function() {
   		$el = $(this);
   		$($el).height('auto')
   		topPostion = $el.position().top;

   		if (currentRowStart != topPostion) {
     		for (currentDiv = 0 ; currentDiv < rowDivs.length ; currentDiv++) {
       			rowDivs[currentDiv].height(currentTallest);
     		}
     		rowDivs.length = 0; // empty the array
     		currentRowStart = topPostion;
     		currentTallest = $el.height();
     		rowDivs.push($el);
   		} else {
     		rowDivs.push($el);
     		currentTallest = (currentTallest < $el.height()) ? ($el.height()) : (currentTallest);
  		}
   		for (currentDiv = 0 ; currentDiv < rowDivs.length ; currentDiv++) {
     		rowDivs[currentDiv].height(currentTallest);
   		}
 	});
}

function responsive_resize(){
 	var current_width = $(window).width();
     
    if(current_width < 768){
      $('html').addClass("mobile").removeClass("desktop").removeClass("m320").removeClass("m768").removeClass("tablet");
 	}else if (current_width < 1023){
      $('html').addClass("tablet").removeClass("desktop").removeClass("m320").removeClass("m768").removeClass("mobile");
 	}else if (current_width > 1023){
      $('html').addClass("desktop").removeClass("m320").removeClass("m768").removeClass("tablet").removeClass("mobile");
  	}
}

function togglePushy(){html.toggleClass(pushyActiveClass),body.toggleClass(pushyActiveClass),pushy.toggleClass(pushyClass),container.toggleClass(containerClass),push.toggleClass(pushClass)}function openPushyFallback(){body.addClass(pushyActiveClass),pushy.animate({left:"0px"},menuSpeed),container.animate({left:menuWidth},menuSpeed),push.animate({left:menuWidth},menuSpeed)}function closePushyFallback(){body.removeClass(pushyActiveClass),pushy.animate({left:"-"+menuWidth},menuSpeed),container.animate({left:"0px"},menuSpeed),push.animate({left:"0px"},menuSpeed)}var pushy=$(".pushy"),body=$("body"),html=$("html"),container=$("#wrap"),push=$(".push"),siteOverlay=$(".site-overlay"),pushyClass="pushy-left pushy-open",pushyActiveClass="pushy-active",containerClass="container-push",pushClass="push-push",menuBtn=$(".panel_link, .pushy a"),menuSpeed=200,menuWidth=pushy.width()+"px";if(Modernizr.csstransforms3d)menuBtn.click(function(){$(this).hasClass("dropdown-toggle")||togglePushy()}),siteOverlay.click(function(){togglePushy()});else{pushy.css({left:"-"+menuWidth}),container.css({"overflow-x":"hidden"});var state=!0;menuBtn.click(function(){state?(openPushyFallback(),state=!1):(closePushyFallback(),state=!0)}),siteOverlay.click(function(){state?(openPushyFallback(),state=!1):(closePushyFallback(),state=!0)})}

// inFieldLabels
(function(e){e.InFieldLabels=function(t,n,r){var i=this;i.$label=e(t);i.label=t;i.$field=e(n);i.field=n;i.$label.data("InFieldLabels",i);i.showing=true;i.init=function(){var t;i.options=e.extend({},e.InFieldLabels.defaultOptions,r);if(i.options.className){i.$label.addClass(i.options.className)}setTimeout(function(){if(i.$field.val()!==""){i.$label.hide();i.showing=false}else{i.$label.show();i.showing=true}},200);i.$field.focus(function(){i.fadeOnFocus()}).blur(function(){i.checkForEmpty(true)}).bind("keydown.infieldlabel",function(e){i.hideOnChange(e)}).bind("paste",function(){i.setOpacity(0)}).change(function(){i.checkForEmpty()}).bind("onPropertyChange",function(){i.checkForEmpty()}).bind("keyup.infieldlabel",function(){i.checkForEmpty()});if(i.options.pollDuration>0){t=setInterval(function(){if(i.$field.val()!==""){i.$label.hide();i.showing=false;clearInterval(t)}},i.options.pollDuration)}};i.fadeOnFocus=function(){if(i.showing){i.setOpacity(i.options.fadeOpacity)}};i.setOpacity=function(e){i.$label.stop().animate({opacity:e},i.options.fadeDuration,function(){if(e===0){i.$label.hide()}});i.showing=e>0};i.checkForEmpty=function(e){if(i.$field.val()===""){i.prepForShow();i.setOpacity(e?1:i.options.fadeOpacity)}else{i.setOpacity(0)}};i.prepForShow=function(){if(!i.showing){i.$label.css({opacity:0}).show();i.$field.bind("keydown.infieldlabel",function(e){i.hideOnChange(e)})}};i.hideOnChange=function(e){if(e.keyCode===16||e.keyCode===9){return}if(i.showing){i.$label.hide();i.showing=false}i.$field.unbind("keydown.infieldlabel")};i.init()};e.InFieldLabels.defaultOptions={fadeOpacity:.5,fadeDuration:300,pollDuration:0,enabledInputTypes:["text","search","tel","url","email","password","number","textarea"],className:false};e.fn.inFieldLabels=function(t){var n=t&&t.enabledInputTypes||e.InFieldLabels.defaultOptions.enabledInputTypes;return this.each(function(){var r=e(this).attr("for"),i,s;if(!r){return}i=document.getElementById(r);if(!i){return}s=e.inArray(i.type,n);if(s===-1&&i.nodeName!=="TEXTAREA"){return}new e.InFieldLabels(this,i,t)})}})(jQuery);