<?php get_header(); ?>

<div id="content">

	<div class="container">

		<div class="row">
					
			<div id="main" class="col-xs-8" role="main">
			
				<div class="page-header">
				<?php if ( is_post_type_archive() ) { ?>
					<div>
				    	<h1><?php post_type_archive_title(); ?></h1>
				    </div>
				<?php } elseif (is_category()) { ?>
					<div>
						<h1 class="archive_title h2">
							<?php single_cat_title(); ?>
						</h1>
					</div>
				<?php } elseif (is_tag()) { ?> 
					<div>
						<h1 class="archive_title h2">
							<span><?php _e("Posts Tagged:", "bonestheme"); ?></span> <?php single_tag_title(); ?>
						</h1>
					</div>
				<?php } elseif (is_author()) { ?>
					<div>
						<h1 class="archive_title h2">
							<span><?php _e("Posts By:", "bonestheme"); ?></span> <?php get_the_author_meta('display_name'); ?>
						</h1>
					</div>
				<?php } elseif (is_day()) { ?>
					<div>
						<h1 class="archive_title h2">
							<span><?php _e("Daily Archives:", "bonestheme"); ?></span> <?php the_time('l, F j, Y'); ?>
						</h1>
					</div>
				<?php } elseif (is_month()) { ?>
					<div>
					    <h1 class="archive_title h2">
					    	<span><?php _e("Monthly Archives:", "bonestheme"); ?>:</span> <?php the_time('F Y'); ?>
					    </h1>
					</div>
				<?php } elseif (is_year()) { ?>
					<div>
					    <h1 class="archive_title h2">
					    	<span><?php _e("Yearly Archives:", "bonestheme"); ?>:</span> <?php the_time('Y'); ?>
					    </h1>
					</div>
				<?php } ?>
				</div>

				<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				
				<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?> role="article">
					
					<header>
						
						<h3><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>						
					</header>
				
					<section class="post_content">
					
						<?php the_post_thumbnail( 'wpbs-featured' ); ?>
					
						<?php the_excerpt(); ?>
				
					</section>
					
					<footer>
						
					</footer>

				</article>
				
				<?php endwhile; ?>	
				
				<?php if (function_exists('page_navi')) { ?>
					
					<?php echo page_navi(); ?>

				<?php } else { ?>
					<nav class="wp-prev-next">
						<ul class="clearfix">
							<li class="prev-link"><?php next_posts_link(_e('&laquo; Older Entries', "bonestheme")) ?></li>
							<li class="next-link"><?php previous_posts_link(_e('Newer Entries &raquo;', "bonestheme")) ?></li>
						</ul>
					</nav>
				<?php } ?>
				
				<?php else : ?>
				
				<article id="post-not-found">
				    <header>
				    	<h2>Coming Soon</h2>
				    </header>
				    <section class="post_content">
				    	<p><?php single_cat_title(); ?> is currently in the works and will be available soon.</p>
				    </section>
				    <footer>
				    </footer>
				</article>
				
				<?php endif; ?>
		
			</div> <!-- end #main -->

			<?php if(!is_mobile()){ ?>
			<div class="col-sm-4 hidden-xs sidebar">
				<?php get_search_form(true); ?>
				<?php dynamic_sidebar('main_sidebar'); ?>
			</div>
			<?php } ?>

		</div>

	</div>

</div>

<?php get_footer(); ?>