<?php
/*
Plugin Name: AW Custom Plugins and Widgets
Description: Custom Plugins & Widgets for use on Sites
Author: Adam Weston
Version: 1.0
Updated: 2014-08-25
*/

require_once('mobble/mobble.php');
require_once('tinymce-widget/tinymce-widget.php');
require_once('enhanced-text-widget/enhanced-text-widget.php');
require_once('widget-logic/widget_logic.php');
require_once('aw-browser-check/aw-browser-check.php');
require_once('delete-expired-transients/delete-expired-transients.php');
require_once('zero-spam/zero-spam.php');

function google_fonts(){
	add_options_page('Fonts', 'Fonts', 'manage_options', __FILE__, 'google_fonts_options');
}

if(is_admin()){
	add_action('admin_menu', 'google_fonts');
	add_action('admin_init', 'fonts_register_settings');
}

function google_fonts_options(){
	?>
	<div class="wrap">
	
		<div class="icon32" id="icon-options-general"></div>
		
		<h2>Fonts to Include from Google</h2>
			
		<form method="post" action="options.php">
		    <?php settings_fields( 'fonts-settings-group' ); ?>
		    
		    <table class="form-table">
		        <tr valign="top">
		        <th scope="row">Google fonts to include?</th>
		        <td><input name="fonts_include" type="input" id="fonts_include" value="<?php echo get_option('fonts_include'); ?>" class="widefat"/><br />Enter URL for Google Fonts to Include</td>
		        </tr>
		    </table>
		    
			<p class="submit">
				<?php submit_button(); ?>
			</p>
		</form>
		
	</div>
	<?php
}

function fonts_register_settings() {
	register_setting( 'fonts-settings-group', 'fonts_include' );
}

?>