<?php

/*
--------------------------------------------------------------
WP UTILITIES
--------------------------------------------------------------
*/

// Cleaning up the Wordpress Head
function bones_head_cleanup() {
  remove_action( 'wp_head', 'feed_links_extra', 3 );                    // Category Feeds
  remove_action( 'wp_head', 'feed_links', 2 );                          // Post and Comment Feeds
  remove_action( 'wp_head', 'rsd_link' );                               // EditURI link
  remove_action( 'wp_head', 'wlwmanifest_link' );                       // Windows Live Writer
  remove_action( 'wp_head', 'index_rel_link' );                         // index link
  remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );            // previous link
  remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );             // start link
  remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 ); // Links for Adjacent Posts
  remove_action( 'wp_head', 'wp_generator' );                           // WP version
  remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );        // WP Short link
}

// remove WP version from RSS
function bones_rss_version() { return ''; }

// This removes the annoying […] to a Read More link
function bones_excerpt_more($more) {
  global $post;
  return ' ... <a href="'. get_permalink($post->ID) . '" class="more-link" title="Read '.get_the_title($post->ID).'">Read Full</a>';
}

// Adding WP 3+ Functions & Theme Support
function bones_theme_support() {
  add_theme_support('post-thumbnails');      
  add_theme_support('automatic-feed-links');
  add_theme_support( 'menus' ); 
  register_nav_menus(
    array( 
      'main_nav' => 'The Main Menu',
      'top_nav' => 'Top Small Menu',
      'footer_nav' => 'Footer Menu' 
    )
  );  
}

function bones_main_nav() {
    wp_nav_menu( 
      array( 
        'menu' => 'main_nav',
        'menu_class' => 'main_nav',
        'theme_location' => 'main_nav',
        'container' => 'false',
        'fallback_cb' => 'bones_main_nav_fallback',
        'depth' => '2',
        'walker' => new description_walker()
      )
    );
}

function bones_top_nav() {
    wp_nav_menu( 
      array( 
        'menu' => 'top_nav',
        'menu_class' => 'top_nav list-inline',
        'theme_location' => 'top_nav',
        'container' => 'false',
        'fallback_cb' => '',
        'depth' => '1',
        'walker' => new description_walker()
      )
    );
}

function bones_footer_nav() { 
    wp_nav_menu(
      array(
        'menu' => 'footer_nav',
        'menu_class' => 'footer_nav',
        'theme_location' => 'footer_nav',
        'container' => 'false',
        'fallback_cb' => 'bones_footer_links_fallback',
        'depth' => '1',
        'walker' => new description_walker()
      )
  );
}
 
// this is the fallback for header menu
function bones_main_nav_fallback() { 
}

// this is the fallback for footer menu
function bones_footer_links_fallback($items, $args=null) {
}

// Get Page ID from Slug
function get_id_by_slug($page_slug) {
  $page = get_page_by_path($page_slug);
  if ($page) {
    return $page->ID;
  } else {
    return null;
  }
}

// Custom Copyright
function get_copyright() {
  global $wpdb;
  $copyright_dates = $wpdb->get_results("
    SELECT
    YEAR(min(post_date_gmt)) AS firstdate,
    YEAR(max(post_date_gmt)) AS lastdate
    FROM
    $wpdb->posts
    WHERE
    post_status = 'publish'
  ");
  $output = '';
  if($copyright_dates) {
    $copyright = "&copy; " . $copyright_dates[0]->firstdate;
    if($copyright_dates[0]->firstdate != $copyright_dates[0]->lastdate) {
      $copyright .= '-' . $copyright_dates[0]->lastdate;
    }
    $output = $copyright;
  }else{
    $copyright = "&copy; " . date('Y');
    $output = $copyright;
  }
  return $output;
}

// Remove script versions
function _remove_script_version( $src ){
  $parts = explode( '?', $src );
  if(strpos($parts[0],'googleapis') == false){
    return $parts[0];
  }else{
    return $src;
  }
}

// Disable jump in 'read more' link
function remove_more_jump_link($link) {
	$offset = strpos($link, '#more-');
	if ($offset) {
		$end = strpos($link, '"',$offset);
	}
	if ($end) {
		$link = substr_replace($link, '', $offset, $end-$offset);
	}
	return $link;
}

// Comment Layout
function bones_comments($comment, $args, $depth) {
  $GLOBALS['comment'] = $comment; ?>
  <li <?php comment_class(); ?>>

    <article id="comment-<?php comment_ID(); ?>">

      <div class="comment-author vcard media">

        <div class="avatar pull-left">
          <?php echo get_avatar($comment,$size='64',$default='<path_to_url>' ); ?>
        </div>

        <div class="media-body comment-text">

          <div class="media-heading">
            <?php printf(__('<h4>%s</h4>','bonestheme'), get_comment_author_link()) ?>
          </div>

          <?php if ($comment->comment_approved == '0') : ?>
            <div class="alert-message success">
              <p><?php _e('Your comment is awaiting moderation.','bonestheme') ?></p>
            </div>
          <?php endif; ?>

          <?php comment_text() ?>
                    
          <time datetime="<?php echo comment_time('Y-m-j'); ?>"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php comment_time('F jS, Y'); ?> </a></time>

          <div class="comment-controls">
            <?php edit_comment_link(__('Edit','bonestheme'),'<span class="edit-comment">','</span>') ?>
            <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
          </div>

        </div>

      </div>

    </article>
    <!-- </li> is added by wordpress automatically -->
<?php
}

// Display trackbacks/pings callback function
function list_pings($comment, $args, $depth) {
       $GLOBALS['comment'] = $comment;
?>
        <li id="comment-<?php comment_ID(); ?>"><i class="icon icon-share-alt"></i>&nbsp;<?php comment_author_link(); ?>
<?php
}

// Only display comments in comment count (which isn't currently displayed in wp-bootstrap, but i'm putting this in now so i don't forget to later)
add_filter('get_comments_number', 'comment_count', 0);
function comment_count( $count ) {
  if ( ! is_admin() ) {
    global $id;
      $comments_by_type = &separate_comments(get_comments('status=approve&post_id=' . $id));
      return count($comments_by_type['comment']);
  } else {
      return $count;
  }
}

add_filter( 'widget_tag_cloud_args', 'my_widget_tag_cloud_args' );
function my_widget_tag_cloud_args( $args ) {
  $args['number'] = 20; // show less tags
  $args['largest'] = 9.75; // make largest and smallest the same - i don't like the varying font-size look
  $args['smallest'] = 9.75;
  $args['unit'] = 'px';
  return $args;
}

// filter tag clould output so that it can be styled by CSS
add_action('wp_tag_cloud', 'add_tag_class');
function add_tag_class( $taglinks ) {
    $tags = explode('</a>', $taglinks);
    $regex = "#(.*tag-link[-])(.*)(' title.*)#e";
        foreach( $tags as $tag ) {
          $tagn[] = preg_replace($regex, "('$1$2 tag-'.get_tag($2)->slug.'$3')", $tag );
        }
    $taglinks = implode('</a>', $tagn);
    return $taglinks;
}

add_filter('wp_tag_cloud','wp_tag_cloud_filter', 10, 2);
function wp_tag_cloud_filter($return, $args) {
  return '<div id="tag-cloud">'.$return.'</div>';
}

// Menu output mods
class description_walker extends Walker_Nav_Menu {
      function start_el(&$output, $item, $depth, $args) {
        global $wp_query;
        $hideloggedout = array('Stats','Settings');

        if(!in_array($item->title,$hideloggedout) || is_user_logged_in()){
    			$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
    			
    			$class_names = $value = '';
    			
    			// If the item has children, add the dropdown class for bootstrap
    			if ( $args->has_children ) {
    				$class_names = "dropdown ";
    			}
  			
          $classes = empty( $item->classes ) ? array() : (array) $item->classes;
  			
    			$class_names .= join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
    			$class_names = ' class="'. esc_attr( $class_names ) . '"';
             
       	  $output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';

         	$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
         	$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
         	$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
         	$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
         	// if the item has children add these two attributes to the anchor tag
         	if ( $args->has_children ) {
    				$attributes .= ' class="dropdown-toggle" data-toggle="dropdown"';
    			}

          if ( ! empty( $item->attr_title ) )
            $item_output .= '<a'. $attributes .'><i class="fa ' . esc_attr( $item->attr_title ) . ' fa-lg"></i>&nbsp;';
          else
            $item_output .= '<a'. $attributes .'>';
            $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
            $item_output .= ( $args->has_children && 0 === $depth ) ? ' <span class="caret"></span></a>' : '</a>';
            $item_output .= $args->after;

          $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
        }
      }
            
      function start_lvl(&$output, $depth) {
          $indent = str_repeat("\t", $depth);
          $output .= "\n$indent<ul class=\"dropdown-menu\">\n";
      }  
         
    	function display_element( $element, &$children_elements, $max_depth, $depth=0, $args, &$output ) {
	        $id_field = $this->db_fields['id'];
	        if ( is_object( $args[0] ) ) {
	            $args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
	        }
	        return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	    }        
}

class button_navwalker extends Walker_Nav_Menu{     
  function start_el(&$output, $item, $depth, $args) {
    global $wp_query;
    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
    
    if ( strcasecmp( $item->attr_title, 'divider' ) == 0 && $depth === 0 ) {
      $output .= $indent . '<div role="presentation" class="title">'.$item->title.'</div>';
    }else{

      $class_names = $value = '';
   
      $classes = empty( $item->classes ) ? array() : (array) $item->classes;
   
      $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
      $class_names = ' class="col-sm-6 col-md-4 ' . esc_attr( $class_names ) . '"';
   
      $output .= $indent . '<div id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';
   
      $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
      $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
      $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
      $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
   
      $item_output = $args->before;
      $item_output .= '<a'. $attributes .' class="btn btn-blue loadershow">';
      $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
      if(strlen($item->description)>2){ $item_output .= '<br /><span class="sub">' . $item->description . '</span>'; }
      $item_output .= '</a>';
      $item_output .= $args->after;
   
      $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args ).'</div>';
    }
  }
}

class stats_button_navwalker extends Walker_Nav_Menu{
  function start_el(&$output, $item, $depth, $args) {
    global $wp_query;
    $current_user = wp_get_current_user();

    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
    
    $output .= '<div role="presentation" class="panel panel-info">';

    if ( in_array('divider', $item->classes) && $depth === 0 ) {
      $output .= $indent . '<div class="panel-heading"><div class="panel-title">'.$item->title.'</div></div><div class="panel-body">';
    }else{

      $class_names = $value = '';
   
      $classes = empty( $item->classes ) ? array() : (array) $item->classes;
   
      $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
      $class_names = ' class="col-sm-6 col-md-4 ' . esc_attr( $class_names ) . '"';
   
      $output .= $indent . '<div id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';
   
      $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
      $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
      $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
      $attributes .= ! empty( $item->url )        ? ' href="'   . site_url('/stats/?routineid='.$item->object_id.'&routinename='.urlencode($item->title).'&player='.$current_user->ID).'"' : '';
   
      $item_output = $args->before;
      $item_output .= '<a'. $attributes .' class="btn btn-blue loadershow">';
      $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
      if(strlen($item->description)>2){ $item_output .= '<br /><span class="sub">' . $item->description . '</span>'; }
      $item_output .= '</a>';
      $item_output .= $args->after;
   
      $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }

    $output .= '</div></div>';
  }
}

// Check if page is direct child
function is_child($page_id) { 
    global $post; 
    if( is_page() && ($post->post_parent == $page_id) ) {
       return true;
    } else { 
       return false; 
    }
}

// Numeric Page Navi (built into the theme by default)
function page_navi($before = '', $after = '') {
  global $wpdb, $wp_query;
  $request = $wp_query->request;
  $posts_per_page = intval(get_query_var('posts_per_page'));
  $paged = intval(get_query_var('paged'));
  $numposts = $wp_query->found_posts;
  $max_page = $wp_query->max_num_pages;
  if ( $numposts <= $posts_per_page ) { return; }
  if(empty($paged) || $paged == 0) {
    $paged = 1;
  }
  $pages_to_show = 7;
  $pages_to_show_minus_1 = $pages_to_show-1;
  $half_page_start = floor($pages_to_show_minus_1/2);
  $half_page_end = ceil($pages_to_show_minus_1/2);
  $start_page = $paged - $half_page_start;
  if($start_page <= 0) {
    $start_page = 1;
  }
  $end_page = $paged + $half_page_end;
  if(($end_page - $start_page) != $pages_to_show_minus_1) {
    $end_page = $start_page + $pages_to_show_minus_1;
  }
  if($end_page > $max_page) {
    $start_page = $max_page - $pages_to_show_minus_1;
    $end_page = $max_page;
  }
  if($start_page <= 0) {
    $start_page = 1;
  }
    
  $html .= $before.'<div><ul class="clearfix pagination">'."";
  if ($paged > 1) {
    $first_page_text = "<i class='fa fa-angle-double-left'></i>";
    $html .= '<li class="prev"><a href="'.get_pagenum_link().'" title="First">'.$first_page_text.'</a></li>';
  }
    
  $prevposts = get_previous_posts_link('<i class="fa fa-arrow-left"></i> Previous');
  if($prevposts) { $html .= '<li>' . $prevposts  . '</li>'; }
  else { $html .= '<li class="disabled"><a href="#"><i class="fa fa-arrow-left"></i> Previous</a></li>'; }
  
  for($i = $start_page; $i  <= $end_page; $i++) {
    if($i == $paged) {
      $html .= '<li class="active"><a href="#">'.$i.'</a></li>';
    } else {
      $html .= '<li><a href="'.get_pagenum_link($i).'">'.$i.'</a></li>';
    }
  }
  $html .= '<li class="">';
  $html .= get_next_posts_link('Next <i class="fa fa-arrow-right"></i>');
  $html .= '</li>';
  if ($paged < $max_page) {
    $last_page_text = "<i class='fa fa-angle-double-right'></i>";
    $html .= '<li class="next"><a href="'.get_pagenum_link($max_page).'" title="Last">'.$last_page_text.'</a></li>';
  }
  $html .= '</ul></div>'.$after."";

  return $html;
}

// remove the p from around imgs
function filter_ptags_on_images($content){
   return preg_replace('/<p>\s*(<a .*>)?\s*(<img .* \/>)\s*(<\/a>)?\s*<\/p>/iU', '\1\2\3', $content);
}

function short_excerpt($string, $word_limit) {
  $words = explode(' ', $string, ($word_limit + 1));
  if(count($words) > $word_limit)
  array_pop($words);
  $newexcerpt = implode(' ', $words);
  if($newexcerpt == ''){
    return $newexcerpt;
  }else{
    return $newexcerpt.' ...';
  }
}


/*
--------------------------------------------------------------
ACTIONS
--------------------------------------------------------------
*/
add_action('init', 'bones_head_cleanup');
add_action('after_setup_theme','bones_theme_support');  


/*
--------------------------------------------------------------
FILTERS
--------------------------------------------------------------
*/
if(!is_admin()){
  add_filter( 'script_loader_src', '_remove_script_version', 15, 1 );
  add_filter( 'style_loader_src', '_remove_script_version', 15, 1 );
}
add_filter('the_generator', 'bones_rss_version');
add_filter('excerpt_more', 'bones_excerpt_more');
add_filter('the_content_more_link', 'remove_more_jump_link');
add_filter('wp_get_attachment_link','add_class_attachment_link',10,1);
add_filter('the_content', 'filter_ptags_on_images');
add_filter('wpcf_fields_value_display', '__');

?>