<?php
function get( $atts ) {
	extract( shortcode_atts( array(
		'var' => ''
	), $atts ) );
	$getvar = $_GET[$var];
	return $getvar;
}

function getName($atts) {
	$current_user = wp_get_current_user();
	if ( 0 == $current_user->ID ) {
	    return '';
	} else {
	    return $current_user->display_name;
	}
}

function latestPanel( $atts, $content=null ) {
	extract( shortcode_atts( array(
		'category' => '',
		'colclass' => '',
		'tag' => '',
		'type' => 'post',
		'number' => '1',
		'orderby' => 'date',
		'order' => 'DESC',
		'thumbsize' => 'featured-short',
		'panelclass' => 'grey'
	), $atts ) );

	$attrs = array(
		'post_type' => $type,
		'category_name' => $category,
		'tag' => $tag,
		'posts_per_page' => $number, 
		'orderby' => $orderby, 
		'order' => $order 
	);

	$items = new WP_Query($attrs);
	$i = 1;
	$c = $number;

	if ($items->have_posts()) : 
		$html .= '<div class="row panels">';

		while ($items->have_posts()) : $items->the_post();
		$html .= '<div class="'.$colclass.'">';

		$html .= '<a class="latest" href="'.get_permalink().'">';
		$html .= '<div class="panel panel-'.$panelclass.'">';
		$html .= '<div class="panel-heading">';
		$html .= '<div class="panel-title">';
		$html .= '<a href="'.get_permalink().'">'.get_the_title().'</a>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '<div class="panel-body">';
		$html .= short_excerpt(get_the_excerpt(),40);
		$html .= '</div>';
		$html .= '</div>';
		$html .= '</div></a>';

		if($i==$columns && $c!=count($items)){
			$i = 0;
			$html .= '</div><div class="row panels">';
		}
		$i++;

		endwhile;
		wp_reset_postdata();
		$html .= '</div>';
	endif;
	
	return $html;
}

function latestList( $atts, $content=null ) {
	extract( shortcode_atts( array(
		'category' => '',
		'tag' => '',
		'type' => 'post',
		'number' => '1',
		'orderby' => 'date',
		'order' => 'DESC',
		'class' => ''
	), $atts ) );

	$attrs = array(
		'post_type' => $type,
		'category_name' => $category,
		'tag' => $tag,
		'posts_per_page' => $number, 
		'orderby' => $orderby, 
		'order' => $order 
	);

	$items = new WP_Query($attrs);

	if ($items->have_posts()) : 
	
		while ($items->have_posts()) : $items->the_post();
		if(has_post_thumbnail()){
			$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'list-image');
		}else{
			$post_thumbnail_id = get_imageID_by_url(get_theme_mod( 'alt_logo' ));
	        $thumb = wp_get_attachment_image_src( $post_thumbnail_id, 'list-image');
		}
		$html .= '<div class="media '.$class.'">';
		$html .= '<a class="pull-left media-link" href="'.get_permalink().'">';
		$html .= '<img class="media-object" src="'.$thumb[0].'" alt="latest post image">';
		$html .= '</a>';
		$html .= '<div class="media-body">';
		$html .= '<h3 class="media-heading">';
		$html .= '<a href="'.get_permalink().'">'.get_the_title().'</a>';
		$html .= '</h3>';
		$html .= get_the_excerpt();
		$html .= '</div>';
		$html .= '</div>';
		endwhile;
		wp_reset_postdata();
		
	endif;
	
	return $html;
}

function getCategory( $atts, $content=null ) {
	extract( shortcode_atts( array(
		'category' => '',
		'posts' => '10',
		'orderby' => 'post_title',
		'order' => 'ASC',
		'class' => ''
	), $atts ) );

    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $attrs = array(
        'category_name' => $category,
        'posts_per_page' => 10, 
        'orderby' => 'post_title', 
        'order' => 'ASC',
        'paged' => $paged
    );

    query_posts($attrs);

    if (have_posts()) : 

    	$html = '<div id="'.$category.'List">';

        while (have_posts()) : the_post();
            if(has_post_thumbnail()){
              $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'list-image');
            }else{
              $post_thumbnail_id = get_imageID_by_url(get_theme_mod( 'alt_logo' ));
                  $thumb = wp_get_attachment_image_src( $post_thumbnail_id, 'list-image');
            }
            
            $html .= '<div class="media '.$class.'">';
            $html .= '<a class="pull-left media-link" href="'.get_permalink().'">';
            $html .= '<img class="media-object" src="'.$thumb[0].'" alt="latest post image">';
            $html .= '</a>';
            $html .= '<div class="media-body">';
            $html .= '<h3 class="media-heading">';
            $html .= '<a href="'.get_permalink().'">'.get_the_title().'</a>';
            $html .= '</h3>';
           	$html .= get_the_excerpt();
            $html .= '</div>';
            $html .= '</div>';
        
        endwhile;

        if (function_exists('page_navi')) { 
            $html .= page_navi();
        } else { 
            $html .='<nav class="wp-prev-next">';
            $html .='<ul class="clearfix">';
            $html .='<li class="prev-link">'.next_posts_link(_e('&laquo; Older Entries', "bonestheme")).'</li>';
            $html .='<li class="next-link">'.previous_posts_link(_e('Newer Entries &raquo;', "bonestheme")).'</li>';
            $html .='</ul>';
            $html .='</nav>';
        }
        wp_reset_query();

        $html .= '</div>';

    endif;

    return $html;

}

add_shortcode( 'get', 'get' );
add_shortcode( 'getName', 'getName' );
add_shortcode( 'latestPanel', 'latestPanel' );
add_shortcode( 'latestList', 'latestList' );
add_shortcode( 'getCategory', 'getCategory' );
?>