<?php

/*
--------------------------------------------------------------
THUMBNAIL SIZES
--------------------------------------------------------------
*/

add_image_size( 'featured', 660, 320, true );
add_image_size( 'featured-full', 980, 320, true);
add_image_size( 'list-image', 64, 64, false);


/*
--------------------------------------------------------------
IMAGE MODS
--------------------------------------------------------------
*/

// Remove height/width attributes on images so they can be responsive
function remove_thumbnail_dimensions( $html ) {
    $html = preg_replace( '/(width|height)=\"\d*\"\s/', "", $html );
    return $html;
}

function get_imageID_by_url($url) {
  global $wpdb;
     $query = "SELECT ID FROM {$wpdb->posts} WHERE guid='$url'";
     $id = $wpdb->get_var($query);
     return $id;
}

function my_post_thumbnail_html( $html, $post_id, $post_thumbnail_id, $size, $attr ) {

  if(!is_single()){
    if ( '' == $html ) { // or ! $post_thumbnail_id
        $post_thumbnail_id = get_imageID_by_url(get_theme_mod( 'dbanner' ));
        do_action( 'begin_fetch_post_thumbnail_html', $post_id, $post_thumbnail_id, $size );
        if ( in_the_loop() )
            update_post_thumbnail_cache();
        $html = wp_get_attachment_image( $post_thumbnail_id, $size, false, $attr );
        do_action( 'end_fetch_post_thumbnail_html', $post_id, $post_thumbnail_id, $size );
    }
  }

    return $html;
}

// Add thumbnail class to thumbnail links
function add_class_attachment_link($html){
    $postid = get_the_ID();
    $html = str_replace('<a','<a class="thumbnail"',$html);
    return $html;
}


/*
--------------------------------------------------------------
MULTIPLE THUMBNAIL SUPPORT
--------------------------------------------------------------
*/

if(class_exists('MultiPostThumbnails')){
  $mobile_thumb = new MultiPostThumbnails(array(
    'label'     => 'Mobile Image',
    'id'        => 'mobile-image',
    'post_type' => 'page'
  ));
}


/*
--------------------------------------------------------------
FILTERS
--------------------------------------------------------------
*/
//add_filter( 'post_thumbnail_html', 'remove_thumbnail_dimensions', 10 );
//add_filter( 'image_send_to_editor', 'remove_thumbnail_dimensions', 10 );
add_filter( 'post_thumbnail_html', 'my_post_thumbnail_html', 1, 5 );
add_filter('wp_get_attachment_link','add_class_attachment_link',10,1);
?>