<!doctype html>  

<!--[if IEMobile 7 ]> <html class="no-js iem7"> <![endif]-->
<!--[if lt IE 8 ]>    <html class="no-js lt-ie8"> <![endif]-->
<!--[if lt IE 9 ]>    <html class="no-js lt-ie9"> <![endif]-->
<!--[if lt IE 10 ]>   <html class="no-js lt-ie10"> <![endif]-->
<!--[if (gte IE 9)|(gt IEMobile 7)|!(IEMobile)|!(IE)]><!--><html class="no-js"><!--<![endif]-->
	
	<head>

		<meta charset="utf-8"/>
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no"/>

		<title>Darts Analyzier - 1.0</title>

	<!-- MOBILE ICONS START -->
		<link rel="shortcut icon" href="icons/favicon.ico">
		<link rel="apple-touch-icon" sizes="57x57" href="icons/apple-touch-icon-57x57.png">
		<link rel="apple-touch-icon" sizes="114x114" href="icons/apple-touch-icon-114x114.png">
		<link rel="apple-touch-icon" sizes="72x72" href="icons/apple-touch-icon-72x72.png">
		<link rel="apple-touch-icon" sizes="144x144" href="icons/apple-touch-icon-144x144.png">
		<link rel="apple-touch-icon" sizes="60x60" href="icons/apple-touch-icon-60x60.png">
		<link rel="apple-touch-icon" sizes="120x120" href="icons/apple-touch-icon-120x120.png">
		<link rel="apple-touch-icon" sizes="76x76" href="icons/apple-touch-icon-76x76.png">
		<link rel="apple-touch-icon" sizes="152x152" href="icons/apple-touch-icon-152x152.png">
		<link rel="icon" type="image/png" href="icons/favicon-196x196.png" sizes="196x196">
		<link rel="icon" type="image/png" href="icons/favicon-160x160.png" sizes="160x160">
		<link rel="icon" type="image/png" href="icons/favicon-96x96.png" sizes="96x96">
		<link rel="icon" type="image/png" href="icons/favicon-16x16.png" sizes="16x16">
		<link rel="icon" type="image/png" href="icons/favicon-32x32.png" sizes="32x32">
		<meta name="msapplication-TileColor" content="#000000">
		<meta name="msapplication-TileImage" content="icons/mstile-144x144.png">
		<meta name="msapplication-config" content="icons/browserconfig.xml">
	<!-- MOBILE ICONS END -->

	<!-- STYLESHEETS START -->
		<link rel="stylesheet" href="css/bootstrap.min.css">
		<link rel="stylesheet" href="css/bootstrap-theme.min.css">
		<link rel="stylesheet" href="css/font-awesome.min.css">
		<link rel="stylesheet" href="css/toggle-switch.css">
		<link rel="stylesheet" href="css/da-style.css">
	<!-- STYLESHEETS END -->
	</head>

	<body id="daApp">

	<!-- CONTENT START -->
		<section id="content">
			<div class="container">
				<div class="row">
					<div class="col-sm-3">

						<div class="panel panel-default">
							  <div class="panel-heading">
									<h3 class="panel-title">Contols</h3>
							  </div>
							  <div class="panel-body">
									<form id="contolsForm" method="post">
										<label for="scores">Scores Input</label>
										<textarea id="scores" name="scores" class="form-control">12,16,19,3,17,1,25,19,17,50,18,1,3,17,2,2,13,18,16,2,25,5,5,1,5,4,17,25,25,50,3,7,17,17,3,3,3,7,11,10,25,1,19,15,4,1,5,12,17,16,50,20,20,20,25,50,2,17,3,20,20,20,5,1,18,15,2,3,25,12,9,3,3,19,16,20,5,5,1,4,15,16,5,20,16,2,25,6,12,25,11,25,7,2,5,19,17,17,2,12,12,9,14,25,25,20,1,20,50,2</textarea>
										<button id="heatmapBtn" type="button" class="btn btn-primary btn-block">Create Heat Map</button>
									</form>
							  </div>
						</div>

						<div class="panel panel-default collapsible">
							<div class="panel-heading collapser clearfix" data-toggle="collapse" data-target="#instCollapse">
								<h3 class="panel-title pull-left">Instructions</h3>
								<div class="collapse-icon pull-right"><i class="fa fa-minus"></i></div>
							</div>
							<div id="instCollapse" class="collapse in">
								<div class="panel-body">
									<ol>
										<li>
											Throw 50 or so darts, aiming at the double bull.
										</li>
										<li>
											Enter the scores of each dart above separated by commas.
										</li>
										<li>
											Click the "Create Heat Map" button to see a personalized heat map of your highest scoring areas.
										</li>
									</ol>
								</div>
							</div>
						</div>

						<div class="panel panel-default collapsible">
							<div class="panel-heading collapser clearfix" data-toggle="collapse" data-target="#helpCollapse">
								<h3 class="panel-title pull-left">Help</h3>
								<div class="collapse-icon pull-right"><i class="fa fa-plus"></i></div>
							</div>
							<div id="helpCollapse" class="collapse">
								<div class="panel-body">
									<p>
										First look at the color legend to see which colors correspond to high expected scores. Then look at the heat map to see which aiming locations are assigned these colors. (Note: the &sigma; parameters are measured in mm; for reference, the dartboard's radius is 170 mm.)
									</p>
								</div>
							</div>
						</div>

					</div>
					<div class="col-sm-9">

						<div class="panel panel-default">
							  <div class="panel-heading">
									<h3 class="panel-title">Optimal Scoring Area(s)</h3>
							  </div>
							  <div class="panel-body">
									<div class="row">
										<div class="col-sm-8">
											<div id="heatmapBox">
												<canvas id="heatmap" class="heatmap" width="340" height="340"></canvas>
										        <canvas id="overlay" class="overlay"></canvas>
										        <div id="optimumDot"></div>
										    </div>
										</div>
										<div class="col-sm-4">
											<div class="well well-sm">
												<h4>Options</h4>
												<label for="showDartboard"><input type="checkbox" id="showDartboard" checked/> Show Dartboard</label>
												<label for="showOptimumPlace"><input type="checkbox" id="showOptimumPlace" checked/> Show optimum place to aim</label>
											</div>
											<div class="well well-sm clearfix">
												<div class="welltoolbar clearfix">
													<h4 class="pull-left">Legend</h4>
													<a id="changeColor" onclick="javascript:void(0);" class="pull-right">Change Color</a>
												</div>
												<canvas id="legend"></canvas>
												<div id="legendLabel clearfix">
													<div class="pull-left">Low</div>
													<div class="pull-right">High</div>
												</div>
											</div>
											<div class="well well-sm clearfix">
												<h4>Stats</h4>
												<div id="statsNotes">Based on <span>0</span> scores.</div>
												<hr>
												<div id="maxExpectedScore">Max Expected Score: <span class="pull-right">0.00</span></div>
												<div id="aimFor">Aim For: <span class="pull-right">NA</span></div>
												<div id="sigma">&sigma; = <span class="pull-right">0.00</span></div>
											</div>
										</div>
									</div>
							  </div>
						</div>

						<footer>
							<div class="row">
								<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
									<p>Based on the work from <a href="www.stat.cmu.edu/~ryantibs/darts/index.html" target="_blank">A Statistician Plays Darts</a> by <a href="http://www.stat.cmu.edu/~ryantibs/">Ryan Tibshirani</a>, <a href="http://www.linkedin.com/in/adprice">Andy Price</a> and <a href="http://www-stat.stanford.edu/~jtaylo/">Jon Taylor</a>.</p>
									<p>&copy; <?php echo date('Y'); ?> Adam Weston</p>
								</div>
							</div>
						</footer>

					</div>
				</div>
			</div>
		</section>

		<div id="msgModal" class="modal fade">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<h4 class="modal-title"></h4>
					</div>
					<div class="modal-body">
						
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</div><!-- /.modal-content -->
			</div><!-- /.modal-dialog -->
		</div><!-- /.modal -->

		<div id="loader">
			<div class="loaderBox">
				<span class="text">Generating Heat Map</span><br />
				<i class="fa fa-spinner fa-spin fa-3x"></i>
			</div>
		</div>

	<!-- CONTENT END -->

	<!-- JAVASCRIPT FILES START -->
		<script type="text/javascript" src="js/jquery.min.js"></script>
		<script type="text/javascript" src="js/modernizr.min.js"></script>
		<script type="text/javascript" src="js/bootstrap.min.js"></script>
		<script type="text/javascript" src="js/heatcanvas.js"></script>
		<script type="text/javascript" src="js/fastclick.js"></script>
		<script type="text/javascript" src="js/da-script.js"></script>
	<!-- JAVASCRIPT FILES END -->

	</body>

</html>