$(document).ready(function() {
    // Handle the close action of the help container
    $('#help .close-help').click(function() {
        CloseHelpContainer();
    });

    // Hook up the support link
    $('#help .support-link, #header-content .header-help').click(function() {
        Zenbox.render();
    });
    
    // Handle the click event for the help link
    $('body').delegate('a[rel="help"]', 'click', showHelpPanel);
    
    $('body').delegate('.organization-type-link','click',function(){
	var currentVal = $('input[name="GroupName"]').val();
        $('input[name="GroupName"]').val(currentVal + " " + $(this).html());
    })
    
    $('body').delegate('.tree-group-all-members','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-affiliate-mail-all-group-members';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-individual-members','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-affiliate-mail-individual-members';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-announcement','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-affiliate-announcement';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-event','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-affiliate-event';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-documents-request','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-affiliate-documents';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-change-group-owner','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-change-group-owner-role';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-connect-existing-group','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-request-connect';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-disconnect-existing-group','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-request-disconnect';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-disconnect-existing-group-and-children','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-request-disconnect-group-and-children';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-create','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-group-create';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-join','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-group-join';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-quit','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-group-quit';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-request-invitation','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-group-request-invitation';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.tree-group-resign','click',function(e){
	e.preventDefault();
	var data = {'id' : $('#groupID').val()}; // parse url for id
	var url = '/help/get-resign-group-owner-role';
	loadExtendedHelpPanel(url,data);
    });
    
    $('body').delegate('.category-info-toggle','click',function(){
	var categoryID = $(this).parents('.tree-panel-categories-items-check, .tree-panel-categories-items-list').find('.tree-panel-categories-items-checkbox').val();
	var data = {'categoryID' : categoryID};
	var url = '/help/get-category-data';
	loadExtendedHelpPanel(url,data);
    });
    
    // Handle the click event of a link that needs a popup in the help content
    $('#help .wrapper .scroll-area .wrapper').delegate('a.popup', 'click', function() {
        $.colorbox({
            href: $(this).attr('href')
        });
        
        return false;
    });

    // Close the help box when X is clicked
    $('#help-box .content .close').click(function() {
        $('#help-box .content, #help-box .arrow').fadeOut();

        GTApp.quickHelp.close();

//        // Set the cookie for this particular close action
//        var days = 10000;
//        var name = $('#help-box-target').val();
//        var date = new Date();
//        var value = 'closed';
//
//        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
//        var expires = "; expires=" + date.toGMTString();
//
//        document.cookie = name + "=" + value + expires + "; path=/";
    });

    // Handle the click event of the close button in the error container in
    // the help panel
    $('#help .error-container .close-btn a').click(function() {
        $('#help .error-container').fadeOut(function() {
            // Set the height of the scrollable area
            $('#help .wrapper .scroll-area')
                .attr('style', 'height: ' + ($(window).height() - 60) + 'px')
                .jScrollPane();
        });
    });
    
    var uname = $('div.left-panel-content div.personal-info div.name span').html();
    var uemail = $('div.left-panel-content div.personal-info div.email-top').html();

    // Initialize the zendbox action in the site
    if (typeof(Zenbox) !== "undefined") {
        Zenbox.init({
            dropboxID:   "20048368",
            url:         "https://grouptrack.zendesk.com",
            tabID:       "support",
            tabColor:    "black",
            tabPosition: "Left",
            hide_tab:    "true",
            requester_name: uname,
            requester_email: uemail
        });
    }
    

    $('#btn-bar-notification-panel .btns .close-btn').click(function(){
        // Now that we have content move help content on screen
        $('#btn-bar-notification-panel').animate({
            right: '-475'
        },200, function() {
            $('#btn-bar-notification-panel .btns .hide-btn').show()
            $('#btn-bar-notification-panel .btns .show-btn').hide();
        });
    });
    
    $('#btn-bar-notification-panel .btns .hide-btn').click(function(){
        $('#btn-bar-notification-panel .btns .hide-btn, #btn-bar-notification-panel .btns .show-btn').toggle();
        
        // Now that we have content move help content on screen
        $('#btn-bar-notification-panel').animate({
            right: '-400'
        },200, function() {});
    });
    
    $('#btn-bar-notification-panel .btns .show-btn').click(function(){
        $('#btn-bar-notification-panel .btns .hide-btn, #btn-bar-notification-panel .btns .show-btn').toggle();
        
        // Now that we have content move help content on screen
        $('#btn-bar-notification-panel').animate({
            right: '0'
        },200, function() {});
    });
    
    // Assign a tooltip to any element with the class tooltip
    if($('.social-icon-tooltip').length){
	$('.social-icon-tooltip').qtip({
	    position: {
		 my: 'bottom right',
		 at: 'top left'
	       }
	});
    }
    
});

function CloseHelpContainer() {
    $('a[rel]').removeClass('active');

    // Empty any error messages
    $('#help .error-container ol').empty();
    $('#help .error-container').hide();

    // Handle the main help link
    $('a[rel].main').html('Help');

    //Assigns tool tip any element with the tooltip class
    $('.tooltip').qtip({
        position: {
            my: 'bottom center',
            at: 'top center'
        }
    });

    // Move the help container off the screen
    var animateAmt = -$('#help').width();
    if($('#help').hasClass('extended')){
        animateAmt = '-640px';
        $('#help').css('width','340px');
        $('#help').removeClass('extended');
    }

    $('#help').animate({
        right: animateAmt
    }, 
    300,
    function(){
        $('#help .wrapper .scroll-area .wrapper').empty();
        $('#help a.close-help').hide();
    });
}

var dragAndDropOpts = {
    onDragStart: function(node) {
        /** This function MUST be defined to enable dragging for the tree.
         *  Return false to cancel dragging of node.
         */
        return true;
      },
      autoExpandMS: 1000,
      preventVoidMoves: true, // Prevents dropping nodes 'before self', etc.
      onDragEnter: function(node, sourceNode) {
        return true;
      },
      onDragOver: function(node, sourceNode, hitMode) {
        if(node.isDescendantOf(sourceNode)){
          return false;
        }
        
        if(hitMode !== "over"){
            return false;
        }
        // Prohibit creating childs in non-folders (only sorting allowed)
        if( !node.data.isFolder && hitMode === "over" ){
          return "after";
        }
      },
      onDrop: function(node, sourceNode, hitMode, ui, draggable) {
       // sourceNode = drop node
       // node = dragged node
        sourceNode.move(node, hitMode);
        sourceNode.expand(true);
        if(hitMode === 'over'){
            groupNodeUpdate(node.data.key,sourceNode.data.key);
        }
      }
}


function loadTreeView(dragAndDrop)
{
    var groupID = $('#groupId').val();
    var dndOpts = dragAndDrop ? dragAndDropOpts : {};
    $("#tree").dynatree({
        clickFolderMode: 1,
        imagePath: '/css/jquery/dynatree/',
        initAjax: {
            url: "/related-groups/load-tree-view",
            data: {"groupID" : groupID}
        },
        onPostInit : function(isReloading, isError){
            if(isError){
                $('#tree').hide();
            }
            $('.dynatree-node').each(function(){
               if($(this).hasClass('topTier')){
                    $(this).siblings('ul').addClass('topTierChild');
                }else if($(this).hasClass('secondTier')){
                    $(this).siblings('ul').addClass('secondTierChild');
                }
            });
        },
        onRender: function(node, nodeSpan){
            var nodeElement = $(nodeSpan).find('a');
            var clicks = 0;
            var timer = null;
            nodeElement.click(function(e){
                clicks++;
                if(clicks === 1){
                    timer = setTimeout(function(){
                        clicks = 0;
			showHelpPanel(e);
                    },350);
                }else{
                    clearTimeout(timer);
                    clicks = 0;
                    if(node.data.goToGroupDblClick){
                        $(nodeSpan).find('a').dblclick(function(){
                            window.location.href = '/my-groups/' + node.data.key + '/nav/memberOptions';
                        });
                    }
                }
            }).dblclick(function(e){
                e.preventDefault();
            });

            if(node.data.categoryCount > 0){
                var categoryString = node.data.categoryCount === 1 ? node.data.categoriesNameSingular : node.data.categoriesNamePlural;
                $(nodeSpan).find('a').qtip({
                    position: {
                        my: 'left center',
                        at: 'right center'
                    },
                    content : {
                        text : 'This group has ' + node.data.categoryCount + ' ' + categoryString
                    }
                });
            }
        },
        dnd : dndOpts
    });
}

function loadSimpleTreeView(groupID){
    $("#tree").dynatree({
        imagePath: '/css/jquery/dynatree/',
        initAjax: {
            url: "/related-groups/load-tree-view",
            data: {"groupID" : groupID,"partialTree" : 1}
        }
    });
}

function treeCategoryToggle(obj){
    var data = $(obj).parents('.tree-panel-categories').serialize();
    $.ajax({
        url : '/categories/categories-follow-update',
        data : data,
        type : 'post',
        dataType : 'json'
    });
}

function groupNodeUpdate(dropNodeGroupID,draggedNodeGroupID){
    $.ajax({
        url : '/related-groups/tree-update',
        data : {"draggedNodeGroupID" : draggedNodeGroupID,"dropNodeGroupID" : dropNodeGroupID},
        type : 'post',
        dataType : 'json',
        success : function(data){
            if(data.status === GTApp.status.failure){
                GTApp.notify.registerText(data.messages[0]);
            }
        }
    });
}

function closeHelpPanel() {
    $('#help .close-help').click();
    return false;
}



function showHelpPanel(e,href,width){
    
    if(!width){
        width = 340;
    }
    
    $('#help .wrapper .scroll-area .wrapper').html('<img src="/img/ajax-loader.gif" alt="Loading..." />');
    if(!href){
        var href = $(e.target).attr('href');
    }
    // If the help is open, close and return
    if ($(this).hasClass('active')) {
        $('#help .close-help').click();
        return false;
    }

    // Handle the main help link
    if ($(this).hasClass('main')) {
        $(this).html('Close');
    }
    
    // Hide extended info if present
    /*
    if($('#help').hasClass('extended')){
	$('#help').animate({
	    width: '340'
	},300).removeClass('extended');
	$('.ext-panel-frame').html("");
    }
    */
    // Set the active flag
    $('a[rel]').not($(this)).removeClass('active');
    $(this).addClass('active');

    // Load the help content into the help container
    $('#help .wrapper .scroll-area .wrapper').load(
        href,
        function() {
            var availableSpace = $(window).height() - 60;

            if ($('#help .error-container').is(':visible')) {
                $('#help .error-container .close-btn').show();
                availableSpace = $(window).height() - 130 - $('#help .error-container').height();
            }

            // Set the height of the scrollable area
            $('#help .wrapper .scroll-area').attr('style', 'height: ' + availableSpace + 'px');
            // Add custom scrollbar if necessary
            $('#help .wrapper .scroll-area').jScrollPane();
           // var scrollAreaWidth = (width - 70) + 'px';
           // $('.scroll-area.jspScrollable, .jspContainer, .jspPane').css({'width' : scrollAreaWidth, 'overflow' : 'hidden'});
            //$('.jspHorizontalBar').remove();
            
            // Now that we have content move help content on screen
            $('#help').css({'width' : width, 'right' : -width});
            $('#help').animate({
            right: 0
            },300, function() {
                // Show the close icon
                $('#help a.close-help').fadeIn();
            });

            $('.social-icon-tooltip').qtip({
            position: {
                 my: 'bottom right',
                 at: 'top left'
               }
            });

            $('.needs-tooltip').qtip({
            position: {
                my: 'bottom right',
                at: 'top left'
            }
            });
        }
    );

    return false;
}

function loadExtendedHelpPanel(url,data){
    $('#help').animate({
	width : 995
    },300).addClass('extended');
    
    $('.ext-panel-frame').remove();
    var loader = '<img id="extended-panel-loader" src="/img/ajax-loader.gif" alt="Loading..." />';
    $('#help .scroll-area').after(loader);
    $.ajax({
	url : url,
	type : 'get',
	data : data,
	dataType : 'html',
	success : function(response){
	    $('#extended-panel-loader').remove();
	    $('#help .scroll-area').after(response);
	    var availableSpace = $(window).height() - 60;
	    if ($('#help .error-container').is(':visible')) {
		$('#help .error-container .close-btn').show();
		availableSpace = $(window).height() - 130 - $('#help .error-container').height();
	    }
	    // Set the height of the scrollable area
	    $('.help-extended-panel').attr('style', 'height: ' + availableSpace + 'px');
	    $('.help-extended-panel').jScrollPane();
	}
    });
}

function hideExtendedHelp()
{
    $('#help').animate({
	width : 340
    },300).removeClass('extended');
    $('.ext-panel-frame').remove();
}