<?php
require_once(dirname(__FILE__).'/utilities/Mobile_Detect.php');
$device = new Mobile_Detect;
/*
--------------------------------------------------------------
PAGE VARIABLES
--------------------------------------------------------------
*/
if(isset($_GET['con'])){
    $con = $_GET['con'];
}else{
    $con = '';
}

$data = array(
    'loginLink' => 'https://www.yaveo.com/es/login',
    'pageName' => 'AcqMovies_Es',
    'masthead' => array(
        'image' => 'img/masthead-movies.jpg',
        'mobileImage' => 'img/masthead-mobile-movies.jpg',
        'headline' => 'Aquí viven tus películas en español',
        'secondary' => 'Acción, terror, humor, clásicas y más; y por supuesto novelas, fútbol en vivo y series por solo $7.99 al mes.',
        'cta' => '¡Primeras 2 semanas gratis!'
    ),
    'module1' => array(
        'image' => 'img/content-wall.jpg',
        'headline' => 'Entretenimiento en grande para que lo disfrute toda la familia.',
        'copy' => 'Con Yaveo<sup>TM</sup> disfruta EN VIVO de mucho de lo mejor de las ligas de fútbol europeas con beIN SPORTS en español y miles de horas de programación ON DEMAND de Latinoamérica, España y los EE.UU. Solo $7.99 al mes. Todo lo que necesitas es Internet. Puedes cancelar al cualquier momento. ¡En Yaveo vive lo tuyo!',
        'cta' => '¡Conéctate ya!'
    ),
    'module2' => array(
        'image' => 'img/mediaModule_MOVIES_500x300.jpg',
        'headline' => 'Si lo tuyo son las películas en español, vívelas en Yaveo.',
        'copy' => 'En Yaveo, ve tus películas favoritas de Latinoamérica, España y EE. UU. donde estés.',
        'cta' => ''
    ),
    'module3' => array(
        'image' => 'img/devices-horizontal-es.png',
        'mobileImage' => 'img/devices-stacked.png',
        'headline' => '¡No te pierdas tus programas favoritos! Llévalos contigo.',
        'copy' => 'Tú puedes disfrutar Yaveo donde y cuando quieras usando tu computadora, tableta, smartphone, Xbox 360<sup>&reg;</sup> o Roku<sup>&reg;</sup>. Todo lo que tienes que hacer es conectarte al Internet. Con  Yaveo™, jamás te perderás lo que más te gusta ver.',
        'cta' => ''
    ),
    'module4' => array(
        'image' => 'img/free_week.jpg',
        'headline' => 'Solo $7.99 al mes. ¡Te regalamos las primeras 2 semanas!',
        'copy' => 'Las primeras 2 semanas de Yaveo son gratis y después sólo $7.99 al mes. Puedes cancela en cualquier momento. ¡Disfruta del mejor entretenimiento en español a tu manera!',
        'cta' => '¡Obtén las primeras 2 semanas gratis!'
    ),
    'disclaimer' => '*Solo pueden verse por streaming dos programas a la vez. Las funcionalidades varían según el dispositivo compatible. Los canales en vivo están incluidos por tiempo limitado en el servicio de Yaveo de $7.99. Ve los <a href="https://www.yaveo.com/offerdetails/index_es.html" target="_blank">Detalles de la oferta</a> para más información. La oferta es válida del 14 de septiembre al 15 octubre 2015. Este servicio solo está disponible en Estados Unidos (excepto Puerto Rico). Todas las funcionalidades y la programación están sujetas a cambio en cualquier momento.',
    'artFooter' => '&copy;2015 Sony Pictures. All Rights Reserved. Rudo y Cursi, Broken Embraces, Nine Queens, Bad Education, and all related titles, logos and characters are trademarks of Sony Pictures. &copy;2015 Lions Gate Entertainment Inc. All Rights Reserved. Amor Dolor y Viceversa, Canela, Hecho en México and all related titles, logos and characters are trademarks of Lions Gate Entertainment Inc.'
);

// DATA
switch($con) {
    case 'sports':
        case 'sports':
        $data['pageName'] = 'AcqSports_Es';
        $data['masthead']['image'] = 'img/masthead-sports.jpg';
        $data['masthead']['mobileImage'] = 'img/masthead-mobile-sports.jpg';
        $data['masthead']['headline'] = 'Aquí viven tus ídolos';
        $data['masthead']['secondary'] = 'La Liga, Serie A, Ligue 1 y, por supuesto, películas, novelas, series y mucho más por solo $7.99 al mes.';
        $data['module2']['image'] = 'img/mediaModule_SPORTS_500x300.jpg';
        $data['module2']['headline'] = 'Fútbol, béisbol, boxeo y otros deportes EN VIVO están a tu alcance en Yaveo<sup>TM</sup>.';
        $data['module2']['copy'] = 'En Yaveo disfruta tus deportes favoritos en casa o donde quieras.';
        $data['artFooter'] = '&copy;2015 beIN SPORTS. Todos los derechos reservados.';
        break;
    case 'novelas':
        $data['pageName'] = 'AcqNovelas_Es';
        $data['masthead']['image'] = 'img/masthead-novelas.jpg';
        $data['masthead']['mobileImage'] = 'img/masthead-mobile-novelas.jpg';
        $data['masthead']['headline'] = 'Aquí viven las novelas de ayer y hoy';
        $data['masthead']['secondary'] = 'Novelas para todos los gustos y, por supuesto, películas, fútbol en vivo, series y mucho más por solo $7.99 al mes.';
        $data['module2']['image'] = 'img/mediaModule_NOVELAS_500x300.jpg';
        $data['module2']['headline'] = 'Si lo tuyo son las novelas clásicas y modernas, vívelas en Yaveo.';
        $data['module2']['copy'] = 'Con Yaveo, puedes vivir la inigualable experiencia de las novelas donde estés.';
        $data['artFooter'] = '&copy;2015 Univision Communications Inc. Todos los derechos reservados. Mi Corazon Es Tuyo, La Sombra del Pasado, Maria Mercedes, La Usurpadora, Yo No Creo en Hombres, Marimar y todos los títulos relacionados, logos y personajes son marcas registradas de Univision Communications Inc. &copy;2015 Cisneros. Todos los derechos reservados. Eva Luna y todos los títulos relacionados, logos y personajes son marcas registradas de Cisneros.';
        break;
    case 'kids':
        $data['pageName'] = 'AcqKids_Es';
        $data['masthead']['image'] = 'img/masthead-kids.jpg';
        $data['masthead']['mobileImage'] = 'img/masthead-mobile-kids.jpg';
        $data['masthead']['headline'] = '¡Aventuras, diversión y más viven aquí!';
        $data['masthead']['secondary'] = 'Descubre programas infantiles para todas las edades y también novelas, películas, shows y mucho más por solo $7.99 al mes.';
        $data['module2']['image'] = 'img/mediaModule_KIDS_500x300.jpg';
        $data['module2']['headline'] = 'Si lo tuyo es la programación infantil, vívela en Yaveo.';
        $data['module2']['copy'] = 'En Yaveo<sup>TM</sup> los pequeñitos también pueden disfrutar su programación favorita.';
        $data['artFooter'] = '&copy;2015 Viacom International Inc. Todos los derechos reservados. Nickelodeon, Dora la Exploradora, iCarly y todos los títulos relacionados, logos y personajes son marcas registradas de Viacom International Inc. &copy;2015 FlixLatino. Todos los derechos reservados. Bali y todos los títulos reacionados, logos y personajes son marcas registradas de FlixLatino. &copy;2015 Smilehood. Todos los derechos reservados. Plim Plim y todos los títulos reacionados, logos y personajes son marcas registradas de Smilehood. &copy;2015 Univision Communications Inc. Todos los derechos reservados. El Chavo y todos los títulos relacionados, logos y personajes son marcas registradas de Univision Communications Inc. &copy;2015 Imira Entertainment S.L. Todos los derechos reservados. Lola y Virigina y todos los títulos relacionados, logos y personajes son marcas registradas de Imira Entertainment S.L. &copy;2015 Lions Gate Entertainment Inc. Todos los derechos reservados. La leyenda de la Llorona y todos los títulos relacionados, logos y personajes son marcas registradas de Lions Gate Entertainment Inc.';
        break;
}

?>

<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Yaveo</title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- STYLESHEETS -->
        <link href="css/normalize.css" rel='stylesheet'>
        <link href="css/grid.css" rel='stylesheet'>
        <link href="css/main.css" rel='stylesheet'>
        <link href="fonts/yaveo/yaveofont.css" rel='stylesheet'>
        <link href="fonts/fontawesome/font-awesome.css" rel='stylesheet'>

        <script type="text/javascript" src="js/Ooyala_Omniture.js"></script>

        <script type="text/javascript">

            function resetEvars() {
                s.pageName = '';
                s.server = '';
                s.pageType = '';
                s.events = '';
                s.eVar17 = '';
                s.eVar8 = '';
                s.prop9 = '';
                s.eVar18 = '';
                s.eVar4 = '';
                s.eVar1 = '';
                s.prop1 = '';
                s.eVar2 = '';
                s.prop5 = s.eVar5 = '';
                s.eVar10 = '';
                s.eVar14 = '';
            }

            var s = Reporting.getReportingObject('dtvdirectvhottprod'); // 'dtvdtvdirectvhottest' for testing, 'dtvdirectvhottprod' for production
            s.channel = 'https:www.yaveo.com'; // https:www.yaveo.com for production
            resetEvars();

            var pageName = <?php echo "'".$data['pageName']."'"; ?>; //replace with the page names listed below
            s.pageName = pageName;
            s.server = '';
            s.pageType = '';
            s.events = 'event1,event2';
            var accountNumber = ''; //Sessions.getCookie('userid');
            if (typeof accountNumber !== 'undefined') s.eVar17 = accountNumber;
            s.eVar1 = ''; //<subscriber_type> Subscriber/Non Subscribe //on page load
            s.prop1 = navigator.userAgent; //<device_type>
            s.prop9 = (typeof propNine !== 'undefined') ? propNine : '';
            s.eVar2 = ''; //package of the user //on page load
            //s.prop2='' //not known
            s.eVar3 = ''; //<search_term_typed> //on search
            s.prop3 = ''; //# of results from search //on search
            s.eVar4 = ''; //Piped origin of playback //on video playback
            s.prop4 = ''; //view type
            s.prop5 = s.eVar5 = 'en_EN'; //language of the page en_EN for english and es_ES 
            s.eVar7 = ''; //genre if applicable on page with genre info //on page load
            //s.prop7 //# of Videos in Watchlist //on page load of watchlist
            //s.eVar8 //<movie_title | Showname_Seasonid_Episodeid> //on video playback
            //s.prop8 //promocodes // on signup completion or new subscribtion
            //s.eVar9 //Name of social sharing network //on sharing video
            s.eVar10 = navigator.userAgent; //<device_type> //on page load
            //s.eVar12 //<connection_type> //not sure for web //on page load
            //s.eVar13 //<programmer_name>(if applicable) Only when user selects a network. Capital letter Network Name
            //on page load
            s.eVar14 = ''; //<subscription_type> // on signup completion
            //s.eVar15 //Number of videos in watchlist page //on page load
            //s.eVar16 //<promo_codes> // on signup completion
            var s_code = s.t();
            if (s_code) console.log(s_code);
            console.log(pageName);

        </script>

    </head>
    <body class="<?php echo $pageName; ?>">
        <!--[if lt IE 7]>
            <p class="browsehappy">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
        <![endif]-->

        <!-- SITE CONTENT -->
        <div class="container">

            <div class="wrap">
                
                <div id="header">
                    <div class="row">
                        <div class="col-xs-6 col-sm-7">
                            <div class="logo-box">
                                <img src="img/yaveo-logo.png" class="img-responsive"/>
                            </div>
                        </div>
                        <div class="col-xs-6 col-sm-5">
                            <div id="logBox">
                                <a href="<?php echo $data['loginLink']; ?>" class="btn btn-blue btn-short">Log In</a>
                            </div>
                            <div id="langBox">
                                <div class="langswitch">
                                    <input type="checkbox" name="langswitch" class="langswitch-checkbox" id="langswitch" checked>
                                    <label class="langswitch-label" for="langswitch">
                                        <span class="langswitch-inner"></span>
                                        <span class="langswitch-switch"></span>
                                    </label>
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                </div>

                <div id="banner">
                    
                    <div id="bannerImageBox">
                        <?php 
                            if($device->isMobile() && !$device->isTablet()){
                                $mastheadImage = $data['masthead']['mobileImage'];
                            }else{
                                $mastheadImage = $data['masthead']['image'];
                            }
                        ?>
                        <img id="bannerImage" src="<?php echo $mastheadImage; ?>" class="img-responsive" alt=""/>
                    </div>

                    <div class="cta">
                        <div class="headline main text"><?php echo $data['masthead']['headline']; ?></div>
                        <div class="row">
                            <div class="col-xs-12 col-md-7">
                                <div class="headline secondary text"><?php echo $data['masthead']['secondary']; ?></div>
                            </div>
                            <div class="col-xs-12 col-md-5">
                                <div class="button">
                                    <a href="https://www.yaveo.com/es/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['masthead']['cta']; ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content">

                    <div id="mod1" class="module">
                        <div class="row">
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <img src="<?php echo $data['module1']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-7 col-md-7">
                                <h2><?php echo $data['module1']['headline']; ?></h2>
                                <p><?php echo $data['module1']['copy']; ?></p>
                                <?php if($data['module1']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/es/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module1']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <div id="mod2" class="module">
                        <div class="row">
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <img src="<?php echo $data['module2']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-7 col-md-7">
                                <h2><?php echo $data['module2']['headline']; ?></h2>
                                <p><?php echo $data['module2']['copy']; ?></p>
                                <?php if($data['module2']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/es/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module2']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <div id="mod3" class="module">
                        <div class="row">
                            <div class="col-xs-12 hidden-sm hidden-md hidden-lg hidden-xl">
                                <img src="<?php echo $data['module3']['mobileImage']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <h2><?php echo $data['module3']['headline']; ?></h2>
                                <p><?php echo $data['module3']['copy']; ?></p>
                                <?php if($data['module3']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/es/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module3']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                            <div class="hidden-xs col-sm-7 col-md-7">
                                <img src="<?php echo $data['module3']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                        </div>
                    </div>

                    <div id="mod4" class="module">
                        <div class="row">
                            <div class="col-xs-12 col-sm-5 col-md-5">
                                <img src="<?php echo $data['module4']['image']; ?>" class="img-responsive" alt=""/>
                            </div>
                            <div class="col-xs-12 col-sm-7 col-md-7">
                                <h2><?php echo $data['module4']['headline']; ?></h2>
                                <p><?php echo $data['module4']['copy']; ?></p>
                                <?php if($data['module4']['cta']!=''){
                                    ?>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-9 col-lg-7">
                                            <a href="https://www.yaveo.com/es/selectPackage" class="btn btn-orange btn-tall"><?php echo $data['module4']['cta']; ?></a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                </div>

                <div id="footer" class="textcenter">
                    <a href="#" class="back-to-top"><i class="fa fa-chevron-up fa-2x"></i></a>
                    <ul class="disclaimer">
                        <?php echo $data['disclaimer'].' '.$data['artFooter']; ?>
                    </ul>
                    <ul class="list-inline">
                        <li class="blue-text">&copy;2015 DIRECTV DIGITAL LLC</li>
                        <li><a href="https://www.yaveo.com/es/pp">Política de privacidad</a></li>
                        <li><a href="https://www.yaveo.com/es/tou">Términos de uso</a></li>
                        <li><a href="https://ayuda.yaveo.com">Ayuda</a></li>
                        <li><a href="https://www.yaveo.com/wheretowatch/es.html">Donde ver</a></li>
                    </ul>
                    
                </div>

            </div>
            
        </div>

        <!-- Google Tag Manager -->
        <noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-5J7G8D" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start': new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0], j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src='//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f); m})(window,document,'script','dataLayer','GTM-5J7G8D');</script>
        <!-- End Google Tag Manager -->


        <!-- JAVASCRIPT GOES HERE -->
        <script src="js/jquery.min.js"></script>
        <script src="js/jquery-ui.min.js"></script>
        <script src="js/modernizr.js"></script>
        <script src="js/main.js"></script>
    </body>
</html>