<?php

	/*
	Plugin Name: ZoomShowcase
	Plugin URI: http://www.codingjack.com/zoomshowcase_wp/
	Description: ZoomShowcase Banner Plugin
	Version: 1.3
	Author: CodingJack
	Author URI: http://www.codingjack.com/
	*/
	
	$zoomshowcase_options = get_option("zoomshowcase_options");
	
	if(!$zoomshowcase_options) {
		
		$zoomshowcase_options = array(
		
			"defaults" => array(
				
				"customcss" => "",
				"randomize" => "no", 
				"autoplay" => "no", 
				"sidezoom" => "0.65",
				"backzoom" => "0.35",
				"responsive" => "no",
				"imagewidth" => "565",
				"imageheight" => "377",
				"bannerwidth" => "960",
				"sideopacity" => "0.5",
				"animationspeed" => "750",
				"mobilecaptions" => "yes", 
				"autoplaydelay" => "4000",
				"easing" => "Quint.easeOut", 
				"googlefont" => "Yanone+Kaffeesatz",
				"slide" => __("Slide", "zoomshowcase_domain"),
				"remove" => __("Delete this?", "zoomshowcase_domain")
				
			),
				
			"shortcodes" => array()
		
		);
		
		add_option("zoomshowcase_options", $zoomshowcase_options);

	}
	
	function zoomshowcase_admin_link($links) {
		
		array_unshift($links, '<a href="' . get_admin_url() . 'plugins.php?page=zoomshowcase_admin">Admin</a>');
		
		return $links;
		
	}
	
	function deactivate_zoomshowcase() {

		delete_option("zoomshowcase_options");

	}

	if(!is_admin()) {
		
		include("includes/wp-zoomshowcase-scripts.php");

	}

	else {
		
		include("includes/wp-zoomshowcase-admin.php");
		include_once(ABSPATH . "wp-admin/includes/plugin.php");
		
		if(is_plugin_active("wp-zoomshowcase/wp-zoomshowcase.php")) {
			
			add_filter("plugin_action_links_" . plugin_basename(__FILE__), "zoomshowcase_admin_link");
			
		}
		
		/* 
			uncomment the line below to remove ZoomShowcase data from the WP database upon deactivation 
		*/
		
		// register_deactivation_hook(__FILE__, "deactivate_zoomshowcase");
		
	}
	

?>