<?php
	
	function zoomshowcase_enqueue() {
		
		wp_enqueue_style("cj_zoomshowcase_css", plugins_url("wp-zoomshowcase/zoomshowcase/css/zoomshowcase.css"));
		
		wp_enqueue_script("google-fonts", "//ajax.googleapis.com/ajax/libs/webfont/1.0.31/webfont.js");
		wp_enqueue_script("cj_jquick", plugins_url("wp-zoomshowcase/zoomshowcase/js/jquick.min.js"));
		wp_enqueue_script("cj_zoomschowcase_script", plugins_url("wp-zoomshowcase/zoomshowcase/js/jquick.zoomshowcase.js"));

	}
	
	function zoomshowcase_process_shortcode($atts) {

		global $zoomshowcase_options;
		extract(shortcode_atts(array("name" => ""), $atts));
		
		$shortcodes = $zoomshowcase_options["shortcodes"];		
		if(!array_key_exists($name, $shortcodes)) return "";

		$showcase = $shortcodes[$name];
		if(!array_key_exists("slides", $showcase)) return "";
		
		$id = implode('_', explode(' ', $name));
		$css = $showcase["customcss"];
		$markup = '';
		
		if($css) {
			
			$css = '#' . $id . ' ' . urldecode($css);
			$css = implode('}' . $id . ' ', explode('}', $css));
			$css = substr_replace($css, '', strrpos($css, $id), strlen($id));
			
			$markup .= '<style type="text/css" id="' . $id . '_css">' . $css . '</style>';
			
		}
		
		$markup .= '<div id="' . $id . '" class="cj-zoom-showcase"' . 
                
			' data-easing="' . $showcase["easing"] . '"' . 
			' data-autoplay="' . $showcase["autoplay"] . '"' . 
			' data-sidezoom="' . $showcase["sidezoom"] . '"' . 
			' data-backzoom="' . $showcase["backzoom"] . '"' . 
			' data-googlefont="' . $showcase["googlefont"] . '"' . 
			' data-responsive="' . $showcase["responsive"] . '"' . 
			' data-imagewidth="' . $showcase["imagewidth"] . '"' . 
			' data-imageheight="' . $showcase["imageheight"] . '"' . 
			' data-bannerwidth="' . $showcase["bannerwidth"] . '"' . 
			' data-sideopacity="' . $showcase["sideopacity"] . '"' . 
			' data-randomizeitems="' . $showcase["randomize"] . '"' . 
			' data-autoplaydelay="' . $showcase["autoplaydelay"] . '"' . 
			' data-mobilecaptions="' . $showcase["mobilecaptions"] . '"' . 
			' data-animationspeed="' . $showcase["animationspeed"] . '">';  
				
		$slides = $showcase["slides"];
		$linkTarget = NULL;
		$captions = NULL;
		
		foreach($slides as $slide) {
			
			$markup .= PHP_EOL . '<div class="cj-zoom-item" ';
			
			if(array_key_exists("hyperlink", $slide)) {
				
				$linkTarget = array_key_exists("target", $slide) ? $slide["target"] : "no";
				$markup .= ' data-link="' . $slide["hyperlink"] . '" data-target="' . $linkTarget . '"';
				
			}
			
			$markup .= ">" . PHP_EOL . '<img src="' . $slide["image"] . '" />' . PHP_EOL;
			
			if(array_key_exists("captions", $slide)) {
			
				$captions = $slide["captions"];
				
				foreach($captions as $caption) {
					
					$markup .= '<span data-align="' . $caption["align"] . 
					
									'" data-x="' . $caption["posx"] . 
									'" data-y="' . $caption["posy"] . 
									'" data-target="' . $caption["captiontarget"] . 
									'" data-link="' . $caption["captionhyperlink"] . 
									'" data-bgcolor="' . $caption["bgcolor"] . 
									'" data-textcolor="' . $caption["textcolor"] . 
									
								'">' . $caption["caption"] . '</span>' . PHP_EOL;
					
				}
				
			}
			
			$markup .= "</div>";
						
		}

		return $markup . "</div>";

	}
	
	add_action("wp_enqueue_scripts", "zoomshowcase_enqueue");
	add_shortcode("zoomshowcase", "zoomshowcase_process_shortcode");

?>