var appServices = angular.module('appServices', [])

	.service('fbServices', function ($http, $log, $q, $rootScope, $sessionStorage) {
		var self = this;

		this.watchLoginChange = function() {

		  	FB.Event.subscribe('auth.authResponseChange', function(res) {
			    if (res.status === 'connected') {
			      	self.getUserInfo();
			    } else {
			       
			    }
		  	});
		}

		this.fbLogin = function() {
			var defer = $q.defer();

			FB.login(function(response) {
				if (response.authResponse) {
					FB.api('/me',{fields: 'id, first_name, last_name, email, picture, location'}, function(res) {
						$rootScope.$apply(function() { 
							$rootScope.fbLogged = true;
							$rootScope.fbUser = self.user = res;
						});
						self.status = 'success';
						self.data = res;
						defer.resolve(self);
					});
				} else {
					self.status = 'error';
					self.msg = 'User cancelled login or did not fully authorize.';
					self.data = res;
					defer.resolve(self);
				}
			});

			return defer.promise;
		}

		this.getUserInfo = function() {
			FB.api('/me',{fields: 'id, first_name, last_name, email, picture, location'}, function(res) {
				//$sessionStorage.fbUser = self.user = res;
				$rootScope.$apply(function() { 
					$rootScope.fbLogged = true; 
					$rootScope.fbUser = self.user = res;
				});
			});
		}

	})

	.service('dataServices', function ($http, $log, $q, $rootScope, $sessionStorage) {
		var self = this;

		this.getUserData = function(id) {
			var defer = $q.defer();

			$http.get('/services/data/get-user.php?id='+id)
				.success(function(userData){
					self.userData = userData;
					$rootScope.appLogged = true;
					$rootScope.appUser = userData.data;
					defer.resolve(self.userData);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});

			return defer.promise;
		}

		this.getUserDataManual = function(email,pass) {
			var defer = $q.defer();

			$http.get('/services/data/get-user-manual.php?email='+email+'&pass='+pass)
				.success(function(userData){
					self.userData = userData;
					$rootScope.appLogged = true;
					$rootScope.appUser = userData.data;
					defer.resolve(self.userData);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});

			return defer.promise;
		}

		this.getRoutineCategories = function() {
			var defer = $q.defer();

			$http.get('/services/data/get-routine-categories.php')
				.success(function(categories){
					self.categories = categories;
					defer.resolve(self.categories);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});

			return defer.promise;
		}

		this.getRoutinesAndCategories = function() {
			var defer = $q.defer();

			$http.get('/services/data/get-routines-and-categories.php')
				.success(function(categories){
					self.categories = categories;
					defer.resolve(self.categories);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});

			return defer.promise;
		}

		this.getRoutine = function(id) {
			var defer = $q.defer();

			$http.get('/services/data/get-routine.php?id='+id)
				.success(function(routine){
					self.routine = routine;
					defer.resolve(self.routine);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});

			return defer.promise;
		}

		this.getTodaysRoutines = function(list){
			var defer = $q.defer();

			$http.get('/services/data/get-todays-routines.php?list='+list)
				.success(function(routines){
					self.routines = routines;
					defer.resolve(self.routines);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});
			return defer.promise;
		}

		this.getRoutinesList = function(id) {
			var defer = $q.defer();

			$http.get('/services/data/get-routines-list.php')
				.success(function(routines){
					self.routines = routines;
					defer.resolve(self.routines);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});

			return defer.promise;
		}

		this.saveRoutine = function(rid,score,user) {
			var defer = $q.defer();

			$http.get('/services/data/save-routine.php?rid='+rid+'&score='+score+'&user='+user)
				.success(function(routine){
					self.routine = routine;
					defer.resolve(self.routine);
				})
				.error(function(data, status, headers, config){
					$log.log(data.error+' '+status);
					defer.reject("Error: unsuccessful http request: "+ status);
				});

			return defer.promise;
		}
	})