<!doctype html>  

<!--[if IEMobile 7 ]> <html <?php language_attributes(); ?>class="no-js iem7"> <![endif]-->
<!--[if lt IE 8 ]>    <html <?php language_attributes(); ?> class="no-js lt-ie8"> <![endif]-->
<!--[if lt IE 9 ]>    <html <?php language_attributes(); ?> class="no-js lt-ie9"> <![endif]-->
<!--[if lt IE 10 ]>   <html <?php language_attributes(); ?> class="no-js lt-ie10"> <![endif]-->
<!--[if (gte IE 9)|(gt IEMobile 7)|!(IEMobile)|!(IE)]><!--><html <?php language_attributes(); ?> class="no-js"><!--<![endif]-->
	
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		
		<title>
			<?php
				if( empty( $title ) && ( is_home() || is_front_page() ) ) {
					echo bloginfo( 'name' ); 
				}else{
					echo wp_title( ' ', true, 'left' );
				}

				if(bloginfo('description')!=''){
					echo ' | '; 
					bloginfo( 'description', 'display' );  
				}
			?>
		</title>
				
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no"/>

		<!-- Mobile Icons -->
		<link rel="shortcut icon" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/favicon.ico">
		<link rel="apple-touch-icon" sizes="57x57" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-57x57.png">
		<link rel="apple-touch-icon" sizes="114x114" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-114x114.png">
		<link rel="apple-touch-icon" sizes="72x72" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-72x72.png">
		<link rel="apple-touch-icon" sizes="144x144" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-144x144.png">
		<link rel="apple-touch-icon" sizes="60x60" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-60x60.png">
		<link rel="apple-touch-icon" sizes="120x120" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-120x120.png">
		<link rel="apple-touch-icon" sizes="76x76" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-76x76.png">
		<link rel="apple-touch-icon" sizes="152x152" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/apple-touch-icon-152x152.png">
		<link rel="icon" type="image/png" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/favicon-196x196.png" sizes="196x196">
		<link rel="icon" type="image/png" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/favicon-160x160.png" sizes="160x160">
		<link rel="icon" type="image/png" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/favicon-96x96.png" sizes="96x96">
		<link rel="icon" type="image/png" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/favicon-16x16.png" sizes="16x16">
		<link rel="icon" type="image/png" href="<?php echo WP_SITEURL; ?>/wp-content/library/icons/favicon-32x32.png" sizes="32x32">
		<meta name="msapplication-TileColor" content="#000000">
		<meta name="msapplication-TileImage" content="<?php echo WP_SITEURL; ?>/wp-content/library/icons/mstile-144x144.png">
		<meta name="msapplication-config" content="<?php echo WP_SITEURL; ?>/wp-content/library/icons/browserconfig.xml">
		
  		<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

		<?php wp_head(); ?>
				
	</head>
	
	<body <?php body_class(); ?>>

		<div id="wrap">

			<header id="mainHeader">

				<div id="innerBranding">
					<div class="container">
						<div class="panel_menu">
							<a href="#main-menu" class="panel_link"><i class="fa fa-reorder"></i></a>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-8 col-md-5">
								<div id="logoBox">
									<?php if ( get_theme_mod( 'logo' ) ) : ?>
									    <a href='<?php echo esc_url( home_url( '/' ) ); ?>' title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' rel='home'><img src='<?php echo esc_url( get_theme_mod( 'logo' ) ); ?>' alt='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' class="img-responsive" width="500" height="108" /></a>
									<?php else : ?>
									    <hgroup>
									        <h1 class='site-title'><a href='<?php echo esc_url( home_url( '/' ) ); ?>' title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' rel='home'><?php bloginfo( 'name' ); ?></a></h1>
									        <h2 class='site-description'><?php bloginfo( 'description' ); ?></h2>
									    </hgroup>
									<?php endif; ?>
								</div>
							</div>
							<div class="col-md-7 hidden-xs hidden-sm">
								<?php bones_top_nav(); ?>
							</div>
						</div>
					</div>
				</div>

				<nav role="navigation" class="main-menu">
					<a href='<?php echo esc_url( home_url( '/' ) ); ?>' class="pull-left home-link <?php if(is_front_page()){echo 'current-menu-item';} ?>" title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' rel='home'><i class="fa fa-home fa-2x"></i></a>
					<?php bones_main_nav(); ?>
				</nav>
			
			</header>