<?php

/*
--------------------------------------------------------------
CORE INCLUDES AND SETTINGS
--------------------------------------------------------------
*/

require_once(WP_CONTENT_DIR.'/library/core_funcs/plugins.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/shortcodes.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/post_types.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/images.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/sidebars.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/global_options.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/admin_appear.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/enqueues.php');
require_once(WP_CONTENT_DIR.'/library/core_funcs/utilities.php');


/*
--------------------------------------------------------------
HIDE ADMIN BAR FOR ALL USERS
--------------------------------------------------------------
*/
show_admin_bar(false);


function aw_slug_filter_wp_title( $title ) {
    if ( is_404() ) {
        $title = "404. You're just off target!";
    }
    return $title;
}
add_filter('wp_title','aw_slug_filter_wp_title',11);


/*
--------------------------------------------------------------
ENQUEUE THEME SPECIFIC STYLES
--------------------------------------------------------------
*/
add_action('wp_enqueue_scripts', 'theme_styles', 10);
function theme_styles() { 

    // fonts
    wp_enqueue_style( 'google-fonts', get_option('fonts_include'), array(), null, 'all' );

    // stylesheets
    wp_enqueue_style( 'rootstyle', get_stylesheet_directory_uri().'/style.css', array(), '1.0', 'all' );  
    wp_enqueue_style( 'textstyle', get_stylesheet_directory_uri().'/editor-style.css', array(), '1.0', 'all' );
}


/*
--------------------------------------------------------------
ENQUEUE THEME SPECIFIC SCRIPTS
--------------------------------------------------------------
*/
add_action('wp_enqueue_scripts', 'theme_js', 10);
function theme_js() {
  wp_enqueue_script('themescripts', get_stylesheet_directory_uri().'/library/js/customscripts.js', array('jquery'), '1.0', true);
}

?>