<?php

/*
--------------------------------------------------------------
GLOBAL THEME OPTIONS
--------------------------------------------------------------
*/

function narga_customize_preview_js() {
  wp_enqueue_script( 'customizerPreview', site_url('wp-content/library/core_funcs/customizerPreview.js'), array(), '1.0', true );
}   
 
function my_add_scripts() {
    wp_enqueue_media();
    wp_enqueue_script('media-manager', site_url('wp-content/library/core_funcs/mediaManager.js'), array( ), '1.0', true);
}

function my_customize_styles() { ?>
    <style>
    .wp-full-overlay {
        z-index: 150000 !important;
    }
    </style>
<?php }

function theme_customize_register( $wp_customize ){
  global $my_image_controls;

  class textarea_control extends WP_Customize_Control {
    public $type = 'textarea';

    public function render_content(){
      ?>
        <label>
          <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
          <textarea rows="5" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea($this->value()); ?></textarea>
        </label>
      <?php
    }
  }


  // site logo
  $wp_customize->add_section('logo_section', array(
    'title' => __('Site Logo','desktop'),
    'priority' => 10,
    'description' => 'Upload a logo to use for the site.',
  ));

  $wp_customize->add_setting( 'logo', array(
        'transport'     => 'postMessage'
  ));

  $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo_image', 
        array(
          'label'         => __( $label, 'my_theme' ),
          'section'       => 'logo_section',
          'priority'      => 0,
          'settings'      => 'logo'
        ) 
  )); 

  $logo_control = $wp_customize->get_control('logo_image');
  $logo_control->add_tab('library', __('Media Library'), function(){
    ?>
      <a class="choose-from-library-link button"
          data-controller = "<?php esc_attr_e( 'logo_image' ); ?>">
          <?php _e( 'Open Library' ); ?>
      </a>
    <?php
  });

  // alt site logo
  $wp_customize->add_section('alt_logo_section', array(
    'title' => __('Alternate Site Logo','desktop'),
    'priority' => 11,
    'description' => 'Upload an alternate logo to use for the site.',
  ));

  $wp_customize->add_setting( 'alt_logo', array(
        'transport'     => 'postMessage'
  ));

  $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'alt_logo_image', 
        array(
          'label'         => __( $label, 'my_theme' ),
          'section'       => 'alt_logo_section',
          'priority'      => 0,
          'settings'      => 'alt_logo'
        ) 
  )); 

  $logo_control = $wp_customize->get_control('alt_logo_image');
  $logo_control->add_tab('library', __('Media Library'), function(){
    ?>
      <a class="choose-from-library-link button"
          data-controller = "<?php esc_attr_e( 'alt_logo_image' ); ?>">
          <?php _e( 'Open Library' ); ?>
      </a>
    <?php
  });

  // misc options
  $wp_customize->add_section('misc_section', array(
    'title' => __('Misc Options','desktop'),
    'priority' => 12,
    'description' => 'Misc site options.',
  ));

  $wp_customize->add_setting('suppress_comments_setting');

  $wp_customize->add_control('suppress_comments', array(
    'label' => __('Suppress Comments', 'desktop'),
    'section' => 'misc_section',
    'settings' => 'suppress_comments_setting',
    'type' => 'checkbox',
  ));

  // global footer
  $wp_customize->add_section('footer_section', array(
    'title' => __('Global Footer','desktop'),
    'priority' => 13,
    'description' => 'Global Footer Text.',
  ));

  $wp_customize->add_setting('global_footer_setting');

  $wp_customize->add_control(new textarea_control($wp_customize, 'global_footer', array(
    'label' => __('Global Footer', 'desktop'),
    'section' => 'footer_section',
    'settings' => 'global_footer_setting',
  )));
}


/*
--------------------------------------------------------------
ACTIONS
--------------------------------------------------------------
*/
add_action('customize_preview_init', 'narga_customize_preview_js');
add_action('customize_controls_enqueue_scripts', 'my_add_scripts');
add_action('customize_controls_print_styles', 'my_customize_styles', 50);
add_action('customize_register', 'theme_customize_register');
?>