<!doctype html>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="en"> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" lang="en"> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="en"> <!--<![endif]-->
<head>
  <meta charset="utf-8">

  <!-- Use the .htaccess and remove these lines to avoid edge case issues.
       More info: h5bp.com/i/378 -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

  <title>DownloadStatus Popup Settings</title>
  <meta name="description" content="">

  <!-- Mobile viewport optimized: h5bp.com/viewport -->
  <meta name="viewport" content="width=device-width">

  <!-- Style Sheet links -->
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/toggle-buttons.css">
  <link rel="stylesheet" href="js/colorpicker/css/colorpicker.css">
  <link rel="stylesheet" href="css/app.css">

  <!-- All JavaScript at the bottom, except this Modernizr build.
       Modernizr enables HTML5 elements & feature detects for optimal performance.
       Create your own custom Modernizr build: www.modernizr.com/download/ -->
  <script src="js/modernizr.js"></script>
    
</head>
<body>


    <div id="wrap" class="container" role="document">

    	<div class="row">
        	<div class="span12" role="main" style="margin-top:50px;">

          		<!-- Button to trigger modal -->
				<a href="#ds_modal" role="button" class="btn btn-block" data-toggle="modal">Launch Settings Modal</a>
				 
				<!-- Modal -->
				<div id="ds_modal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">

				  <div class="modal-body">
				    <!-- Settings Form -->
				    <div class="setting container">
						<img src="img/downloadstatusbar.png" />
						<br /><br />
						<ul class="nav nav-tabs">
						  	<li class="active"><a href="#general" data-toggle="tab">General</a></li>
						  	<li><a href="#appearance" data-toggle="tab">Appearance</a></li>
						  	<li><a href="#cloudsavetab" data-toggle="tab">Cloud Save Tab</a></li>
						  	<li><a href="#virusscan" data-toggle="tab">Virus Scan</a></li>
						</ul>

						<div class="tab-content">
							<div class="tab-pane active" id="general">
							  	<div class="row-fluid">
							  		<div class="span5">
							  			<div class="well" style="height:167px;">
							  				<h5>Progress Notifications</h5>
							  				<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Download speed
											</label>
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Time remaining
											</label>
											<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Progress percent
											</label>
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Size downloaded so far
											</label>
							  			</div>
							  		</div>
							  		<div class="span7">
							  			<div class="well">
							  				<h5>Statusbar Mode</h5>
							  				<label class="radio inline selected">
											   <input type="radio" name="moderadios" id="" value="" checked>
											  	Full Mode
											</label>
											<label class="radio inline">
											  	<input type="radio" name="moderadios" id="" value="">
											  	Mini Mode
											</label>
							  			</div>
							  			<div class="well">
							  				<h5>Download History</h5>
							  				<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Keep a download history
											</label>
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Trim the download history to <input type="text" name="" id="" value="50" class="span2 textcenter"> downloads
											</label>
							  			</div>
							  		</div>
							  	</div>
							  	<div class="row-fluid">
							  		<div class="span12">
							  			<div class="well">
							  				<h5>Features</h5>
							  				<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Automatically continue downloads in the download manager when the browser closes
											</label>
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Clear finished downloads when the browser closes
											</label>
											<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Comfirm before deleting a file from the system
											</label>
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Clear a finished download after opening it
											</label>
											<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Clear a finished download after opening containing folder
											</label>
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Show the 'Downloads Completed' notification <span class="danger">(Recommended OFF)</span>
											</label>
											<br />
											Ignore these filetypes <input type="text" name="" id="" value="jpg,jpeg,png,gif" class="span4 textcenter"> after <input type="text" name="" id="" value="5" class="span1 textcenter"> seconds
											<br />
											<small class="offset2">Enter * for all filetypes, leave blank for none</small>
											<hr />
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Play sound when download completes
											</label>
											<select name="" id="" class="clearmargin">
											  <option>Option 1</option>
											  <option>Option 2</option>
											  <option>Option 3</option>
											  <option>Option 4</option>
											  <option>Option 5</option>
											</select>
											Except for filetypes: <input type="text" name="" id="" value="" class="span4 textcenter">
							  			</div>
							  		</div>
							  	</div>
							</div>
							<div class="tab-pane" id="appearance">
							  	<div class="row-fluid">
							  		<div class="span12">
							  			<div class="well clearfix">
							  				<h5>Styles</h5>
							  				<label class="radio inline selected">
											   <input type="radio" name="styleradio" id="" value="" checked>
											  	Default Style
											</label>
											<label class="radio inline">
											  	<input type="radio" name="styleradio" id="" value="">
											  	Custom Style
											</label>
											<button type="button" class="btn btn-inverse pull-right">Reset Custom</button>
							  			</div>
							  		</div>
							  	</div>
							  	<div class="row-fluid">
							  		<div class="span5">
							  			<div class="well">
							  				<h5>Colors &amp; Buttons</h5>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						Progress Bar <input type="text" maxlength="6" name="" id="colorpickerField1" value="00ff00" class="span3 cp textcenter pull-right"/>
							  					</div>
							  				</div>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						Progress Reminder <input type="text" maxlength="6" name="" id="colorpickerField2" value="00ff00" class="span3 cp textcenter pull-right"/>
							  					</div>
							  				</div>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						Finished Download <input type="text" maxlength="6" name="" id="colorpickerField3" value="00ff00" class="span3 cp textcenter pull-right"/>
							  					</div>
							  				</div>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						Stopped Download <input type="text" maxlength="6" name="" id="colorpickerField4" value="00ff00" class="span3 cp textcenter pull-right"/>
							  					</div>
							  				</div>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						Paused Outline <input type="text" maxlength="6" name="" id="colorpickerField5" value="00ff00" class="span3 cp textcenter pull-right"/>
							  					</div>
							  				</div>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						Text <input type="text" maxlength="6" name="" id="colorpickerField6" value="00ff00" class="span3 cp textcenter pull-right"/>
							  					</div>
							  				</div>
							  				<div class="row-fluid">
							  					<div class="span12">
							  						Statusbar Background <input type="text" maxlength="6" name="" id="colorpickerField7" value="00ff00" class="span3 cp textcenter pull-right"/>
							  					</div>
							  				</div>
							  				<small>Leave blank for theme default</small>
							  				<hr>
							  				<h6>Show these buttons:</h6>
							  				<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Main Downloads Button
											</label>
											<label class="checkbox">
											  	<input type="checkbox" name="" id="" value="">
											  	Clear Finished Button
											</label>
											<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Mini / Full Mode Button
											</label>
							  			</div>
							  		</div>
							  		<div class="span7">
							  			<div class="well">
							  				<h5>Text Sizes</h5>
							  				File Name Size: <input type="text" name="" id="" value="9" class="span2 textcenter"><br />
							  				Progress Notification Size: <input type="text" name="" id="" value="5" class="span2 textcenter">
							  			</div>
							  			<div class="well">
							  				<h5>Download Item Sizes</h5>
							  				Width: <input type="text" name="" id="" value="9" class="span2 textcenter"> Height: <input type="text" name="" id="" value="5" class="span2 textcenter">
							  			</div>
							  			<div class="well" style="height:239px;">
							  				<h5>Speed Colors</h5>
							  				<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Enable Speed Colors
											</label>
											<br />
											<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						<div style="text-align:right;">
							  							<small>Between <input type="text" name="" id="" value="0" class="span2 textcenter"/> and <input type="text" name="" id="" value="50" class="span2 textcenter"/> KB/sec <input type="text" maxlength="6" name="" id="colorpickerField8" value="00ff00" class="span3 cp textcenter"/></small>
							  						</div>
							  					</div>
							  				</div>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						<div style="text-align:right;">
							  							<small>Between <input type="text" name="" id="" value="50" class="span2 textcenter"/> and <input type="text" name="" id="" value="200" class="span2 textcenter"/> KB/sec <input type="text" name="" id="colorpickerField9" value="00ff00" class="span3 cp textcenter"/></small>
							  						</div>
							  					</div>
							  				</div>
							  				<div class="row-fluid row-spacer">
							  					<div class="span12">
							  						<div style="text-align:right;">
							  							<small>Between <input type="text" name="" id="" value="200" class="span2 textcenter"/> and <input type="text" name="" id="" value="400" class="span2 textcenter"/> KB/sec <input type="text" name="" id="colorpickerField10" value="00ff00" class="span3 cp textcenter"/></small>
							  						</div>
							  					</div>
							  				</div>
							  				<div class="row-fluid">
							  					<div class="span12">
							  						<div style="text-align:right;">
							  							<small>More than <input type="text" name="" id="" value="400" class="span2 textcenter"/> KB/sec <input type="text" name="" id="colorpickerField4" value="00ff00" class="span3 cp textcenter"/></small>
							  						</div>
							  					</div>
							  				</div>
							  			</div>
							  		</div>
							  	</div>
							</div>
							<div class="tab-pane" id="cloudsavetab">
								<div id="dealspopover">
									<img src="img/dealspopover.png">
								</div>
							  	<div class="row-fluid">
							  		<div class="span7">
							  			<div class="well" style="position:relative;">
							  				<h5>Cloud Save and Click Deals Status</h5>
							  				<img src="img/cloud-switch.png" style="position:relative; z-index: 25;">
							  				<div id="cloudsave-toggle-button">
											    <input type="checkbox">
											</div>
											<div id="clickdeals-toggle-button">
											    <input type="checkbox">
											</div>
											<div id="dealslogos">
												<img src="img/deals.png">
											</div>
											<div class="greentext">
												<a href="#">How does it work?</a>
											</div>
							  			</div>
							  		</div>
							  		<div class="span5">
							  			<div class="well">
								  			<h5>Additional Hosts</h5>
								  			<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Enable additional hosts
											</label>
								  		</div>
								  		<div class="well">
								  			<h5>Save Local File to Cloud</h5>
								  			<select name="" id="" class="span12">
											  <option>Option 1</option>
											  <option>Option 2</option>
											  <option>Option 3</option>
											  <option>Option 4</option>
											  <option>Option 5</option>
											</select>
											<input type="file" id="file">
										    <div class="dummyfile">
									    	<div class="input-append">
									    		<input id="filename" type="text" class="input disabled span7" name="" readonly>
									    		<a id="fileselectbutton" class="btn btn-inverse">Browse</a>
											</div>
											</div>
								  		</div>
							  		</div>
							  	</div>
							</div>
							<div class="tab-pane" id="virusscan">
							  	<div class="row-fluid">
							  		<div class="span12">
							  			<div class="well">
							  				<h5>Virus Scan</h5>
							  				<label class="checkbox">
											   <input type="checkbox" name="" id="" value="">
											  	Manually scan completed downloads
											</label>
											<br />
											<div class="row-fluid row-spacer">
												<div class="span4">
													Don't scan these filetypes
												</div>
												<div class="span8">
													<input type="text" name="" id="" value="jpg,jpeg,png,gif" class="span10 textcenter">
												</div>
											</div>
											<div class="row-fluid row-spacer">
												<div class="span4">
													<span style="line-height:30px;">Anti-Virus program location</span>
												</div>
												<div class="span8">
													<input type="file" id="vfile">
												    <div class="dummyfile">
														<div class="input-append">
												    		<input id="virusfile" type="text" class="input disabled" name="" readonly style="width:100%;">
												    		<a id="vfileselectbutton" class="btn btn-inverse">Browse</a>
														</div>
													</div>
												</div>
											</div>
											<div class="row-fluid">
												<div class="span4">
													Arguments
												</div>
												<div class="span8">
													<input type="text" name="" id="" value="%1" class="span10 textcenter"><br />
													<small class="offset2">Use %1 in the arguments for the file to scan</small>
												</div>
											</div>
							  			</div>
							  		</div>
							  	</div>
							</div>
						</div>

						<div class="actions clearfix">
							<a href="#" target="_blank">About Download StatusBar</a>
							<button type="button" data-dismiss="modal" aria-hidden="true" class="btn btn-danger pull-right">Cancel</button>
							<button type="submit" class="btn btn-success pull-right">Apply</button>
							<button type="button" class="btn btn-success pull-right">Ok</button>
						</div>
					</div>
				    
				  </div>

				</div>

        	</div>
     	</div>

    </div>

	<!-- JavaScript at the bottom for fast page loading -->

  	<script src="js/jquery.min.js"></script>
  	<script src="js/bootstrap.min.js"></script>
  	<script src="js/toggle.buttons.js"></script>
  	<script src="js/colorpicker/js/colorpicker.js"></script>
  	<script src="js/colorpicker/js/eye.js"></script>
  	<script src="js/colorpicker/js/utils.js"></script>
  	<script src="js/script.js"></script>

  	<!-- end scripts -->

</body>
</html>